/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.math;

import com.terraforged.valley.math.Mth;
import com.terraforged.valley.math.Node;

public record Cell(GridType grid, ResultType result, double jitter) implements Node
{
    public static final double HEX_X_SCALE = 1.0;
    public static final double HEX_Y_SCALE = Math.pow(2.0, 0.25);

    @Override
    public double eval(int seed, double x, double y) {
        return Cell.Sample(seed, x, y, this.jitter, this.grid, this.result);
    }

    @Override
    public double min() {
        return switch (this.result.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> -1.0;
            case 2, 3, 4, 5, 6, 7 -> 0.0;
        };
    }

    @Override
    public double max() {
        return switch (this.result.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 2, 3, 5, 6, 7 -> 1.0;
            case 4 -> 2.0;
        };
    }

    public static double X2D(int hash) {
        return (double)(hash & 0xFFFF) / 65535.0;
    }

    public static double Y2D(int hash) {
        return (double)(hash >> 16 & 0xFFFF) / 65535.0;
    }

    public static double PointX2D(int hash, int cx, int cy, double jitter) {
        double jitterX = (double)(hash & 0xFFFF) / 65535.0;
        return (double)cx + jitterX * jitter;
    }

    public static double PointY2D(int hash, int cx, int cy, double jitter) {
        double jitterY = (double)(hash >> 16 & 0xFFFF) / 65535.0;
        return (double)cy + jitterY * jitter;
    }

    public static double HexPointX2D(int hash, int cx, int cy, double jitter) {
        double offsetX = (double)(cy & 1) * 0.5;
        double jitterX = (double)(hash & 0xFFFF) / 131070.0;
        return (double)cx + offsetX + jitterX * jitter;
    }

    public static double HexPointY2D(int hash, int cx, int cy, double jitter) {
        double jitterY = (double)(hash >> 16 & 0xFFFF) / 65535.0;
        return (double)cy + jitterY * jitter;
    }

    public static double Sample(int seed, double x, double y, double jitter, GridType gridType, ResultType resultType) {
        x = Cell.GridScaleX(gridType, x);
        y = Cell.GridScaleY(gridType, y);
        int maxX = Mth.Floor(x) + 1;
        int maxY = Mth.Floor(y) + 1;
        int hash0 = 0;
        int hash1 = 0;
        double min0 = Double.MAX_VALUE;
        double min1 = Double.MAX_VALUE;
        for (int cy = maxY - 2; cy <= maxY; ++cy) {
            for (int cx = maxX - 2; cx <= maxX; ++cx) {
                int hash = Mth.Hash(seed, cx, cy);
                double dist2 = Cell.GridDist2(x, y, cx, cy, hash, jitter, gridType);
                if (dist2 < min0) {
                    hash1 = hash0;
                    hash0 = hash;
                    min1 = min0;
                    min0 = dist2;
                    continue;
                }
                if (!(dist2 < min1)) continue;
                min1 = dist2;
                hash1 = hash;
            }
        }
        return switch (resultType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Mth.Noise(hash0);
            case 1 -> Mth.Noise(hash1);
            case 2 -> Mth.Sqrt(min0);
            case 3 -> Mth.Sqrt(min1);
            case 7 -> Mth.Sqrt(min1 - min0);
            case 4 -> Mth.Sqrt(min0 + min1);
            case 5 -> Mth.Sqrt(min0 / min1);
            case 6 -> Mth.Sqrt(min0 * min1);
        };
    }

    static double FBM(int seed, double x, double y, double jitter, GridType gridType, ResultType resultType, int octaves, double lacunarity, double gain) {
        double amplitude = 1.0;
        double frequency = 1.0;
        double sum = 0.0;
        double max = 0.0;
        for (int i = 0; i < octaves; ++i) {
            sum += Cell.Sample(seed, x * frequency, y * frequency, jitter, gridType, resultType) * amplitude;
            max += amplitude;
            amplitude *= gain;
            frequency *= lacunarity;
        }
        return sum / max;
    }

    static double FBM(int seed, double x, double y, double[] jitter, GridType[] gridType, ResultType[] resultType, double[] lacunarity, double[] gain) {
        assert (jitter.length >= gain.length);
        assert (gridType.length >= gain.length);
        assert (resultType.length >= gain.length);
        assert (lacunarity.length >= gain.length);
        double sum = 0.0;
        double max = 0.0;
        for (int i = 0; i < gain.length; ++i) {
            sum += Cell.Sample(seed, x * lacunarity[i], y * lacunarity[i], jitter[i], gridType[i], resultType[i]) * gain[i];
            max += gain[i];
        }
        return sum / max;
    }

    public static double GridScaleX(GridType type, double x) {
        return x;
    }

    public static double GridScaleY(GridType type, double y) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> y;
            case 1 -> y * HEX_Y_SCALE;
        };
    }

    public static double PointX(GridType type, int hash, int cx, int cy, double jitter) {
        return type == GridType.HEX ? Cell.HexPointX2D(hash, cx, cy, jitter) : Cell.PointX2D(hash, cx, cy, jitter);
    }

    public static double PointY(GridType type, int hash, int cx, int cy, double jitter) {
        return type == GridType.HEX ? Cell.HexPointY2D(hash, cx, cy, jitter) : Cell.PointY2D(hash, cx, cy, jitter);
    }

    private static double GridDist2(double x, double y, int cx, int cy, int hash, double jitter, GridType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Mth.Dist2(x, y, Cell.PointX2D(hash, cx, cy, jitter), Cell.PointY2D(hash, cx, cy, jitter));
            case 1 -> Mth.Dist2(x, y, Cell.HexPointX2D(hash, cx, cy, jitter), Cell.HexPointY2D(hash, cx, cy, jitter));
        };
    }

    public static enum GridType {
        SQUARE,
        HEX;


        public static GridType[] Of(GridType ... args) {
            return args;
        }
    }

    public static enum ResultType {
        VALUE_0,
        VALUE_1,
        DIST_0,
        DIST_1,
        DIST_ADD,
        DIST_DIV,
        DIST_MUL,
        DIST_SUB;


        public static ResultType[] Of(ResultType ... args) {
            return args;
        }
    }
}

