/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.math;

public interface Mth {
    public static final int PRIME_X = 501125321;
    public static final int PRIME_Y = 1136930381;
    public static final int PRIME_Z = 1720413743;
    public static final int PRIME_W = 1066037191;
    public static final int PHI = -1640531527;

    public static int Hash(int seed, int x, int y) {
        int hash = seed;
        hash ^= x * 501125321 ^ y * 1136930381;
        return hash *= -1640531527;
    }

    public static double Noise(int hash) {
        return (double)hash / 2.147483647E9;
    }

    public static boolean InBounds(int x, int y, int minX, int minY, int maxX, int maxY) {
        return x >= minX && x <= maxX && y >= minY && y <= maxY;
    }

    public static int Clamp(int x, int min, int max) {
        return x <= min ? min : (x >= max ? max : x);
    }

    public static float Clamp(float x, float min, float max) {
        return x <= min ? min : (x >= max ? max : x);
    }

    public static double Clamp(double x, double min, double max) {
        return x <= min ? min : (x >= max ? max : x);
    }

    public static double Interp3(double t) {
        return t * t * (3.0 - 2.0 * t);
    }

    public static double Normalize(double x, double min, double max) {
        return (Mth.Clamp(x, min, max) - min) / (max - min);
    }

    public static float Normalize(float x, float min, float max) {
        return (Mth.Clamp(x, min, max) - min) / (max - min);
    }

    public static double Min(double a, double b) {
        return a < b ? a : b;
    }

    public static double Max(double a, double b) {
        return a > b ? a : b;
    }

    public static int Ceil(float value) {
        return value < 0.0f ? (int)value : (int)value + 1;
    }

    public static int Ceil(double value) {
        return value < 0.0 ? (int)value : (int)value + 1;
    }

    public static int Round(float value) {
        return (int)(value + 0.5f);
    }

    public static int Floor(float value) {
        return value > 0.0f ? (int)value : (int)value - 1;
    }

    public static int Floor(double value) {
        return value > 0.0 ? (int)value : (int)value - 1;
    }

    public static long Pack(int x, int y) {
        return (long)x << 32 | (long)y & 0xFFFFFFFFL;
    }

    public static int Mix(int x) {
        int h = x * -1640531527;
        return h ^ h >>> 16;
    }

    public static long Mix(long x) {
        long h = x * -7046029254386353131L;
        h ^= h >>> 32;
        return h ^ h >>> 16;
    }

    public static int SizeBits(int value) {
        return 32 - Integer.numberOfLeadingZeros(value);
    }

    public static int SizePow2(int value) {
        return 1 << Mth.SizeBits(value);
    }

    public static float Lerp(float min, float max, float t) {
        return min + (max - min) * t;
    }

    public static double Lerp(double min, double max, double t) {
        return min + (max - min) * t;
    }

    public static float ClampLerp(float min, float max, float t) {
        return min + (max - min) * Mth.Clamp(t, 0.0f, 1.0f);
    }

    public static double ClampLerp(double min, double max, double t) {
        return min + (max - min) * Mth.Clamp(t, 0.0, 1.0);
    }

    public static float Atan2(float y, float x) {
        return (float)Math.atan2(y, x);
    }

    public static double Atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public static float Cos(float value) {
        return (float)Math.cos(value);
    }

    public static double Cos(double value) {
        return Math.cos(value);
    }

    public static float Sin(float value) {
        return (float)Math.sin(value);
    }

    public static double Sin(double value) {
        return Math.sin(value);
    }

    public static float Tan(float value) {
        return (float)Math.tan(value);
    }

    public static double Tan(double value) {
        return Math.tan(value);
    }

    public static float Sqrt(float value) {
        return (float)Math.sqrt(value);
    }

    public static double Sqrt(double value) {
        return Math.sqrt(value);
    }

    public static double Pow2(double value) {
        return value * value;
    }

    public static double Pow3(double value) {
        return value * value * value;
    }

    public static double Pow4(double value) {
        double pow2 = value * value;
        return pow2 * pow2;
    }

    public static float Pow4(float value) {
        float pow2 = value * value;
        return pow2 * pow2;
    }

    public static int Set(int set, int bit) {
        return set | 1 << bit;
    }

    public static int Unset(int set, int bit) {
        return set & ~(1 << bit);
    }

    public static boolean IsSet(int set, int bit) {
        return (set & 1 << bit) != 0;
    }

    public static double Dist2(double ax, double ay, double bx, double by) {
        double dx = bx - ax;
        double dy = by - ay;
        return dx * dx + dy * dy;
    }

    public static double LineDist(double x, double y, double ax, double ay, double bx, double by) {
        double A = x - ax;
        double B = y - ay;
        double C = bx - ax;
        double D = by - ay;
        double dot = A * C + B * D;
        double d2 = C * C + D * D;
        double t = d2 == 0.0 ? -1.0 : dot / d2;
        double px = Mth.ClampLerp(ax, bx, t);
        double py = Mth.ClampLerp(ay, by, t);
        double dx = x - px;
        double dy = y - py;
        return dx * dx + dy * dy;
    }

    public static double LineDist(double x, double y, double ax, double ay, double ar, double bx, double by, double br) {
        double pr;
        double pr2;
        double py;
        double dy;
        double A = x - ax;
        double B = y - ay;
        double C = bx - ax;
        double D = by - ay;
        double len2 = C * C + D * D;
        double t = len2 == 0.0 ? -1.0 : (A * C + B * D) / len2;
        double px = Mth.ClampLerp(ax, bx, t);
        double dx = x - px;
        double d2 = dx * dx + (dy = y - (py = Mth.ClampLerp(ay, by, t))) * dy;
        if (d2 > (pr2 = (pr = Mth.ClampLerp(ar, br, t)) * pr)) {
            return 1.0;
        }
        return d2 / pr2;
    }
}

