/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.math;

import com.terraforged.valley.math.Mth;
import com.terraforged.valley.math.Node;

public record Simplex() implements Node
{
    public static final Simplex INSTANCE = new Simplex();
    private static final double F2 = 0.366025403784439;
    private static final double G2 = 0.211324865405187;
    private static final double[] GRAD_2D = new double[]{0.13052618503570557, 0.9914448857307434, 0.3826834261417389, 0.9238795042037964, 0.6087614297866821, 0.7933533191680908, 0.6087614297866821, 0.7933533191680908, 0.7933533191680908, 0.6087614297866821, 0.9238795042037964, 0.3826834261417389, 0.9914448857307434, 0.13052618503570557, 0.9914448857307434, 0.13052618503570557, 0.9914448857307434, -0.13052618503570557, 0.9238795042037964, -0.3826834261417389, 0.7933533191680908, -0.6087614297866821, 0.7933533191680908, -0.6087614297866821, 0.6087614297866821, -0.7933533191680908, 0.3826834261417389, -0.9238795042037964, 0.13052618503570557, -0.9914448857307434, 0.13052618503570557, -0.9914448857307434, -0.13052618503570557, -0.9914448857307434, -0.3826834261417389, -0.9238795042037964, -0.6087614297866821, -0.7933533191680908, -0.6087614297866821, -0.7933533191680908, -0.7933533191680908, -0.6087614297866821, -0.9238795042037964, -0.3826834261417389, -0.9914448857307434, -0.13052618503570557, -0.9914448857307434, -0.13052618503570557, -0.9914448857307434, 0.13052618503570557, -0.9238795042037964, 0.3826834261417389, -0.7933533191680908, 0.6087614297866821, -0.7933533191680908, 0.6087614297866821, -0.6087614297866821, 0.7933533191680908, -0.3826834261417389, 0.9238795042037964, -0.13052618503570557, 0.9914448857307434, -0.13052618503570557, 0.9914448857307434};

    @Override
    public double eval(int seed, double x, double y) {
        return Simplex.Sample(seed, x, y);
    }

    @Override
    public double min() {
        return -1.0;
    }

    @Override
    public double max() {
        return 1.0;
    }

    public static double Sample(int seed, double x, double y) {
        double Y0;
        double y0;
        int j;
        double g;
        double t = (x + y) * 0.366025403784439;
        int i = Mth.Floor(x + t);
        double X0 = (double)i - (g = (double)(i + (j = Mth.Floor(y + t))) * 0.211324865405187);
        double x0 = x - X0;
        int i1 = x0 > (y0 = y - (Y0 = (double)j - g)) ? 1 : 0;
        int j1 = x0 > y0 ? 0 : 1;
        double x1 = x0 - (double)i1 + 0.211324865405187;
        double y1 = y0 - (double)j1 + 0.211324865405187;
        double x2 = x0 - 1.0 + 0.422649730810374;
        double y2 = y0 - 1.0 + 0.422649730810374;
        double t0 = 0.5 - x0 * x0 - y0 * y0;
        double t1 = 0.5 - x1 * x1 - y1 * y1;
        double t2 = 0.5 - x2 * x2 - y2 * y2;
        double n0 = t0 < 0.0 ? 0.0 : Simplex.GradCoord2D(seed, i, j, x0, y0, t0);
        double n1 = t1 < 0.0 ? 0.0 : Simplex.GradCoord2D(seed, i + i1, j + j1, x1, y1, t1);
        double n2 = t2 < 0.0 ? 0.0 : Simplex.GradCoord2D(seed, i + 1, j + 1, x2, y2, t2);
        return 99.83685446303647 * (n0 + n1 + n2);
    }

    public static double FBM(int seed, double x, double y, int octaves, double lacunarity, double gain) {
        double amplitude = 1.0;
        double frequency = 1.0;
        double sum = 0.0;
        double max = 0.0;
        for (int i = 0; i < octaves; ++i) {
            sum += Simplex.Sample(seed, x * frequency, y * frequency) * amplitude;
            max += amplitude;
            amplitude *= gain;
            frequency *= lacunarity;
        }
        return sum / max;
    }

    private static double GradCoord2D(int seed, int x, int y, double xd, double yd, double t) {
        int hash = seed;
        hash ^= 501125321 * x ^ 1136930381 * y;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        int index = (int)((float)(hash & 0x3FFFFF) * 1.3333334f) & 0x1F;
        t *= t;
        t *= t;
        return (xd * GRAD_2D[index <<= 1] + yd * GRAD_2D[index + 1]) * t;
    }
}

