/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;

public record Spline(double[] inputs, double[] outputs) {
    public double eval(double value) {
        return Spline.Eval(value, this.inputs, this.outputs);
    }

    public List<Point> toList() {
        ArrayList<Point> list = new ArrayList<Point>(this.inputs.length);
        double last = this.outputs.length > 0 ? this.outputs[this.outputs.length - 1] : 0.0;
        for (int i = 0; i < this.inputs.length; ++i) {
            double in = this.inputs[i];
            double out = i < this.outputs.length ? this.outputs[i] : last;
            list.add(new Point(in, out));
        }
        return list;
    }

    public static Spline FromList(List<Point> points) {
        double[] inputs = new double[points.size()];
        double[] outputs = new double[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            inputs[i] = points.get((int)i).in;
            outputs[i] = points.get((int)i).out;
        }
        return new Spline(inputs, outputs);
    }

    public static double Eval(double value, double[] inputs, double[] outputs) {
        if (inputs.length == 0) {
            return value;
        }
        if (value <= inputs[0]) {
            return outputs[0];
        }
        for (int i = 1; i < inputs.length; ++i) {
            if (!(value <= inputs[i])) continue;
            double t = (value - inputs[i - 1]) / (inputs[i] - inputs[i - 1]);
            return outputs[i - 1] + (outputs[i] - outputs[i - 1]) * t;
        }
        return outputs[outputs.length - 1];
    }

    public static Spline[] ArrayOf(Spline ... splines) {
        return splines;
    }

    public static Spline Of(double[][] points) {
        return Spline.Of(points, (T point, double[] buf) -> {
            buf[0] = point[0];
            buf[1] = point[1];
        });
    }

    public static <T> Spline Of(T[] points, BiConsumer<T, double[]> reader) {
        double[] buf = new double[2];
        double[] inputs = new double[points.length];
        double[] outputs = new double[points.length];
        int i = 0;
        for (T point : points) {
            reader.accept(point, buf);
            inputs[i] = buf[0];
            outputs[i] = buf[1];
            ++i;
        }
        return new Spline(inputs, outputs);
    }

    public static <T> Spline Of(Collection<T> points, BiConsumer<T, double[]> reader) {
        double[] buf = new double[2];
        double[] inputs = new double[points.size()];
        double[] outputs = new double[points.size()];
        int i = 0;
        for (T point : points) {
            reader.accept(point, buf);
            inputs[i] = buf[0];
            outputs[i] = buf[1];
            ++i;
        }
        return new Spline(inputs, outputs);
    }

    public record Point(double in, double out) {
        public List<Double> toList() {
            return List.of(Double.valueOf(this.in), Double.valueOf(this.out));
        }

        public static Point FromList(List<Double> list) {
            return new Point(list.getFirst(), list.getLast());
        }
    }
}

