/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.world.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraforged.valley.codec.Codecs;
import com.terraforged.valley.codec.RefCodec;
import com.terraforged.valley.codec.SeedCodec;
import com.terraforged.valley.math.Node;
import com.terraforged.valley.math.Spline;
import com.terraforged.valley.world.density.DensityNode;
import com.terraforged.valley.world.river.River;
import com.terraforged.valley.world.river.RiverGenerator;
import net.minecraft.class_6910;
import net.minecraft.class_6954;
import net.minecraft.class_7243;
import org.jetbrains.annotations.NotNull;

public record RiverFunction(int seed, River.Config config, Spline output, DensityNode continents, River.RegionCache cache) implements class_6910.class_6913
{
    public static final MapCodec<RiverFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SeedCodec.FieldOf("seed").forGetter(RiverFunction::seed), (App)Codecs.RIVER.fieldOf("config").orElseGet(River.Config::Defaults).forGetter(RiverFunction::config), (App)Codecs.SPLINE.fieldOf("shape").orElseGet(RiverFunction::DefaultOutput).forGetter(RiverFunction::output), (App)RefCodec.of(class_6954.field_37122).xmap(DensityNode::new, DensityNode::entry).forGetter(RiverFunction::continents)).apply((Applicative)instance, RiverFunction::new));
    public static final class_7243<RiverFunction> CODEC_HOLDER = class_7243.method_42116(CODEC);

    private RiverFunction(int seed, River.Config config, Spline output, DensityNode continents) {
        this(seed, config, output, continents, River.RegionCache.Create());
    }

    public double comp_377() {
        return -1.0;
    }

    public double comp_378() {
        return 1.0;
    }

    public double method_40464(class_6910.class_6912 ctx) {
        int x = ctx.comp_371();
        int z = ctx.comp_373();
        Node noise = this.continents.node();
        double dist = RiverGenerator.Sample(this.seed, x, z, noise, this.config, this.cache);
        double sign = RiverGenerator.Sign(this.seed, x, z);
        return sign * this.output.eval(dist);
    }

    @NotNull
    public class_6910 method_40469(class_6910.class_6915 visitor) {
        this.continents.visit(visitor);
        return this;
    }

    @NotNull
    public class_7243<RiverFunction> method_41062() {
        return CODEC_HOLDER;
    }

    public static RiverFunction Preset() {
        return new RiverFunction(0, River.Config.Defaults(), RiverFunction.DefaultOutput(), DensityNode.EMPTY, null);
    }

    private static Spline DefaultOutput() {
        return Spline.Of(new double[][]{{0.0, 1.0}, {0.85, 0.3}, {1.0, 0.0}});
    }
}

