/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.world.river;

import com.terraforged.valley.math.Mth;
import com.terraforged.valley.math.Spline;
import com.terraforged.valley.sync.Computable;
import com.terraforged.valley.util.Cache;
import java.util.Arrays;

public interface River {
    public static final int EVAL_RADIUS = 2;
    public static final int EVAL_WIDTH = 5;
    public static final int SAMPLE_RADIUS = 4;
    public static final int SAMPLE_WIDTH = 9;
    public static final int[] EVAL_CELLS = River.InitEvalCells(new int[25]);
    public static final int[] CONNECTION_CELLS = River.InitConnections(new int[4]);
    public static final int[][] SAMPLE_OFFSETS = River.InitOffsets(new int[81][2]);
    public static final int LOCAL_CACHE_SIZE = 8;
    public static final int SHARED_CACHE_SIZE = 256;
    public static final Config DEFAULTS = Config.Defaults();

    private static int[] InitEvalCells(int[] indices) {
        int center = 40;
        int i = 0;
        for (int y = -2; y <= 2; ++y) {
            int x = -2;
            while (x <= 2) {
                indices[i] = 40 + 9 * y + x;
                ++x;
                ++i;
            }
        }
        return indices;
    }

    private static int[][] InitOffsets(int[][] offsets) {
        int i = 0;
        for (int dy = -4; dy <= 4; ++dy) {
            int dx = -4;
            while (dx <= 4) {
                offsets[i][0] = dx++;
                offsets[i][1] = dy;
                ++i;
            }
        }
        return offsets;
    }

    private static int[] InitConnections(int[] indices) {
        indices[0] = -9;
        indices[1] = -1;
        indices[2] = 1;
        indices[3] = 9;
        return indices;
    }

    public record Config(int scale, double freq, double ocean, double coast, Spline riverRadius, Spline valleyRadius) {
        public Config(int scale, double ocean, double coast, Spline riverRadius, Spline valleyRadius) {
            this(scale, 1.0 / Mth.Max(scale, 1.0), ocean, coast, riverRadius, valleyRadius);
        }

        public static Config Defaults() {
            return new Config(300, -0.25, -0.19, Config.RiverRadius(), Config.ValleyRadius());
        }

        public static Spline RiverRadius() {
            return Spline.Of(new double[][]{{-0.19, 0.15}, {0.1, 0.1}, {1.0, 0.03}});
        }

        public static Spline ValleyRadius() {
            return Spline.Of(new double[][]{{-0.19, 1.0}, {1.0, 0.8}});
        }
    }

    public static class RegionCache {
        private final Cache.Concurrent<Region> cache;
        private final Cache.ComputeFunction<Region> lookup = this::lookup;
        private final Cache.ComputeFunction<Region> allocate = this::allocate;

        public RegionCache(int size, int concurrency) {
            this.cache = new Cache.Concurrent<Region>(size, concurrency, Region[]::new, v -> {});
        }

        private Region lookup(long key) {
            return this.cache.computeIfAbsent(key, this.allocate);
        }

        private Region allocate(long key) {
            return new Region();
        }

        public static RegionCache Create() {
            return new RegionCache(256, Runtime.getRuntime().availableProcessors());
        }
    }

    public static class Region
    extends Computable {
        private static final int INITIAL_CAPACITY = 16;
        private static final Segment[] EMPTY = new Segment[0];
        public int size = 0;
        public Segment[] segments = EMPTY;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transfer(Buffer buffer) {
            Region region = this;
            synchronized (region) {
                int tail = this.size;
                int size = tail + buffer.region.size;
                if (this.segments.length < size) {
                    this.segments = Arrays.copyOf(this.segments, size);
                }
                for (int i = 0; i < buffer.region.size; ++i) {
                    this.segments[tail + i] = buffer.region.segments[i];
                    buffer.region.segments[i] = null;
                }
                this.size = size;
                buffer.region.size = 0;
            }
        }

        public static class Buffer {
            private final Region region = new Region();

            public void add(Segment segment) {
                int index;
                if ((index = this.region.size++) >= this.region.segments.length) {
                    int capacity = index == 0 ? 16 : this.region.segments.length << 1;
                    this.region.segments = Arrays.copyOf(this.region.segments, capacity);
                }
                this.region.segments[index] = segment;
            }
        }
    }

    public static class Segment {
        private static final int AX = 0;
        private static final int AY = 1;
        private static final int BX = 2;
        private static final int BY = 3;
        private static final int AN = 4;
        private static final int BN = 5;
        private static final int WARP = 6;
        private final double[] data = new double[7];

        public double project(double x, double y) {
            double bax = this.data[2] - this.data[0];
            double bay = this.data[3] - this.data[1];
            double dot = (x - this.data[0]) * bax + (y - this.data[1]) * bay;
            double prod = bax * bax + bay * bay;
            return prod == 0.0 ? 0.0 : dot / prod;
        }

        public double noise(double t) {
            return t <= 0.0 ? this.data[4] : (t >= 1.0 ? this.data[5] : this.data[4] + (this.data[5] - this.data[4]) * t);
        }

        public double dist2(double x, double y, double t) {
            double px;
            double pad = 0.05;
            double warp = Mth.Normalize(t, 0.05, 0.95);
            warp = warp < 0.5 ? warp / 0.5 : (1.0 - warp) / 0.5;
            warp = Mth.Interp3(warp);
            double d = t <= 0.0 ? this.data[0] : (px = t >= 1.0 ? this.data[2] : this.data[0] + (this.data[2] - this.data[0]) * t);
            double py = t <= 0.0 ? this.data[1] : (t >= 1.0 ? this.data[3] : this.data[1] + (this.data[3] - this.data[1]) * t);
            double wx = px + (warp *= this.data[6]) * (this.data[3] - this.data[1]);
            double wy = py - warp * (this.data[2] - this.data[0]);
            double dx = x - wx;
            double dy = y - wy;
            double d2 = dx * dx + dy * dy;
            return Mth.Min(d2, 1.0);
        }

        public static Segment Of(double ax, double ay, double an, double bx, double by, double bn, double warp) {
            Segment segment = new Segment();
            segment.data[0] = ax;
            segment.data[1] = ay;
            segment.data[4] = an;
            segment.data[2] = bx;
            segment.data[3] = by;
            segment.data[5] = bn;
            segment.data[6] = warp;
            return segment;
        }
    }

    public static class Sampler {
        public static final int SIZE = 81;
        public static final ThreadLocal<Sampler> LOCAL = ThreadLocal.withInitial(Sampler::new);
        public double cachedValue = 0.0;
        public int cachedX = Integer.MIN_VALUE;
        public int cachedZ = Integer.MIN_VALUE;
        public final int[] hash = new int[81];
        public final double[] x = new double[81];
        public final double[] y = new double[81];
        public final double[] noise = new double[81];
        public final Region.Buffer buffer = new Region.Buffer();
        private final Cache.Linear<Region> localCache = new Cache.Linear(8, Region[]::new);

        public Region region(int x, int z, RegionCache sharedCache) {
            return this.localCache.computeIfAbsent(Mth.Pack(x, z), sharedCache.lookup);
        }
    }
}

