/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example;

import baritone.api.BaritoneAPI;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.example.bloodmoon.limiter.BloodmoonMobLimiter;
import net.fabricmc.example.bloodmoon.proxy.ClientProxy;
import net.fabricmc.example.bloodmoon.proxy.CommonProxy;
import net.fabricmc.example.bloodmoon.server.BloodmoonHandler;
import net.fabricmc.example.bloodmoon.server.CommandBloodmoon;
import net.fabricmc.example.client.darkness.ClientModPacket;
import net.fabricmc.example.client.darkness.ModPlayerData;
import net.fabricmc.example.client.payload.BaritoneCustomPayload;
import net.fabricmc.example.command.OptimizedMobitoneCommand;
import net.fabricmc.example.command.TrueDarknessEnforcedCommand;
import net.fabricmc.example.command.bloodmoon.BloodmoonChancePercentageCommand;
import net.fabricmc.example.command.bloodmoon.BloodmoonSpawnRatePercentageCommand;
import net.fabricmc.example.command.bloodmoon.BuildingMiningMobsDuringBloodmoonOnly;
import net.fabricmc.example.command.bloodmoon.DaysBeforeBloodmoonPossibilityCommand;
import net.fabricmc.example.command.mob.AllowBreakCommand;
import net.fabricmc.example.command.mob.AllowPlaceCommand;
import net.fabricmc.example.command.mob.CreeperHissCommand;
import net.fabricmc.example.command.mob.CreepersExplodeObstructionsCommand;
import net.fabricmc.example.command.mob.InfiniteZombieBlocksCommand;
import net.fabricmc.example.command.mob.RaidersBreakBlocksCommand;
import net.fabricmc.example.command.mob.SkeletonsBreakBlocksCommand;
import net.fabricmc.example.command.mob.SpiderSpeedCommand;
import net.fabricmc.example.command.mob.WitchesBreakBlocksCommand;
import net.fabricmc.example.command.mob.ZombiesBreakAndPlaceBlocksCommand;
import net.fabricmc.example.command.mob.debug.GoalInfoCommand;
import net.fabricmc.example.command.mob.debug.IsolatePathCommand;
import net.fabricmc.example.command.mob.debug.ResetPathsCommand;
import net.fabricmc.example.command.mob.debug.UndoIsolatedPathCommand;
import net.fabricmc.example.command.mob.penalty.MobBlockBreakAdditionalPenaltyCommand;
import net.fabricmc.example.command.mob.penalty.MobBlockPlacementPenaltyCommand;
import net.fabricmc.example.command.mob.penalty.MobJumpPenaltyCommand;
import net.fabricmc.example.command.mob.speed.MobBlockBreakSpeedCommand;
import net.fabricmc.example.command.performance.FailureTimeoutCommand;
import net.fabricmc.example.command.performance.PlanAheadFailureTimeoutCommand;
import net.fabricmc.example.command.performance.PlanAheadPrimaryTimeoutCommand;
import net.fabricmc.example.command.performance.PrimaryTimeoutCommand;
import net.fabricmc.example.command.performance.SlowPathCommand;
import net.fabricmc.example.command.performance.SlowPathDelayCommand;
import net.fabricmc.example.config.ConfigManager;
import net.fabricmc.example.mobai.PathfindingBlockRegistry;
import net.fabricmc.example.util.MinecraftServerUtil;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1311;
import net.minecraft.class_1551;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2168;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnhancedMobsMod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"bloodmoon");
    public static CommonProxy proxy;
    private static final int DEFAULT_PATHING_MAX_CHUNK_BORDER_FETCH = 50;
    private static final double DEFAULT_COST_HEURISTIC = 3.0;
    private static final int DEFAULT_PATH_CUTOFF_MINIMUM_LENGTH = 5;
    private static final double DEFAULT_MAX_COST_INCREASE = 10.0;
    private static final ScheduledExecutorService scheduler;

    public void onInitialize() {
        System.out.println("Initializing mod...");
        PayloadTypeRegistry.playS2C().register(BaritoneCustomPayload.ID, BaritoneCustomPayload.CODEC);
        ServerEntityEvents.ENTITY_LOAD.register(this::onEntityLoad);
        ServerEntityEvents.ENTITY_LOAD.register((entity, serverWorld) -> {
            if (entity instanceof class_1642) {
                class_1937 world = entity.method_37908();
                class_2338 pos = entity.method_24515();
                class_6880 biome = world.method_23753(pos);
                Random random = new Random();
                if (random.nextInt(10) < 3) {
                    class_1799 stack = this.getRandomBlockStack((class_6880<class_1959>)biome, random);
                    ((class_1642)entity).method_5673(class_1304.field_6173, stack);
                }
                if (entity instanceof class_1551 && BloodmoonHandler.INSTANCE.isBloodmoonActive()) {
                    double tridentChance = 3.0;
                    HashSet<class_1299> boatTypes = new HashSet<class_1299>();
                    boatTypes.add(class_1299.field_54408);
                    boatTypes.add(class_1299.field_54415);
                    boatTypes.add(class_1299.field_54420);
                    boatTypes.add(class_1299.field_54421);
                    boatTypes.add(class_1299.field_54406);
                    boatTypes.add(class_1299.field_54407);
                    boatTypes.add(class_1299.field_54412);
                    boatTypes.add(class_1299.field_54413);
                    boatTypes.add(class_1299.field_54414);
                    boatTypes.add(class_1299.field_54409);
                    boatTypes.add(class_1299.field_54422);
                    boatTypes.add(class_1299.field_54423);
                    boatTypes.add(class_1299.field_54416);
                    boatTypes.add(class_1299.field_54417);
                    boatTypes.add(class_1299.field_54410);
                    boatTypes.add(class_1299.field_54411);
                    boatTypes.add(class_1299.field_54419);
                    boatTypes.add(class_1299.field_54418);
                    List nearbyPlayersInBoats = world.method_8390(class_1657.class, entity.method_5829().method_1014(100.0), player -> player.method_5765() && boatTypes.contains(player.method_5854().method_5864()));
                    if (!nearbyPlayersInBoats.isEmpty()) {
                        tridentChance = 7.0;
                    }
                    if (random.nextDouble() < tridentChance / 10.0) {
                        ((class_1642)entity).method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8547));
                    }
                }
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
                    // empty if block
                }
            }
        });
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            proxy = new ClientProxy();
            ((ClientProxy)proxy).onInitializeClient();
        } else {
            proxy = new CommonProxy();
        }
        proxy.preInit();
        proxy.init();
        proxy.postInit();
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3780() % 200 == 0) {
                PathfindingBlockRegistry.cleanup();
            }
        });
        BloodmoonMobLimiter.register();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            CommandBloodmoon.register((CommandDispatcher<class_2168>)dispatcher);
            AllowPlaceCommand.register((CommandDispatcher<class_2168>)dispatcher);
            AllowBreakCommand.register((CommandDispatcher<class_2168>)dispatcher);
            CreepersExplodeObstructionsCommand.register((CommandDispatcher<class_2168>)dispatcher);
            RaidersBreakBlocksCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SkeletonsBreakBlocksCommand.register((CommandDispatcher<class_2168>)dispatcher);
            WitchesBreakBlocksCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ZombiesBreakAndPlaceBlocksCommand.register((CommandDispatcher<class_2168>)dispatcher);
            MobBlockBreakAdditionalPenaltyCommand.register((CommandDispatcher<class_2168>)dispatcher);
            MobBlockPlacementPenaltyCommand.register((CommandDispatcher<class_2168>)dispatcher);
            MobJumpPenaltyCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TrueDarknessEnforcedCommand.register((CommandDispatcher<class_2168>)dispatcher);
            OptimizedMobitoneCommand.register((CommandDispatcher<class_2168>)dispatcher);
            InfiniteZombieBlocksCommand.register((CommandDispatcher<class_2168>)dispatcher);
            MobBlockBreakSpeedCommand.register((CommandDispatcher<class_2168>)dispatcher);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
                IsolatePathCommand.register((CommandDispatcher<class_2168>)dispatcher);
                UndoIsolatedPathCommand.register((CommandDispatcher<class_2168>)dispatcher);
                ResetPathsCommand.register((CommandDispatcher<class_2168>)dispatcher);
            }
            GoalInfoCommand.register((CommandDispatcher<class_2168>)dispatcher);
            BloodmoonSpawnRatePercentageCommand.register((CommandDispatcher<class_2168>)dispatcher);
            BloodmoonChancePercentageCommand.register((CommandDispatcher<class_2168>)dispatcher);
            DaysBeforeBloodmoonPossibilityCommand.register((CommandDispatcher<class_2168>)dispatcher);
            BuildingMiningMobsDuringBloodmoonOnly.register((CommandDispatcher<class_2168>)dispatcher);
            CreeperHissCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SpiderSpeedCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SlowPathDelayCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SlowPathCommand.register((CommandDispatcher<class_2168>)dispatcher);
            PrimaryTimeoutCommand.register((CommandDispatcher<class_2168>)dispatcher);
            FailureTimeoutCommand.register((CommandDispatcher<class_2168>)dispatcher);
            PlanAheadPrimaryTimeoutCommand.register((CommandDispatcher<class_2168>)dispatcher);
            PlanAheadFailureTimeoutCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            MinecraftServerUtil.setMinecraftServer(server);
            baritone.api.utils.MinecraftServerUtil.setMinecraftServer((MinecraftServer)server);
            ConfigManager.loadConfig();
            ConfigManager.getConfig().setSlowPath(false);
            ConfigManager.saveConfig();
            BaritoneAPI.getSettings().blockPlacementPenalty.value = ConfigManager.getConfig().getMobBlockPlacementPenalty();
            BaritoneAPI.getSettings().blockBreakAdditionalPenalty.value = ConfigManager.getConfig().getMobBlockBreakAdditionalPenalty();
            BaritoneAPI.getSettings().jumpPenalty.value = ConfigManager.getConfig().getMobJumpPenalty();
            BaritoneAPI.getSettings().allowPlace.value = ConfigManager.getConfig().isAllowPlace();
            BaritoneAPI.getSettings().allowBreak.value = ConfigManager.getConfig().isAllowBreak();
            BaritoneAPI.getSettings().slowPath.value = ConfigManager.getConfig().isSlowPath();
            BaritoneAPI.getSettings().slowPathTimeDelayMS.value = ConfigManager.getConfig().getSlowPathDelay();
            BaritoneAPI.getSettings().pathingMaxChunkBorderFetch.value = 50;
            BaritoneAPI.getSettings().costHeuristic.value = 3.0;
            BaritoneAPI.getSettings().pathCutoffMinimumLength.value = 5;
            BaritoneAPI.getSettings().maxCostIncrease.value = 10.0;
            LOGGER.info("Server is starting");
        });
        ClientModPacket.register();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            ((ModPlayerData)handler.method_32311()).setHasMod(false);
            scheduler.schedule(() -> server.execute(() -> {
                if (!((ModPlayerData)handler.method_32311()).hasMod() && ConfigManager.getConfig().isTrueDarknessEnforced()) {
                    handler.method_52396((class_2561)class_2561.method_43470((String)"You must have Zante's True Darkness mod installed to join this server."));
                }
            }), 5L, TimeUnit.SECONDS);
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            boolean isClientOnServer;
            if (world.method_8320(hitResult.method_17777()).method_26204() instanceof class_2244 && !(isClientOnServer = this.isClientConnectedToServer()) && BloodmoonHandler.INSTANCE.isBloodmoonActive() && player instanceof class_3222) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        EntitySleepEvents.START_SLEEPING.register((player, pos) -> {
            boolean isClientOnServer = this.isClientConnectedToServer();
            if (!isClientOnServer && BloodmoonHandler.INSTANCE.isBloodmoonActive() && player instanceof class_3222) {
                player.method_18400();
                ((class_3222)player).method_64398((class_2561)class_2561.method_43470((String)"You cannot sleep right now!"));
            }
        });
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9423, class_1972.field_9446}), (class_1311)class_1311.field_6302, (class_1299)class_1299.field_6123, (int)100, (int)1, (int)4);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9462}), (class_1311)class_1311.field_6302, (class_1299)class_1299.field_6051, (int)95, (int)1, (int)4);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9462}), (class_1311)class_1311.field_6302, (class_1299)class_1299.field_6046, (int)100, (int)1, (int)4);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9462}), (class_1311)class_1311.field_6302, (class_1299)class_1299.field_6137, (int)100, (int)1, (int)4);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9462}), (class_1311)class_1311.field_6302, (class_1299)class_1299.field_6079, (int)100, (int)1, (int)4);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9462}), (class_1311)class_1311.field_6302, (class_1299)class_1299.field_6145, (int)5, (int)1, (int)1);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9462}), (class_1311)class_1311.field_6302, (class_1299)class_1299.field_6091, (int)10, (int)1, (int)4);
        System.out.println("Initializing mod complete");
    }

    private boolean isClientConnectedToServer() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            class_310 client = class_310.method_1551();
            return client.method_1562() != null && client.field_1687 != null;
        }
        return false;
    }

    private void onPlayerJoin(class_3222 player, MinecraftServer server) {
        server.method_3760().method_14582(player.method_7334());
    }

    private class_1799 getRandomBlockStack(class_6880<class_1959> biome, Random random) {
        class_1799 stack;
        int amount = random.nextInt(10) + 1;
        if (biome.method_40225(class_1972.field_9424)) {
            stack = new class_1799((class_1935)class_1802.field_20384, amount);
        } else if (biome.method_40225(class_1972.field_9461) || biome.method_40225(class_1972.field_23859) || biome.method_40225(class_1972.field_22077) || biome.method_40225(class_1972.field_22075) || biome.method_40225(class_1972.field_22076)) {
            class_1799[] netherBlocks = new class_1799[]{new class_1799((class_1935)class_1802.field_8328, amount), new class_1799((class_1935)class_1802.field_21999, amount)};
            stack = netherBlocks[random.nextInt(netherBlocks.length)];
        } else {
            class_1799[] possibleBlocks = new class_1799[]{new class_1799((class_1935)class_1802.field_20412, amount), new class_1799((class_1935)class_1802.field_8831, amount), new class_1799((class_1935)class_1802.field_20391, amount)};
            stack = possibleBlocks[random.nextInt(possibleBlocks.length)];
        }
        return stack;
    }

    private void onEntityLoad(class_1297 entity, class_3218 world) {
        if (entity instanceof class_1642) {
            ((class_1642)entity).method_5952(true);
        }
    }

    static {
        scheduler = Executors.newScheduledThreadPool(1);
    }
}

