/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.bloodmoon.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.example.bloodmoon.config.BloodmoonConfig;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.lwjgl.opengl.GL11;

public class ClientBloodmoonHandler
implements ClientModInitializer {
    public static final ClientBloodmoonHandler INSTANCE = new ClientBloodmoonHandler();
    private boolean bloodmoonActive = false;
    private final float sinMax = 2.6179937E-4f;
    private float lightSub;
    public float fogRemove;
    private float skyColorAdd;
    private float moonColorRed;
    private float d = 6.666667E-5f;
    private int difTime = 0;
    private double sin;

    public boolean isBloodmoonActive() {
        return this.bloodmoonActive;
    }

    public void setBloodmoon(boolean active) {
        this.bloodmoonActive = active;
    }

    public void moonColorHook() {
        if (this.isBloodmoonActive() && BloodmoonConfig.APPEARANCE.RED_MOON) {
            GL11.glColor3f((float)0.8f, (float)0.0f, (float)0.0f);
        }
    }

    public class_243 skyColorHook(class_243 color) {
        if (this.isBloodmoonActive() && BloodmoonConfig.APPEARANCE.RED_SKY) {
            color = new class_243(color.field_1352 + (double)ClientBloodmoonHandler.INSTANCE.skyColorAdd, color.field_1351, color.field_1350);
        }
        return color;
    }

    public int manipulateRed(int position, int originalValue) {
        return originalValue;
    }

    public int manipulateGreen(int position, int originalValue) {
        int height;
        if (this.isBloodmoonActive() && BloodmoonConfig.APPEARANCE.RED_LIGHT && (height = position / 16) < 16) {
            float mod = 0.0625f * (float)height;
            originalValue = (int)((double)originalValue - (double)(mod * this.lightSub) * (this.sin / 2.0 + 1.0));
            return Math.max(originalValue, 0);
        }
        return originalValue;
    }

    public int manipulateBlue(int position, int originalValue) {
        int height;
        if (this.isBloodmoonActive() && BloodmoonConfig.APPEARANCE.RED_LIGHT && (height = position / 16) < 16) {
            float mod = 0.0625f * (float)height;
            originalValue = (int)((float)originalValue - mod * this.lightSub * 2.3f);
            return Math.max(originalValue, 0);
        }
        return originalValue;
    }

    public void onClientTick(class_310 client) {
        if (this.isBloodmoonActive()) {
            class_638 world = client.field_1687;
            class_746 player = client.field_1724;
            if (world != null && player != null) {
                if (world.method_27983() != class_1937.field_25179) {
                    this.bloodmoonActive = false;
                    return;
                }
                float difTime = (int)(world.method_8510() % 24000L) - 12000;
                this.sin = Math.sin(difTime * 2.6179937E-4f);
                this.lightSub = (float)(this.sin * 150.0);
                this.skyColorAdd = (float)(this.sin * (double)0.1f);
                this.moonColorRed = (float)(this.sin * (double)0.7f);
                this.fogRemove = (float)(this.sin * 6000.0);
            } else if (this.bloodmoonActive) {
                this.bloodmoonActive = false;
            }
        }
    }

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
    }
}

