/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.bloodmoon.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class BloodmoonConfig {
    public static General GENERAL = new General();
    public static Appearance APPEARANCE = new Appearance();
    public static Schedule SCHEDULE = new Schedule();
    public static Spawning SPAWNING = new Spawning();
    private static final String CONFIG_FILE_PATH = "config/bloodmoon.properties";
    static Map<String, String> classToEntityNameMap;

    public static boolean canSpawn(Class<?> entityClass) {
        if (BloodmoonConfig.SPAWNING.SPAWN_WHITELIST.isEmpty()) {
            if (BloodmoonConfig.SPAWNING.SPAWN_BLACKLIST.isEmpty()) {
                return true;
            }
            String entityName = BloodmoonConfig.getEntityName(entityClass);
            for (String name : BloodmoonConfig.SPAWNING.SPAWN_BLACKLIST) {
                if (!name.equals(entityName)) continue;
                return false;
            }
            return true;
        }
        String entityName = BloodmoonConfig.getEntityName(entityClass);
        for (String name : BloodmoonConfig.SPAWNING.SPAWN_WHITELIST) {
            if (!name.equals(entityName)) continue;
            return true;
        }
        return false;
    }

    public static String getEntityName(Class<?> entityClass) {
        return entityClass.getSimpleName();
    }

    private static void loadConfig() {
        Properties properties = new Properties();
        try {
            File configFile = new File(CONFIG_FILE_PATH);
            if (!configFile.exists()) {
                BloodmoonConfig.saveDefaultConfig();
            }
            try (FileInputStream fis = new FileInputStream(CONFIG_FILE_PATH);){
                properties.load(fis);
            }
            BloodmoonConfig.GENERAL.NO_SLEEP = Boolean.parseBoolean(properties.getProperty("general.no_sleep", "true"));
            BloodmoonConfig.GENERAL.VANISH = Boolean.parseBoolean(properties.getProperty("general.vanish", "false"));
            BloodmoonConfig.GENERAL.RESPECT_GAMERULE = Boolean.parseBoolean(properties.getProperty("general.respect_gamerule", "true"));
            BloodmoonConfig.GENERAL.SEND_MESSAGE = Boolean.parseBoolean(properties.getProperty("general.send_message", "true"));
            BloodmoonConfig.APPEARANCE.RED_MOON = Boolean.parseBoolean(properties.getProperty("appearance.red_moon", "true"));
            BloodmoonConfig.APPEARANCE.RED_SKY = Boolean.parseBoolean(properties.getProperty("appearance.red_sky", "true"));
            BloodmoonConfig.APPEARANCE.RED_LIGHT = Boolean.parseBoolean(properties.getProperty("appearance.red_light", "true"));
            BloodmoonConfig.APPEARANCE.BLACK_FOG = Boolean.parseBoolean(properties.getProperty("appearance.black_fog", "true"));
            BloodmoonConfig.SCHEDULE.CHANCE = Double.parseDouble(properties.getProperty("schedule.chance", "0.05"));
            BloodmoonConfig.SCHEDULE.FULLMOON = Boolean.parseBoolean(properties.getProperty("schedule.fullmoon", "false"));
            BloodmoonConfig.SCHEDULE.NTH_NIGHT = Integer.parseInt(properties.getProperty("schedule.nth_night", "0"));
            BloodmoonConfig.SPAWNING.SPAWN_SPEED = Integer.parseInt(properties.getProperty("spawning.spawn_speed", "4"));
            BloodmoonConfig.SPAWNING.SPAWN_LIMIT_MULT = Integer.parseInt(properties.getProperty("spawning.spawn_limit_mult", "4"));
            BloodmoonConfig.SPAWNING.SPAWN_RANGE = Integer.parseInt(properties.getProperty("spawning.spawn_range", "2"));
            BloodmoonConfig.SPAWNING.SPAWN_DISTANCE = Integer.parseInt(properties.getProperty("spawning.spawn_distance", "24"));
            BloodmoonConfig.SPAWNING.SPAWN_WHITELIST = BloodmoonConfig.parseList(properties.getProperty("spawning.spawn_whitelist", ""));
            BloodmoonConfig.SPAWNING.SPAWN_BLACKLIST = BloodmoonConfig.parseList(properties.getProperty("spawning.spawn_blacklist", ""));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void saveDefaultConfig() {
        Properties properties = new Properties();
        properties.setProperty("general.no_sleep", String.valueOf(BloodmoonConfig.GENERAL.NO_SLEEP));
        properties.setProperty("general.vanish", String.valueOf(BloodmoonConfig.GENERAL.VANISH));
        properties.setProperty("general.respect_gamerule", String.valueOf(BloodmoonConfig.GENERAL.RESPECT_GAMERULE));
        properties.setProperty("general.send_message", String.valueOf(BloodmoonConfig.GENERAL.SEND_MESSAGE));
        properties.setProperty("appearance.red_moon", String.valueOf(BloodmoonConfig.APPEARANCE.RED_MOON));
        properties.setProperty("appearance.red_sky", String.valueOf(BloodmoonConfig.APPEARANCE.RED_SKY));
        properties.setProperty("appearance.red_light", String.valueOf(BloodmoonConfig.APPEARANCE.RED_LIGHT));
        properties.setProperty("appearance.black_fog", String.valueOf(BloodmoonConfig.APPEARANCE.BLACK_FOG));
        properties.setProperty("schedule.chance", String.valueOf(BloodmoonConfig.SCHEDULE.CHANCE));
        properties.setProperty("schedule.fullmoon", String.valueOf(BloodmoonConfig.SCHEDULE.FULLMOON));
        properties.setProperty("schedule.nth_night", String.valueOf(BloodmoonConfig.SCHEDULE.NTH_NIGHT));
        properties.setProperty("spawning.spawn_speed", String.valueOf(BloodmoonConfig.SPAWNING.SPAWN_SPEED));
        properties.setProperty("spawning.spawn_limit_mult", String.valueOf(BloodmoonConfig.SPAWNING.SPAWN_LIMIT_MULT));
        properties.setProperty("spawning.spawn_range", String.valueOf(BloodmoonConfig.SPAWNING.SPAWN_RANGE));
        properties.setProperty("spawning.spawn_distance", String.valueOf(BloodmoonConfig.SPAWNING.SPAWN_DISTANCE));
        properties.setProperty("spawning.spawn_whitelist", String.join((CharSequence)",", BloodmoonConfig.SPAWNING.SPAWN_WHITELIST));
        properties.setProperty("spawning.spawn_blacklist", String.join((CharSequence)",", BloodmoonConfig.SPAWNING.SPAWN_BLACKLIST));
        try (FileOutputStream fos = new FileOutputStream(CONFIG_FILE_PATH);){
            properties.store(fos, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        Properties properties = new Properties();
        properties.setProperty("general.no_sleep", String.valueOf(BloodmoonConfig.GENERAL.NO_SLEEP));
        properties.setProperty("general.vanish", String.valueOf(BloodmoonConfig.GENERAL.VANISH));
        properties.setProperty("general.respect_gamerule", String.valueOf(BloodmoonConfig.GENERAL.RESPECT_GAMERULE));
        properties.setProperty("general.send_message", String.valueOf(BloodmoonConfig.GENERAL.SEND_MESSAGE));
        properties.setProperty("appearance.red_moon", String.valueOf(BloodmoonConfig.APPEARANCE.RED_MOON));
        properties.setProperty("appearance.red_sky", String.valueOf(BloodmoonConfig.APPEARANCE.RED_SKY));
        properties.setProperty("appearance.red_light", String.valueOf(BloodmoonConfig.APPEARANCE.RED_LIGHT));
        properties.setProperty("appearance.black_fog", String.valueOf(BloodmoonConfig.APPEARANCE.BLACK_FOG));
        properties.setProperty("schedule.chance", String.valueOf(BloodmoonConfig.SCHEDULE.CHANCE));
        properties.setProperty("schedule.fullmoon", String.valueOf(BloodmoonConfig.SCHEDULE.FULLMOON));
        properties.setProperty("schedule.nth_night", String.valueOf(BloodmoonConfig.SCHEDULE.NTH_NIGHT));
        properties.setProperty("spawning.spawn_speed", String.valueOf(BloodmoonConfig.SPAWNING.SPAWN_SPEED));
        properties.setProperty("spawning.spawn_limit_mult", String.valueOf(BloodmoonConfig.SPAWNING.SPAWN_LIMIT_MULT));
        properties.setProperty("spawning.spawn_range", String.valueOf(BloodmoonConfig.SPAWNING.SPAWN_RANGE));
        properties.setProperty("spawning.spawn_distance", String.valueOf(BloodmoonConfig.SPAWNING.SPAWN_DISTANCE));
        properties.setProperty("spawning.spawn_whitelist", String.join((CharSequence)",", BloodmoonConfig.SPAWNING.SPAWN_WHITELIST));
        properties.setProperty("spawning.spawn_blacklist", String.join((CharSequence)",", BloodmoonConfig.SPAWNING.SPAWN_BLACKLIST));
        try (FileOutputStream fos = new FileOutputStream(CONFIG_FILE_PATH);){
            properties.store(fos, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<String> parseList(String property) {
        ArrayList<String> list = new ArrayList<String>();
        if (!property.isEmpty()) {
            String[] items;
            for (String item : items = property.split(",")) {
                list.add(item.trim());
            }
        }
        return list;
    }

    static {
        BloodmoonConfig.loadConfig();
        classToEntityNameMap = new HashMap<String, String>();
    }

    public static class Spawning {
        public int SPAWN_SPEED = 4;
        public int SPAWN_LIMIT_MULT = 4;
        public int SPAWN_RANGE = 2;
        public int SPAWN_DISTANCE = 24;
        public List<String> SPAWN_WHITELIST = new ArrayList<String>();
        public List<String> SPAWN_BLACKLIST = new ArrayList<String>();
    }

    public static class General {
        public boolean NO_SLEEP = true;
        public boolean VANISH = false;
        public boolean RESPECT_GAMERULE = true;
        public boolean SEND_MESSAGE = true;
    }

    public static class Appearance {
        public boolean RED_MOON = true;
        public boolean RED_SKY = true;
        public boolean RED_LIGHT = true;
        public boolean BLACK_FOG = true;
    }

    public static class Schedule {
        public double CHANCE = 0.05;
        public boolean FULLMOON = false;
        public int NTH_NIGHT = 0;
    }
}

