/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.bloodmoon.server;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.example.bloodmoon.config.BloodmoonConfig;
import net.fabricmc.example.bloodmoon.network.PacketHandler;
import net.fabricmc.example.bloodmoon.network.messages.MessageBloodmoonStatus;
import net.fabricmc.example.bloodmoon.server.BloodmoonSpawner;
import net.fabricmc.example.config.ConfigManager;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_10741;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_18;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4284;

public class BloodmoonHandler
extends class_18 {
    public static class_3218 world;
    public static BloodmoonHandler INSTANCE;
    public static Set<class_3222> logoutQueue;
    public static Set<class_3222> joinedPlayers;
    private final BloodmoonSpawner bloodMoonSpawner = new BloodmoonSpawner();
    private static int daysElapsed;
    boolean bloodMoon = false;
    boolean forceBloodMoon = false;
    int nightCounter;
    public static final class_10741<BloodmoonHandler> BLOODMOON_HANDLER_TYPE;
    public static final Codec<BloodmoonHandler> CODEC;

    public BloodmoonHandler() {
        daysElapsed = 0;
    }

    public static void initialize(class_3218 serverWorld) {
        class_26 persistentStateManager = serverWorld.method_17983();
        INSTANCE = (BloodmoonHandler)persistentStateManager.method_17924(BLOODMOON_HANDLER_TYPE);
        world = serverWorld;
        ServerTickEvents.END_WORLD_TICK.register(BloodmoonHandler::endWorldTick);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> INSTANCE.playerJoinedWorld(handler.method_32311()));
    }

    public static BloodmoonHandler getInstance() {
        if (INSTANCE == null) {
            return INSTANCE;
        }
        return INSTANCE;
    }

    public void playerJoinedWorld(class_3222 player) {
        if (!joinedPlayers.contains(player)) {
            daysElapsed = 0;
            joinedPlayers.add(player);
        }
        if (this.bloodMoon) {
            PacketHandler.sendTo(player, new MessageBloodmoonStatus(this.bloodMoon));
        }
    }

    public static void endWorldTick(class_3218 world) {
        if (INSTANCE != null && world.method_27983() == class_1937.field_25179) {
            int time = (int)(world.method_8532() % 24000L);
            if (INSTANCE.isBloodmoonActive()) {
                if (!BloodmoonConfig.GENERAL.RESPECT_GAMERULE || world.method_64395().method_8355(class_1928.field_19390)) {
                    for (int i = 0; i < BloodmoonConfig.SPAWNING.SPAWN_SPEED; ++i) {
                        BloodmoonHandler.INSTANCE.bloodMoonSpawner.triggerBloodmoonSpawning(world, world.method_8407() != class_1267.field_5801, false);
                    }
                }
                if (time >= 0 && time < 12000) {
                    INSTANCE.setBloodmoon(false);
                }
            } else if (time == 12000) {
                ++daysElapsed;
                if (BloodmoonConfig.SCHEDULE.NTH_NIGHT != 0) {
                    --BloodmoonHandler.INSTANCE.nightCounter;
                    if (BloodmoonHandler.INSTANCE.nightCounter < 0) {
                        BloodmoonHandler.INSTANCE.nightCounter = BloodmoonConfig.SCHEDULE.NTH_NIGHT;
                    }
                    INSTANCE.method_80();
                }
                if (BloodmoonHandler.INSTANCE.forceBloodMoon || Math.random() < BloodmoonConfig.SCHEDULE.CHANCE || BloodmoonConfig.SCHEDULE.FULLMOON && world.method_30273() == 0 || BloodmoonConfig.SCHEDULE.NTH_NIGHT != 0 && BloodmoonHandler.INSTANCE.nightCounter == 0) {
                    BloodmoonHandler.INSTANCE.forceBloodMoon = false;
                    if (ConfigManager.getConfig().isBloodmoonEnabled() && BloodmoonHandler.getElapsedDays(world) >= ConfigManager.getConfig().getDaysBeforeBloodmoonPossibility()) {
                        INSTANCE.setBloodmoon(true);
                        if (BloodmoonConfig.GENERAL.SEND_MESSAGE) {
                            world.method_18456().forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)"Bloodmoon is rising...").method_27692(class_124.field_1061), false));
                        }
                    }
                    if (BloodmoonHandler.INSTANCE.nightCounter == 0 && BloodmoonConfig.SCHEDULE.NTH_NIGHT != 0) {
                        BloodmoonHandler.INSTANCE.nightCounter = BloodmoonConfig.SCHEDULE.NTH_NIGHT;
                        INSTANCE.method_80();
                    }
                }
            }
        }
    }

    public static int getElapsedDays(class_3218 world) {
        return (int)(world.method_8510() / 24000L);
    }

    public void setBloodmoon(boolean bloodMoon) {
        if (this.bloodMoon != bloodMoon) {
            PacketHandler.sendToAll(world, new MessageBloodmoonStatus(bloodMoon));
            this.method_80();
        }
        this.bloodMoon = bloodMoon;
    }

    public void updateClients() {
        PacketHandler.sendToAll(world, new MessageBloodmoonStatus(this.bloodMoon));
    }

    public void force() {
        this.forceBloodMoon = true;
        this.method_80();
    }

    public boolean isBloodmoonActive() {
        return this.bloodMoon;
    }

    public void stop() {
        this.setBloodmoon(false);
    }

    static {
        logoutQueue = new HashSet<class_3222>();
        joinedPlayers = new HashSet<class_3222>();
        BLOODMOON_HANDLER_TYPE = new class_10741("bloodmoon_handler", ctx -> new BloodmoonHandler(), ctx -> CODEC, class_4284.field_24640);
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("bloodMoon").forGetter(h -> h.bloodMoon), (App)Codec.BOOL.fieldOf("forceBloodMoon").forGetter(h -> h.forceBloodMoon), (App)Codec.INT.fieldOf("daysElapsed").forGetter(h -> daysElapsed)).apply((Applicative)instance, (bloodMoon, forceBloodMoon, daysElapsed) -> {
            BloodmoonHandler handler = new BloodmoonHandler();
            handler.bloodMoon = bloodMoon;
            handler.forceBloodMoon = forceBloodMoon;
            daysElapsed = daysElapsed;
            return handler;
        }));
    }
}

