/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.bloodmoon.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.fabricmc.example.bloodmoon.config.BloodmoonConfig;
import net.fabricmc.example.config.ConfigManager;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5483;
import net.minecraft.class_5819;
import net.minecraft.class_6010;
import net.minecraft.class_6012;
import net.minecraft.class_6880;
import net.minecraft.class_8959;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BloodmoonSpawner
implements class_8959 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MOB_COUNT_DIV = (int)Math.pow(17.0, 2.0);
    private final Set<class_1923> eligibleChunksForSpawning = Sets.newHashSet();
    int witchCount = 0;
    private List<class_1657> cachedPlayers = null;
    private List<class_243> cachedPlayerPositions = null;

    public void triggerBloodmoonSpawning(class_3218 world, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        if (!spawnHostileMobs && !spawnPeacefulMobs) {
            return;
        }
        this.eligibleChunksForSpawning.clear();
        int eligibleChunkCount = 0;
        this.cachedPlayers = new ArrayList<class_1657>(world.method_18456());
        this.cachedPlayerPositions = new ArrayList<class_243>();
        for (class_1657 player : this.cachedPlayers) {
            if (player.method_7325()) continue;
            this.cachedPlayerPositions.add(player.method_19538());
            int playerChunkX = class_3532.method_15357((double)(player.method_23317() / 16.0));
            int playerChunkZ = class_3532.method_15357((double)(player.method_23321() / 16.0));
            int radius = 8;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2818 chunk;
                    boolean isEdge = dx == -radius || dx == radius || dz == -radius || dz == radius;
                    class_1923 chunkPos = new class_1923(dx + playerChunkX, dz + playerChunkZ);
                    if (this.eligibleChunksForSpawning.contains(chunkPos)) continue;
                    ++eligibleChunkCount;
                    if (isEdge || !world.method_8621().method_11951(chunkPos) || (chunk = world.method_14178().method_12126(chunkPos.field_9181, chunkPos.field_9180, false)) == null || !world.method_8393(chunkPos.field_9181, chunkPos.field_9180)) continue;
                    this.eligibleChunksForSpawning.add(chunkPos);
                }
            }
        }
        int spawnCount = 0;
        class_2338 worldSpawnPos = world.method_43126();
        for (class_1311 spawnGroup : class_1311.values()) {
            if (spawnGroup.method_6136() && !spawnPeacefulMobs || !spawnGroup.method_6136() && !spawnHostileMobs) continue;
            int existingEntityCount = this.countEntities(world, spawnGroup);
            int maxSpawnCount = spawnGroup.method_6134() * eligibleChunkCount / MOB_COUNT_DIV;
            if (existingEntityCount > (maxSpawnCount *= BloodmoonConfig.SPAWNING.SPAWN_LIMIT_MULT)) continue;
            ArrayList shuffledChunks = Lists.newArrayList(this.eligibleChunksForSpawning);
            Collections.shuffle(shuffledChunks);
            class_2338.class_2339 mutablePos = new class_2338.class_2339();
            int maxSpawnAttempts = Math.min(shuffledChunks.size(), 50);
            for (int i = 0; i < maxSpawnAttempts; ++i) {
                class_1923 chunkPos = (class_1923)shuffledChunks.get(i);
                class_2338 spawnPos = BloodmoonSpawner.getRandomChunkPosition((class_1937)world, chunkPos.field_9181, chunkPos.field_9180);
                int x = spawnPos.method_10263();
                int y = spawnPos.method_10264();
                int z = spawnPos.method_10260();
                class_2680 blockState = world.method_8320(spawnPos);
                if (blockState.method_26225()) continue;
                int groupSize = class_3532.method_15384((double)(Math.random() * 4.0));
                for (int j = 0; j < groupSize; ++j) {
                    class_1308 mobEntity;
                    class_2338 surfacePos = world.method_8598(class_2902.class_2903.field_13202, new class_2338(x += world.field_9229.method_43048(6) - world.field_9229.method_43048(6), 0, z += world.field_9229.method_43048(6) - world.field_9229.method_43048(6)));
                    y = surfacePos.method_10264();
                    mutablePos.method_10103(x, y, z);
                    float spawnX = (float)x + 0.5f;
                    float spawnZ = (float)z + 0.5f;
                    int blockLightLevel = world.method_8314(class_1944.field_9282, (class_2338)mutablePos);
                    class_2338 belowPos = mutablePos.method_10074();
                    class_2680 belowState = world.method_8320(belowPos);
                    if (!belowState.method_26225() || !belowState.method_26212((class_1922)world, belowPos)) continue;
                    int skyLightLevel = world.method_8314(class_1944.field_9284, (class_2338)mutablePos);
                    boolean isDaytime = world.method_8530();
                    if (isDaytime && skyLightLevel > 10 && world.method_8311((class_2338)mutablePos)) continue;
                    int waterLightThreshold = 7;
                    boolean canSpawn = false;
                    if (world.method_8320((class_2338)mutablePos).method_27852(class_2246.field_10382) && blockLightLevel <= waterLightThreshold) {
                        canSpawn = true;
                    } else if (!world.method_8320((class_2338)mutablePos).method_27852(class_2246.field_10382) && world.method_22347((class_2338)mutablePos)) {
                        canSpawn = true;
                    }
                    if (!canSpawn || !this.isPlayerNearbyOptimized((class_2338)mutablePos, 200.0)) continue;
                    class_6880 biome = world.method_23753((class_2338)mutablePos);
                    class_6012 spawnList = world.method_14178().method_12129().method_12113(biome, world.method_27056(), spawnGroup, (class_2338)mutablePos);
                    if (spawnList.method_34993()) continue;
                    int spawnIndex = world.field_9229.method_43048(spawnList.method_34994().size());
                    class_5483.class_1964 spawnEntry = (class_5483.class_1964)((class_6010)spawnList.method_34994().get(spawnIndex)).comp_2542();
                    double bloodmoonSpawnChance = ConfigManager.getConfig().getBloodmoonSpawnPercentage();
                    if (mutablePos.method_10264() < 45) {
                        bloodmoonSpawnChance *= 10.0;
                    }
                    if (spawnEntry.comp_3488() == class_1299.field_6123 && this.cachedPlayers.size() > 0) {
                        bloodmoonSpawnChance = Math.min(1.0, ConfigManager.getConfig().getBloodmoonSpawnPercentage() * 100.0);
                    }
                    if (!(Math.random() < bloodmoonSpawnChance) || spawnEntry.comp_3488() == class_1299.field_6091 || spawnEntry.comp_3488() == class_1299.field_6145 && Math.random() > 0.1 || spawnEntry.comp_3488() == class_1299.field_6123 && (!world.method_8320((class_2338)mutablePos).method_27852(class_2246.field_10382) || !world.method_8320(mutablePos.method_10084()).method_27852(class_2246.field_10382) || !world.method_8320(mutablePos.method_10086(2)).method_27852(class_2246.field_10382))) continue;
                    if (spawnEntry.comp_3488() == class_1299.field_6145) {
                        ++this.witchCount;
                        if (this.witchCount > 5) continue;
                    }
                    if (!BloodmoonConfig.canSpawn(spawnEntry.comp_3488().method_31794())) continue;
                    try {
                        mobEntity = (class_1308)spawnEntry.comp_3488().method_5883((class_1937)world, class_3730.field_16459);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    mobEntity.method_5808((double)spawnX, (double)y, (double)spawnZ, world.field_9229.method_43057() * 360.0f, 0.0f);
                    if (world.method_18768((class_1297)mobEntity) && mobEntity.method_5979((class_1936)world, class_3730.field_16459) && mobEntity.method_5957((class_4538)world)) {
                        ++spawnCount;
                        mobEntity.method_5971();
                        if (mobEntity.method_5864() != class_1299.field_6123) continue;
                        LOGGER.info("Successfully spawned drowned at position: " + String.valueOf(mutablePos));
                        continue;
                    }
                    if (mobEntity.method_5864() != class_1299.field_6123) continue;
                    LOGGER.warn("Failed to spawn drowned at position: " + String.valueOf(mutablePos));
                }
            }
        }
        this.cachedPlayers = null;
        this.cachedPlayerPositions = null;
    }

    private boolean isPlayerNearbyOptimized(class_2338 pos, double distance) {
        if (this.cachedPlayerPositions == null) {
            return false;
        }
        double distanceSq = distance * distance;
        for (class_243 playerPos : this.cachedPlayerPositions) {
            double dz;
            double dy;
            double dx = (double)pos.method_10263() - playerPos.field_1352;
            if (!(dx * dx + (dy = (double)pos.method_10264() - playerPos.field_1351) * dy + (dz = (double)pos.method_10260() - playerPos.field_1350) * dz <= distanceSq)) continue;
            return true;
        }
        return false;
    }

    private int countEntities(class_3218 world, class_1311 spawnGroup) {
        int count = 0;
        for (class_1297 entity : world.method_27909()) {
            if (!(entity instanceof class_1308) || entity.method_5864().method_5891() != spawnGroup) continue;
            ++count;
        }
        return count;
    }

    private static class_2338 getRandomChunkPosition(class_1937 world, int chunkX, int chunkZ) {
        int z;
        class_2818 chunk = world.method_8398().method_12126(chunkX, chunkZ, false);
        if (chunk == null) {
            return new class_2338(chunkX * 16 + world.field_9229.method_43048(16), 64, chunkZ * 16 + world.field_9229.method_43048(16));
        }
        int x = chunkX * 16 + world.field_9229.method_43048(16);
        int y = chunk.method_12005(class_2902.class_2903.field_13202, x & 0xF, (z = chunkZ * 16 + world.field_9229.method_43048(16)) & 0xF);
        if (y <= 0) {
            class_2338 pos;
            for (y = world.method_31605() - 1; y > 0 && !world.method_8320(pos = new class_2338(x, y, z)).method_26212((class_1922)world, pos); --y) {
            }
        }
        return new class_2338(x, y + 1, z);
    }

    public static boolean canSpawnAtLocation(class_1299<?> entityType, class_1937 world, class_2338 pos) {
        if (!world.method_8621().method_11952(pos)) {
            return false;
        }
        class_2680 blockState = world.method_8320(pos);
        if (entityType == class_1299.field_6123) {
            return blockState.method_27852(class_2246.field_10382);
        }
        if (entityType.method_5891() == class_1311.field_6300) {
            return blockState.method_26227().method_15771() && world.method_8320(pos.method_10074()).method_26227().method_15771() && !world.method_8320(pos.method_10084()).method_26212((class_1922)world, pos.method_10084());
        }
        class_2338 blockBelow = pos.method_10074();
        class_2680 stateBelow = world.method_8320(blockBelow);
        if (!stateBelow.method_26170((class_1922)world, blockBelow, entityType)) {
            return false;
        }
        boolean isNotBedrockOrBarrier = stateBelow.method_26204() != class_2246.field_9987 && stateBelow.method_26204() != class_2246.field_10499;
        return isNotBedrockOrBarrier && class_2248.method_9501((class_265)blockState.method_26220((class_1922)world, pos), (class_2350)class_2350.field_11036) && world.method_8314(class_1944.field_9282, pos) < 7;
    }

    public static void performWorldGenSpawning(class_3218 world, class_1959 biome, int x, int z, Random random) {
        class_6012 spawnEntries = biome.method_30966().method_31004(class_1311.field_6294);
        if (!spawnEntries.method_34993()) {
            while (random.nextFloat() < biome.method_30966().method_31002()) {
                int spawnEntryIndex = random.nextInt(spawnEntries.method_34994().size());
                class_5483.class_1964 spawnEntry = (class_5483.class_1964)((class_6010)spawnEntries.method_34994().get(spawnEntryIndex)).comp_2542();
                if (spawnEntry.comp_3488() == class_1299.field_6123) {
                    LOGGER.info("Attempting to spawn drowned at position: " + x + ", " + z);
                }
                if (spawnEntry == null) continue;
                int count = spawnEntry.comp_3489() + random.nextInt(1 + spawnEntry.comp_3490() - spawnEntry.comp_3489());
                int posX = x + random.nextInt(16);
                int posZ = z + random.nextInt(16);
                int posY = world.method_8624(class_2902.class_2903.field_13197, posX, posZ);
                for (int i = 0; i < count; ++i) {
                    boolean spawned = false;
                    for (int attempt = 0; !spawned && attempt < 4; ++attempt) {
                        class_2338 spawnPos = world.method_8598(class_2902.class_2903.field_13197, new class_2338(posX, 0, posZ));
                        if (BloodmoonSpawner.canSpawnAtLocation(spawnEntry.comp_3488(), (class_1937)world, spawnPos)) {
                            class_1308 mobEntity;
                            try {
                                mobEntity = (class_1308)spawnEntry.comp_3488().method_5883((class_1937)world, class_3730.field_16459);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                continue;
                            }
                            mobEntity.method_5808((double)posX + 0.5, (double)spawnPos.method_10264(), (double)posZ + 0.5, random.nextFloat() * 360.0f, 0.0f);
                            world.method_8649((class_1297)mobEntity);
                            spawned = true;
                        }
                        posX += random.nextInt(5) - random.nextInt(5);
                        posZ += random.nextInt(5) - random.nextInt(5);
                    }
                }
            }
        }
    }

    public void method_46408(class_1299<?> type, class_5819 random) {
    }
}

