/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.client;

import baritone.api.utils.BetterBlockPos;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.example.client.ClientPlacingBlockHighlighter;
import net.fabricmc.example.client.ClientTargetBlockHighlighter;
import net.fabricmc.example.client.path.BetterBlockPosSerializer;
import net.fabricmc.example.client.path.ClientBlockData;
import net.fabricmc.example.client.path.PathingData;
import net.fabricmc.example.client.payload.BaritoneCustomPayload;
import net.fabricmc.example.client.payload.ClientPayloadData;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ClientPathManager
implements ClientModInitializer {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BetterBlockPos.class, (Object)new BetterBlockPosSerializer()).create();
    private static final Map<Integer, List<BetterBlockPos>> currentPaths = new ConcurrentHashMap<Integer, List<BetterBlockPos>>();
    private static final Map<Integer, List<BetterBlockPos>> nextPaths = new ConcurrentHashMap<Integer, List<BetterBlockPos>>();
    private static final Map<Integer, List<BetterBlockPos>> bestPathsSoFar = new ConcurrentHashMap<Integer, List<BetterBlockPos>>();
    private static final Map<Integer, List<BetterBlockPos>> mostRecentPathsConsidered = new ConcurrentHashMap<Integer, List<BetterBlockPos>>();
    private static final Map<Integer, List<BetterBlockPos>> hiddenCurrentPaths = new ConcurrentHashMap<Integer, List<BetterBlockPos>>();
    private static final Map<Integer, List<BetterBlockPos>> hiddenNextPaths = new ConcurrentHashMap<Integer, List<BetterBlockPos>>();
    private static final Map<Integer, List<BetterBlockPos>> hiddenBestPathsSoFar = new ConcurrentHashMap<Integer, List<BetterBlockPos>>();
    private static final Map<Integer, List<BetterBlockPos>> hiddenMostRecentPathsConsidered = new ConcurrentHashMap<Integer, List<BetterBlockPos>>();
    private static boolean isolated = false;

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver(BaritoneCustomPayload.ID, (payload, context) -> {
            String json = payload.getJson();
            ClientPayloadData payloadData = (ClientPayloadData)GSON.fromJson(json, ClientPayloadData.class);
            if (payloadData.getType().equals("path")) {
                String pathDataJson = GSON.toJson(payloadData.getData());
                PathingData pathingData = (PathingData)GSON.fromJson(pathDataJson, PathingData.class);
                ClientPathManager.updatePath(pathingData);
            } else if (payloadData.getType().equals("placing_block")) {
                String blockDataJson = GSON.toJson(payloadData.getData());
                ClientBlockData blockData = (ClientBlockData)GSON.fromJson(blockDataJson, ClientBlockData.class);
                if (blockData != null && blockData.getBlockPos() != null) {
                    ClientPlacingBlockHighlighter.updateBlock(new net.fabricmc.example.client.ClientBlockData(blockData.getMobId(), blockData.getBlockPos()));
                }
            } else if (payloadData.getType().equals("target_block")) {
                String blockDataJson = GSON.toJson(payloadData.getData());
                ClientBlockData blockData = (ClientBlockData)GSON.fromJson(blockDataJson, ClientBlockData.class);
                if (blockData != null && blockData.getBlockPos() != null) {
                    ClientTargetBlockHighlighter.updateBlock(new net.fabricmc.example.client.ClientBlockData(blockData.getMobId(), blockData.getBlockPos()));
                }
            } else if (payloadData.getType().equals("isolatePathCommand")) {
                String data = (String)payloadData.getData();
                ClientPathManager.isolatePath(Integer.parseInt(data));
                ClientPlacingBlockHighlighter.isolateBlock(Integer.parseInt(data));
            } else if (payloadData.getType().equals("undoIsolatedPathCommand")) {
                ClientPathManager.undoIsolatedPath();
                ClientPlacingBlockHighlighter.undoIsolatedBlock();
            } else if (payloadData.getType().equals("resetPathCommand")) {
                ClientPathManager.clearPaths();
                ClientPlacingBlockHighlighter.clearBlocks();
            }
        });
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            class_4587 matrixStack = context.matrixStack();
            class_4597 vertexConsumerProvider = context.consumers();
            this.renderPaths(matrixStack, vertexConsumerProvider);
        });
    }

    public static void isolatePath(int mobId) {
        if (isolated) {
            ClientPathManager.undoIsolatedPath();
        }
        for (Map.Entry<Integer, List<BetterBlockPos>> entry2 : currentPaths.entrySet()) {
            if (entry2.getKey() == mobId) continue;
            hiddenCurrentPaths.put(entry2.getKey(), entry2.getValue());
        }
        currentPaths.entrySet().removeIf(entry -> (Integer)entry.getKey() != mobId);
        for (Map.Entry<Integer, List<BetterBlockPos>> entry2 : nextPaths.entrySet()) {
            if (entry2.getKey() == mobId) continue;
            hiddenNextPaths.put(entry2.getKey(), entry2.getValue());
        }
        nextPaths.entrySet().removeIf(entry -> (Integer)entry.getKey() != mobId);
        for (Map.Entry<Integer, List<BetterBlockPos>> entry2 : bestPathsSoFar.entrySet()) {
            if (entry2.getKey() == mobId) continue;
            hiddenBestPathsSoFar.put(entry2.getKey(), entry2.getValue());
        }
        bestPathsSoFar.entrySet().removeIf(entry -> (Integer)entry.getKey() != mobId);
        for (Map.Entry<Integer, List<BetterBlockPos>> entry2 : mostRecentPathsConsidered.entrySet()) {
            if (entry2.getKey() == mobId) continue;
            hiddenMostRecentPathsConsidered.put(entry2.getKey(), entry2.getValue());
        }
        mostRecentPathsConsidered.entrySet().removeIf(entry -> (Integer)entry.getKey() != mobId);
        isolated = true;
    }

    public static void clearPaths() {
        currentPaths.clear();
        nextPaths.clear();
        bestPathsSoFar.clear();
        mostRecentPathsConsidered.clear();
        hiddenCurrentPaths.clear();
        hiddenNextPaths.clear();
        hiddenBestPathsSoFar.clear();
        hiddenMostRecentPathsConsidered.clear();
    }

    public static void undoIsolatedPath() {
        currentPaths.putAll(hiddenCurrentPaths);
        nextPaths.putAll(hiddenNextPaths);
        bestPathsSoFar.putAll(hiddenBestPathsSoFar);
        mostRecentPathsConsidered.putAll(hiddenMostRecentPathsConsidered);
        hiddenCurrentPaths.clear();
        hiddenNextPaths.clear();
        hiddenBestPathsSoFar.clear();
        hiddenMostRecentPathsConsidered.clear();
        isolated = false;
    }

    public static void updatePath(PathingData pathingData) {
        Map<Integer, List<BetterBlockPos>> targetMap;
        switch (pathingData.getType()) {
            case "current": {
                targetMap = isolated ? hiddenCurrentPaths : currentPaths;
                break;
            }
            case "next": {
                targetMap = isolated ? hiddenNextPaths : nextPaths;
                break;
            }
            case "bestSoFar": {
                targetMap = isolated ? hiddenBestPathsSoFar : bestPathsSoFar;
                break;
            }
            case "mostRecentConsidered": {
                targetMap = isolated ? hiddenMostRecentPathsConsidered : mostRecentPathsConsidered;
                break;
            }
            default: {
                return;
            }
        }
        targetMap.put(pathingData.getMobId(), pathingData.getPathPositions());
    }

    private void renderPaths(class_4587 matrixStack, class_4597 vertexConsumerProvider) {
        this.renderPathsByType(matrixStack, vertexConsumerProvider, mostRecentPathsConsidered, new float[]{1.0f, 1.0f, 0.0f, 1.0f});
        this.renderPathsByType(matrixStack, vertexConsumerProvider, bestPathsSoFar, new float[]{0.0f, 1.0f, 0.0f, 1.0f});
        this.renderPathsByType(matrixStack, vertexConsumerProvider, nextPaths, new float[]{1.0f, 0.0f, 0.0f, 1.0f});
        this.renderPathsByType(matrixStack, vertexConsumerProvider, currentPaths, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
    }

    private void renderPathsByType(class_4587 matrixStack, class_4597 vertexConsumerProvider, Map<Integer, List<BetterBlockPos>> paths, float[] color) {
        for (List<BetterBlockPos> pathPositions : paths.values()) {
            if (pathPositions == null || pathPositions.isEmpty()) continue;
            this.renderPath(matrixStack, vertexConsumerProvider, pathPositions, color);
        }
    }

    private void renderPath(class_4587 matrixStack, class_4597 vertexConsumerProvider, List<BetterBlockPos> pathPositions, float[] color) {
        class_310 client = class_310.method_1551();
        double camX = client.method_1561().field_4686.method_19326().field_1352;
        double camY = client.method_1561().field_4686.method_19326().field_1351;
        double camZ = client.method_1561().field_4686.method_19326().field_1350;
        for (int i = 0; i < pathPositions.size() - 1; ++i) {
            BetterBlockPos start = pathPositions.get(i);
            BetterBlockPos end = pathPositions.get(i + 1);
            this.renderLine(matrixStack, vertexConsumerProvider, start, end, camX, camY, camZ, color);
        }
    }

    private void renderLine(class_4587 matrixStack, class_4597 vertexConsumerProvider, BetterBlockPos start, BetterBlockPos end, double camX, double camY, double camZ, float[] color) {
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23594());
        Matrix4f modelMatrix = matrixStack.method_23760().method_23761();
        vertexConsumer.method_22918(modelMatrix, (float)((double)start.method_10263() - camX + 0.5), (float)((double)start.method_10264() - camY + 0.5), (float)((double)start.method_10260() - camZ + 0.5)).method_22915(color[0], color[1], color[2], color[3]).method_22914(0.0f, 1.0f, 0.0f);
        vertexConsumer.method_22918(modelMatrix, (float)((double)end.method_10263() - camX + 0.5), (float)((double)end.method_10264() - camY + 0.5), (float)((double)end.method_10260() - camZ + 0.5)).method_22915(color[0], color[1], color[2], color[3]).method_22914(0.0f, 1.0f, 0.0f);
    }
}

