/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.client;

import baritone.api.utils.BetterBlockPos;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.example.client.ClientBlockData;
import net.fabricmc.example.client.path.BetterBlockPosSerializer;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ClientTargetBlockHighlighter
implements ClientModInitializer {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BetterBlockPos.class, (Object)new BetterBlockPosSerializer()).create();
    private static final Map<Integer, class_2338> blocks = new ConcurrentHashMap<Integer, class_2338>();
    private static final Map<Integer, class_2338> hiddenBlocks = new ConcurrentHashMap<Integer, class_2338>();
    private static boolean isolated = false;

    public void onInitializeClient() {
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            class_4587 matrixStack = context.matrixStack();
            class_4597 vertexConsumerProvider = context.consumers();
            this.renderBlocks(matrixStack, vertexConsumerProvider);
        });
    }

    public static void updateBlock(ClientBlockData blockData) {
        if (blockData == null || blockData.getBlockPos() == null) {
            return;
        }
        if (isolated) {
            hiddenBlocks.put(blockData.getMobId(), blockData.getBlockPos());
        } else {
            blocks.put(blockData.getMobId(), blockData.getBlockPos());
        }
    }

    public static void removeBlock(int mobId) {
        blocks.remove(mobId);
    }

    public static void isolateBlock(int mobId) {
        if (isolated) {
            ClientTargetBlockHighlighter.undoIsolatedBlock();
        }
        for (Map.Entry<Integer, class_2338> entry2 : blocks.entrySet()) {
            if (entry2.getKey() == mobId) continue;
            hiddenBlocks.put(entry2.getKey(), entry2.getValue());
        }
        blocks.entrySet().removeIf(entry -> (Integer)entry.getKey() != mobId);
        isolated = true;
    }

    public static void clearBlocks() {
        blocks.clear();
        hiddenBlocks.clear();
    }

    public static void undoIsolatedBlock() {
        blocks.putAll(hiddenBlocks);
        hiddenBlocks.clear();
        isolated = false;
    }

    private void renderBlocks(class_4587 matrixStack, class_4597 vertexConsumerProvider) {
        for (Map.Entry<Integer, class_2338> entry : blocks.entrySet()) {
            class_2338 blockPosition = entry.getValue();
            if (blockPosition == null) continue;
            this.renderBlock(matrixStack, vertexConsumerProvider, blockPosition);
        }
    }

    private void renderBlock(class_4587 matrixStack, class_4597 vertexConsumerProvider, class_2338 blockPosition) {
        class_310 client = class_310.method_1551();
        double camX = client.method_1561().field_4686.method_19326().field_1352;
        double camY = client.method_1561().field_4686.method_19326().field_1351;
        double camZ = client.method_1561().field_4686.method_19326().field_1350;
        this.renderHighlight(matrixStack, vertexConsumerProvider, blockPosition, camX, camY, camZ);
    }

    private void renderHighlight(class_4587 matrixStack, class_4597 vertexConsumerProvider, class_2338 blockPosition, double camX, double camY, double camZ) {
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23594());
        Matrix4f modelMatrix = matrixStack.method_23760().method_23761();
        class_4587.class_4665 entry = matrixStack.method_23760();
        float[] color = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
        float nx = 0.0f;
        float ny = 1.0f;
        float nz = 0.0f;
        float x = (float)((double)blockPosition.method_10263() - camX);
        float y = (float)((double)blockPosition.method_10264() - camY);
        float z = (float)((double)blockPosition.method_10260() - camZ);
        this.renderLine(vertexConsumer, modelMatrix, entry, x, y, z, x + 1.0f, y, z, color, nx, ny, nz);
        this.renderLine(vertexConsumer, modelMatrix, entry, x + 1.0f, y, z, x + 1.0f, y, z + 1.0f, color, nx, ny, nz);
        this.renderLine(vertexConsumer, modelMatrix, entry, x + 1.0f, y, z + 1.0f, x, y, z + 1.0f, color, nx, ny, nz);
        this.renderLine(vertexConsumer, modelMatrix, entry, x, y, z + 1.0f, x, y, z, color, nx, ny, nz);
        this.renderLine(vertexConsumer, modelMatrix, entry, x, y + 1.0f, z, x + 1.0f, y + 1.0f, z, color, nx, ny, nz);
        this.renderLine(vertexConsumer, modelMatrix, entry, x + 1.0f, y + 1.0f, z, x + 1.0f, y + 1.0f, z + 1.0f, color, nx, ny, nz);
        this.renderLine(vertexConsumer, modelMatrix, entry, x + 1.0f, y + 1.0f, z + 1.0f, x, y + 1.0f, z + 1.0f, color, nx, ny, nz);
        this.renderLine(vertexConsumer, modelMatrix, entry, x, y + 1.0f, z + 1.0f, x, y + 1.0f, z, color, nx, ny, nz);
        this.renderLine(vertexConsumer, modelMatrix, entry, x, y, z, x, y + 1.0f, z, color, nx, ny, nz);
        this.renderLine(vertexConsumer, modelMatrix, entry, x + 1.0f, y, z, x + 1.0f, y + 1.0f, z, color, nx, ny, nz);
        this.renderLine(vertexConsumer, modelMatrix, entry, x + 1.0f, y, z + 1.0f, x + 1.0f, y + 1.0f, z + 1.0f, color, nx, ny, nz);
        this.renderLine(vertexConsumer, modelMatrix, entry, x, y, z + 1.0f, x, y + 1.0f, z + 1.0f, color, nx, ny, nz);
    }

    private void renderLine(class_4588 vertexConsumer, Matrix4f modelMatrix, class_4587.class_4665 entry, float x1, float y1, float z1, float x2, float y2, float z2, float[] color, float nx, float ny, float nz) {
        vertexConsumer.method_22918(modelMatrix, x1, y1, z1).method_22915(color[0], color[1], color[2], color[3]).method_60831(entry, nx, ny, nz);
        vertexConsumer.method_22918(modelMatrix, x2, y2, z2).method_22915(color[0], color[1], color[2], color[3]).method_60831(entry, nx, ny, nz);
    }
}

