/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.client.path;

import baritone.api.BaritoneAPI;
import baritone.api.behavior.IPathingBehavior;
import baritone.api.event.events.BlockChangeEvent;
import baritone.api.event.events.BlockInteractEvent;
import baritone.api.event.events.ChatEvent;
import baritone.api.event.events.ChunkEvent;
import baritone.api.event.events.PacketEvent;
import baritone.api.event.events.PathEvent;
import baritone.api.event.events.PlayerUpdateEvent;
import baritone.api.event.events.RenderEvent;
import baritone.api.event.events.RotationMoveEvent;
import baritone.api.event.events.SprintStateEvent;
import baritone.api.event.events.TabCompleteEvent;
import baritone.api.event.events.TickEvent;
import baritone.api.event.events.WorldEvent;
import baritone.api.event.listener.IGameEventListener;
import baritone.api.pathing.calc.IPath;
import baritone.api.pathing.calc.IPathFinder;
import baritone.api.pathing.path.IPathExecutor;
import baritone.api.utils.BetterBlockPos;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.example.client.path.BetterBlockPosSerializer;
import net.fabricmc.example.client.path.PathingData;
import net.fabricmc.example.client.payload.BaritoneCustomPayload;
import net.fabricmc.example.client.payload.ClientPayloadData;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class PathUpdateListener
implements IGameEventListener {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(BetterBlockPos.class, (Object)new BetterBlockPosSerializer()).create();
    private static final class_2960 BARITONE_PACKET_ID = class_2960.method_60655((String)"modid", (String)"baritone_packet");
    private final int mobId;
    private final IPathingBehavior behavior;

    public PathUpdateListener(int mobId, IPathingBehavior behavior) {
        this.mobId = mobId;
        this.behavior = behavior;
    }

    public void onTick(TickEvent tickEvent) {
        MinecraftServer server;
        class_2540 buf;
        BaritoneCustomPayload customPayload;
        String json;
        ClientPayloadData payloadData;
        PathingData pathingData;
        List pathPositions;
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return;
        }
        IPathExecutor current = this.behavior.getCurrent();
        IPathExecutor next = this.behavior.getNext();
        if (this.behavior.getInProgress().isPresent()) {
            Optional pathToMostRecentNodeConsidered;
            IPathFinder pathFinder = (IPathFinder)this.behavior.getInProgress().get();
            Optional bestSoFar = pathFinder.bestPathSoFar();
            if (bestSoFar.isPresent() && ((IPath)bestSoFar.get()).positions() != null) {
                List pathPositions2 = ((IPath)bestSoFar.get()).positions();
                PathingData pathingData2 = new PathingData(this.mobId, "bestSoFar", pathPositions2);
                ClientPayloadData payloadData2 = new ClientPayloadData("path", pathingData2);
                String json2 = gson.toJson((Object)payloadData2);
                BaritoneCustomPayload customPayload2 = new BaritoneCustomPayload(json2);
                class_2540 buf2 = PacketByteBufs.create();
                customPayload2.write(buf2);
                MinecraftServer server2 = BaritoneAPI.getProvider().getPrimaryBaritone().getPlayerContext().world().method_8503();
                if (server2 != null) {
                    for (class_3222 player : server2.method_3760().method_14571()) {
                        ServerPlayNetworking.send((class_3222)player, (class_8710)customPayload2);
                    }
                }
            }
            if ((pathToMostRecentNodeConsidered = pathFinder.pathToMostRecentNodeConsidered()).isPresent() && ((IPath)pathToMostRecentNodeConsidered.get()).positions() != null) {
                List pathPositions3 = ((IPath)pathToMostRecentNodeConsidered.get()).positions();
                PathingData pathingData3 = new PathingData(this.mobId, "mostRecentConsidered", pathPositions3);
                ClientPayloadData payloadData3 = new ClientPayloadData("path", pathingData3);
                String json3 = gson.toJson((Object)payloadData3);
                BaritoneCustomPayload customPayload3 = new BaritoneCustomPayload(json3);
                class_2540 buf3 = PacketByteBufs.create();
                customPayload3.write(buf3);
                MinecraftServer server3 = BaritoneAPI.getProvider().getPrimaryBaritone().getPlayerContext().world().method_8503();
                if (server3 != null) {
                    for (class_3222 player : server3.method_3760().method_14571()) {
                        ServerPlayNetworking.send((class_3222)player, (class_8710)customPayload3);
                    }
                }
            }
        }
        if (current != null && current.getPath() != null) {
            pathPositions = current.getPath().positions();
            pathingData = new PathingData(this.mobId, "current", pathPositions);
            payloadData = new ClientPayloadData("path", pathingData);
            json = gson.toJson((Object)payloadData);
            customPayload = new BaritoneCustomPayload(json);
            buf = PacketByteBufs.create();
            customPayload.write(buf);
            server = BaritoneAPI.getProvider().getPrimaryBaritone().getPlayerContext().world().method_8503();
            if (server != null) {
                for (class_3222 player : server.method_3760().method_14571()) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)customPayload);
                }
            }
        }
        if (next != null && next.getPath() != null) {
            pathPositions = next.getPath().positions();
            pathingData = new PathingData(this.mobId, "next", pathPositions);
            payloadData = new ClientPayloadData("path", pathingData);
            json = gson.toJson((Object)payloadData);
            customPayload = new BaritoneCustomPayload(json);
            buf = PacketByteBufs.create();
            customPayload.write(buf);
            server = BaritoneAPI.getProvider().getPrimaryBaritone().getPlayerContext().world().method_8503();
            if (server != null) {
                for (class_3222 player : server.method_3760().method_14571()) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)customPayload);
                }
            }
        }
    }

    public void onPostTick(TickEvent tickEvent) {
    }

    public void onPlayerUpdate(PlayerUpdateEvent playerUpdateEvent) {
    }

    public void onSendChatMessage(ChatEvent chatEvent) {
    }

    public void onPreTabComplete(TabCompleteEvent tabCompleteEvent) {
    }

    public void onChunkEvent(ChunkEvent chunkEvent) {
    }

    public void onBlockChange(BlockChangeEvent blockChangeEvent) {
    }

    public void onRenderPass(RenderEvent renderEvent) {
    }

    public void onWorldEvent(WorldEvent worldEvent) {
    }

    public void onSendPacket(PacketEvent packetEvent) {
    }

    public void onReceivePacket(PacketEvent packetEvent) {
    }

    public void onPlayerRotationMove(RotationMoveEvent rotationMoveEvent) {
    }

    public void onPlayerSprintState(SprintStateEvent sprintStateEvent) {
    }

    public void onBlockInteract(BlockInteractEvent blockInteractEvent) {
    }

    public void onPlayerDeath() {
    }

    public void onPathEvent(PathEvent pathEvent) {
    }
}

