/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.config;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.fabricmc.example.config.ModConfig;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final String CONFIG_FILE_NAME = "enhanced_mobs_mod_config.json";
    private static ModConfig config;

    public static void loadConfig() {
        File configFile = ConfigManager.getConfigFile();
        if (!configFile.exists()) {
            try (InputStream in = ConfigManager.class.getClassLoader().getResourceAsStream(CONFIG_FILE_NAME);){
                if (in != null) {
                    Files.copy(in, configFile.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (FileReader reader = new FileReader(configFile);){
            config = (ModConfig)new Gson().fromJson((Reader)reader, ModConfig.class);
            if (config.isInfiniteZombieBlocks() == null) {
                config.setInfiniteZombieBlocks(true);
            }
            if (config.isOptimizedMobitone() == null) {
                config.setOptimizedMobitone(true);
            }
            if (config.getMobBlockBreakSpeed() == null) {
                config.setMobBlockBreakSpeed(1.0);
            }
            if (config.getBloodmoonSpawnPercentage() == null) {
                config.setBloodmoonSpawnPercentage(1.0E-5);
            }
            if (config.isSkeletonsBreakBlocksDuringBloodmoon() == null) {
                config.setSkeletonsBreakBlocksDuringBloodmoon(true);
            }
            if (config.getDaysBeforeBloodmoonPossibility() == null) {
                config.setDaysBeforeBloodmoonPossibility(5);
            }
            if (config.isBuildingMiningMobsDuringBloodmoonOnly() == null) {
                config.setBuildingMiningMobsDuringBloodmoonOnly(false);
                config.setSkeletonsBreakBlocksDuringBloodmoon(true);
            }
            if (config.isCreeperHiss() == null) {
                config.setCreeperHiss(false);
            }
            if (config.isSpiderSpeed() == null) {
                config.setSpiderSpeed(true);
            }
            if (config.isSlowPath() == null) {
                config.setSlowPath(false);
            }
            if (config.getSlowPathDelay() == null) {
                config.setSlowPathDelay(4L);
            }
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            config = new ModConfig();
            ConfigManager.saveConfig();
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(ConfigManager.getConfigFile());){
            new Gson().toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ModConfig getConfig() {
        if (config == null) {
            ConfigManager.loadConfig();
        }
        return config;
    }

    private static File getConfigFile() {
        return new File(FabricLoader.getInstance().getConfigDir().toFile(), CONFIG_FILE_NAME);
    }
}

