/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.mixin;

import net.fabricmc.example.bloodmoon.server.BloodmoonHandler;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1588.class})
public abstract class HostileEntityMixin
extends class_1314 {
    @Unique
    private int lastLightCheckTick = 0;
    @Unique
    private float cachedBrightness = 0.0f;
    @Unique
    private static final int LIGHT_CHECK_INTERVAL = 20;

    protected HostileEntityMixin(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"updateDespawnCounter"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizeDespawnCounter(CallbackInfo ci) {
        if (!this.method_37908().method_8608() && BloodmoonHandler.INSTANCE != null && BloodmoonHandler.INSTANCE.isBloodmoonActive()) {
            ci.cancel();
            return;
        }
        class_1937 world = this.method_37908();
        int currentTick = (int)(world.method_8510() % Integer.MAX_VALUE);
        if (currentTick - this.lastLightCheckTick < 20) {
            ci.cancel();
            return;
        }
        this.lastLightCheckTick = currentTick;
    }
}

