/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.mobai;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.behavior.IPathingBehavior;
import baritone.api.pathing.calc.IPath;
import baritone.api.pathing.calc.IPathFinder;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalBlock;
import baritone.api.pathing.path.IPathExecutor;
import baritone.api.process.IBaritoneProcess;
import baritone.api.process.PathingCommand;
import baritone.api.process.PathingCommandType;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.MinecraftServerUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.example.bloodmoon.server.BloodmoonHandler;
import net.fabricmc.example.client.block.ClientRenderedBlockUpdateServiceImpl;
import net.fabricmc.example.config.ConfigManager;
import net.fabricmc.example.mixin.MobEntityAccessor;
import net.fabricmc.example.mobai.PathfindingBlockRegistry;
import net.fabricmc.example.mobai.tracker.MobPathTracker;
import net.fabricmc.example.service.MobitoneServiceImpl;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1613;
import net.minecraft.class_1642;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2382;
import net.minecraft.class_2389;
import net.minecraft.class_239;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2533;
import net.minecraft.class_2541;
import net.minecraft.class_2544;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4135;
import net.minecraft.class_5172;
import net.minecraft.class_5800;
import net.minecraft.class_5801;
import net.minecraft.class_5808;
import net.minecraft.class_8923;
import net.minecraft.class_9;

public class BreakPlaceAndChaseGoal
extends class_1352 {
    private final class_1314 mob;
    private class_2338 previousPos;
    private class_1297 targetEntity;
    private IPathingBehavior pathingBehavior;
    private List<BetterBlockPos> currentPath;
    private int breakingTicks;
    private int standingStillTicks = 0;
    private int generalStandingStillTicks = 0;
    private class_2338 breakingPos;
    private class_2338 placingPos;
    private class_2338 placingTargetPos;
    private static final int BREAKING_TIME = 50;
    private final Map<class_2338, Integer> blockDamageProgress = new HashMap<class_2338, Integer>();
    private List<BetterBlockPos> savedPath;
    private IBaritone baritone;
    private int pathRecalculationCooldown = 0;
    private Set<class_4135> temporarilyDisabledGoals = new HashSet<class_4135>();
    private class_2338 currentPathfindingFromPos = null;
    private boolean isPaused = false;
    private IBaritoneProcess pauseProcess = null;
    private int pathCheckCooldown = 0;
    private static final int PATH_CHECK_INTERVAL = 20;
    private Boolean cachedCanReachDirectly = null;
    private int lastPathCheckTick = 0;

    public BreakPlaceAndChaseGoal(class_1314 mob) {
        this.mob = mob;
        BaritoneAPI.getSettings().allowParkour.value = false;
        BaritoneAPI.getSettings().allowJumpAt256.value = false;
        BaritoneAPI.getSettings().allowParkourAscend.value = false;
        BaritoneAPI.getSettings().allowParkourPlace.value = false;
        BaritoneAPI.getSettings().avoidance.value = false;
        BaritoneAPI.getSettings().assumeExternalAutoTool.value = true;
        BaritoneAPI.getSettings().assumeWalkOnWater.value = false;
        BaritoneAPI.getSettings().walkOnWaterOnePenalty.value = 5.0;
        this.savedPath = null;
        MobPathTracker.updatePath(mob.method_5845(), this.savedPath);
        MobitoneServiceImpl.addMobitone((class_1309)mob);
        this.baritone = BaritoneAPI.getProvider().getBaritoneForEntity((class_1309)mob);
        this.pathingBehavior = this.baritone.getPathingBehavior();
    }

    public boolean method_6264() {
        if (this.mob.method_5968() != null && this.mob.method_5968() instanceof class_1309) {
            this.targetEntity = this.mob.method_5968();
            boolean withinRange = this.mob.method_24515().method_19771((class_2382)this.targetEntity.method_24515(), 100.0) && Math.abs(this.mob.method_24515().method_10264() - this.targetEntity.method_24515().method_10264()) < 50;
            boolean skeletonSpecificTrigger = false;
            if ((!this.mob.method_6150() || this.isEntityStuckInDesignatedGlitchBlock((class_1309)this.mob) || this.isNavigationTargetFarFromActualTarget()) && withinRange) {
                boolean canStart;
                class_11 path;
                if (this.mob instanceof class_1613 && ((path = this.mob.method_5942().method_6349((class_1297)this.mob.method_5968(), 0)) == null || path.method_46())) {
                    skeletonSpecificTrigger = true;
                }
                boolean bl = canStart = !this.mob.method_6510() || skeletonSpecificTrigger || this.isNavigationTargetFarFromActualTarget();
                if (!(this.mob instanceof class_1613) || canStart) {
                    // empty if block
                }
                return canStart;
            }
        }
        return false;
    }

    private boolean isNavigationTargetFarFromActualTarget() {
        if (this.targetEntity == null || !this.mob.method_6150()) {
            return false;
        }
        class_11 currentPath = this.mob.method_5942().method_6345();
        if (currentPath == null || currentPath.method_46()) {
            return false;
        }
        class_2338 navTarget = currentPath.method_48();
        if (navTarget == null) {
            return false;
        }
        class_2338 actualTargetPos = this.targetEntity.method_24515();
        double distance = navTarget.method_10262((class_2382)actualTargetPos);
        return distance > 25.0;
    }

    public void method_6269() {
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        this.disableOtherGoals();
        this.cachedCanReachDirectly = null;
        this.pathCheckCooldown = 0;
    }

    public boolean method_6267() {
        if (this.targetEntity != null) {
            return this.canReachTargetDirectly() && !this.isStuckBelowTarget();
        }
        return true;
    }

    public void method_6270() {
        this.resetGoal(true);
        this.method_6265(EnumSet.noneOf(class_1352.class_4134.class));
        this.enableOtherGoals();
        if (this.currentPathfindingFromPos != null) {
            PathfindingBlockRegistry.releaseBlock(this.currentPathfindingFromPos, (class_1308)this.mob);
            this.currentPathfindingFromPos = null;
        }
        super.method_6270();
    }

    private boolean canReachTargetDirectly() {
        if (this.targetEntity == null) {
            return false;
        }
        double distance = this.mob.method_5858(this.targetEntity);
        if (distance > 400.0) {
            this.cachedCanReachDirectly = false;
            return false;
        }
        if (this.pathCheckCooldown > 0) {
            --this.pathCheckCooldown;
            return this.cachedCanReachDirectly != null ? this.cachedCanReachDirectly : false;
        }
        this.pathCheckCooldown = 20;
        class_243 mobEyes = this.mob.method_33571();
        class_243 targetEyes = this.targetEntity.method_33571();
        class_3965 hitResult = this.mob.method_37908().method_17742(new class_3959(mobEyes, targetEyes, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.mob));
        if (hitResult.method_17783() == class_239.class_240.field_1333 && distance < 49.0) {
            this.cachedCanReachDirectly = true;
            return true;
        }
        class_11 directPath = this.mob.method_5942().method_6349(this.targetEntity, 0);
        if (directPath == null || directPath.method_46()) {
            this.cachedCanReachDirectly = false;
            return false;
        }
        class_9 pathEnd = directPath.method_45();
        if (pathEnd == null) {
            this.cachedCanReachDirectly = false;
            return false;
        }
        class_2338 targetPos = this.targetEntity.method_24515();
        class_2338 pathEndPos = pathEnd.method_22879();
        int xDiff = Math.abs(pathEndPos.method_10263() - targetPos.method_10263());
        int yDiff = Math.abs(pathEndPos.method_10264() - targetPos.method_10264());
        int zDiff = Math.abs(pathEndPos.method_10260() - targetPos.method_10260());
        if (xDiff > 1 || yDiff > 1 || zDiff > 1) {
            this.cachedCanReachDirectly = false;
            return false;
        }
        if (!this.canWalkToPosition(pathEndPos)) {
            this.cachedCanReachDirectly = false;
            return false;
        }
        if (this.mob instanceof class_1613) {
            class_2338 currentPos = this.mob.method_24515();
            if (!currentPos.method_19771((class_2382)pathEnd.method_22879(), 1.5)) {
                this.cachedCanReachDirectly = false;
                return false;
            }
            if (!this.hasLineOfSight(currentPos, targetPos)) {
                this.cachedCanReachDirectly = false;
                return false;
            }
            int heightDiff = currentPos.method_10264() - targetPos.method_10264();
            if (heightDiff < -1) {
                this.cachedCanReachDirectly = false;
                return false;
            }
            if (this.isInHole(currentPos)) {
                this.cachedCanReachDirectly = false;
                return false;
            }
        }
        boolean canReach = this.isPathWalkable(directPath);
        this.cachedCanReachDirectly = canReach;
        return canReach;
    }

    private boolean hasLineOfSight(class_2338 from, class_2338 to) {
        class_1937 world = this.getWorld(this.mob);
        return world.method_17742(new class_3959(class_243.method_24953((class_2382)from).method_1031(0.0, 1.5, 0.0), class_243.method_24953((class_2382)to).method_1031(0.0, 1.5, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.mob)).method_17783() == class_239.class_240.field_1333;
    }

    private boolean isPathWalkable(class_11 path) {
        if (path == null) {
            return false;
        }
        for (int i = 0; i < path.method_38() - 1; ++i) {
            class_2338 checkPos;
            class_9 current = path.method_40(i);
            class_9 next = path.method_40(i + 1);
            class_2338 currentPos = new class_2338(current.field_40, current.field_39, current.field_38);
            class_2338 nextPos = new class_2338(next.field_40, next.field_39, next.field_38);
            if (Math.abs(currentPos.method_10264() - nextPos.method_10264()) > 1 && this.isSolidBlock(checkPos = currentPos.method_10086(2))) {
                return false;
            }
            if (!this.isSolidBlock(nextPos) && !this.isSolidBlock(nextPos.method_10084())) continue;
            return false;
        }
        return true;
    }

    private boolean isStuckBelowTarget() {
        if (this.targetEntity == null) {
            return false;
        }
        int xDiff = Math.abs(this.mob.method_24515().method_10263() - this.targetEntity.method_24515().method_10263());
        int zDiff = Math.abs(this.mob.method_24515().method_10260() - this.targetEntity.method_24515().method_10260());
        int yDiff = this.targetEntity.method_24515().method_10264() - this.mob.method_24515().method_10264();
        if (xDiff <= 3 && zDiff <= 3 && yDiff > 2) {
            class_2338 checkPos = this.mob.method_24515().method_10086(2);
            for (int i = 0; i < yDiff - 2; ++i) {
                if (this.isSolidBlock(checkPos)) {
                    return true;
                }
                checkPos = checkPos.method_10084();
            }
        }
        return false;
    }

    private boolean isInHole(class_2338 pos) {
        int solidSides = 0;
        int solidAbove = 0;
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            if (this.isSolidBlock(pos.method_10093(dir))) {
                ++solidSides;
            }
            if (!this.isSolidBlock(pos.method_10084().method_10093(dir))) continue;
            ++solidAbove;
        }
        return solidSides >= 3 || solidAbove >= 2;
    }

    private boolean canWalkToPosition(class_2338 pos) {
        if (this.isSolidBlock(pos) || this.isSolidBlock(pos.method_10084())) {
            return false;
        }
        if (!this.isSolidBlock(pos.method_10074())) {
            class_2680 below = this.getWorld(this.mob).method_8320(pos.method_10074());
            return !below.method_26227().method_15769();
        }
        return true;
    }

    private void calculatePath() {
        if (this.targetEntity != null) {
            GoalBlock goal = this.getTargetGoal();
            if (this.baritone != null) {
                this.pathingBehavior = this.baritone.getPathingBehavior();
                this.baritone.getCustomGoalProcess().setGoalAndPath((Goal)goal);
                if (this.baritone.getPathingBehavior().getCurrent() != null) {
                    this.currentPath = this.baritone.getPathingBehavior().getCurrent().getPath().positions();
                    this.breakingPos = null;
                    this.placingPos = null;
                    this.placingTargetPos = null;
                    this.findBreakingOrPlacingBlock();
                } else if (this.baritone.getPathingBehavior().getInProgress().isPresent()) {
                    IPathFinder pathFinder = (IPathFinder)this.baritone.getPathingBehavior().getInProgress().get();
                    Optional bestSoFar = pathFinder.bestPathSoFar();
                    if (bestSoFar.isPresent() && ((IPath)bestSoFar.get()).positions() != null) {
                        this.currentPath = new ArrayList<BetterBlockPos>(((IPath)bestSoFar.get()).positions());
                        this.breakingPos = null;
                        this.placingPos = null;
                        this.placingTargetPos = null;
                        this.findBreakingOrPlacingBlock();
                    } else {
                        this.currentPath = null;
                    }
                } else {
                    this.currentPath = null;
                }
            } else if (this.savedPath != null) {
                this.currentPath = new ArrayList<BetterBlockPos>(this.savedPath);
                this.breakingPos = null;
                this.placingPos = null;
                this.placingTargetPos = null;
                this.findBreakingOrPlacingBlock();
            }
        }
    }

    private boolean isPlacementNeeded(class_2338 blockPos, int pathIndex) {
        class_2338 pos = null;
        class_2338 nextPos = null;
        if (pathIndex != -1 && pathIndex != this.currentPath.size() - 1) {
            pos = (class_2338)this.currentPath.get(pathIndex);
            nextPos = (class_2338)this.currentPath.get(pathIndex + 1);
        }
        if (!this.isSolidBlock(blockPos) || this.getWorld(this.mob).method_8320(blockPos).method_27852(class_2246.field_10164)) {
            if (nextPos != null && pos.equals((Object)blockPos)) {
                return !nextPos.equals((Object)pos.method_10074());
            }
            return true;
        }
        if (this.getWorld(this.mob).method_8320(blockPos).method_27852(class_2246.field_10382) || !this.getWorld(this.mob).method_8316(blockPos).method_15769()) {
            if (!this.getWorld(this.mob).method_8320(blockPos.method_10084()).method_26215()) {
                return false;
            }
            if (pathIndex == -1 || pathIndex == this.currentPath.size() - 1) {
                return false;
            }
            return !nextPos.equals((Object)pos.method_10074());
        }
        return false;
    }

    private void findBreakingOrPlacingBlock() {
        if (this.currentPath != null && !this.currentPath.isEmpty()) {
            BetterBlockPos destination = this.currentPath.get(this.currentPath.size() - 1);
            List<BetterBlockPos> positions = this.currentPath;
            int mobPathIndex = -1;
            class_2338 mobPos = this.mob.method_24515();
            int lastWalkableIndex = 0;
            for (int i = 0; i <= positions.size() - 1; ++i) {
                class_2338 targetBlockPos = i == 0 ? this.mob.method_24515() : new class_2338(positions.get((int)(i - 1)).x, positions.get((int)(i - 1)).y, positions.get((int)(i - 1)).z);
                BetterBlockPos pos = positions.get(i);
                if (this.isBreakable((class_2338)pos) || this.isBreakable(pos.method_10084())) {
                    this.breakingPos = this.isBreakable((class_2338)pos) ? pos : pos.method_10084();
                    class_2338 adjacentPos = i == 0 ? this.mob.method_24515() : (class_2338)positions.get(i - 1);
                    this.savedPath = new ArrayList<BetterBlockPos>(this.currentPath);
                    MobPathTracker.updatePath(this.mob.method_5845(), this.savedPath);
                    this.navigateMobToTargetPos((class_2338)this.currentPath.get(lastWalkableIndex));
                    return;
                }
                if (i == positions.size() - 1) continue;
                BetterBlockPos nextPos = positions.get(i + 1);
                if (nextPos.x != pos.x && nextPos.z != pos.z) {
                    class_2338 diagonalBlockPos1 = new class_2338(pos.x, pos.y, nextPos.z);
                    class_2338 diagonalBlockPos2 = new class_2338(nextPos.x, pos.y, pos.z);
                    if ((this.isBreakable(diagonalBlockPos1) || this.isBreakable(diagonalBlockPos1.method_10084()) && !this.isPlacementNeeded(diagonalBlockPos1.method_10074(), i)) && (this.isPlacementNeeded(diagonalBlockPos2.method_10074(), i) && this.isPlacementNeeded(diagonalBlockPos2.method_10087(2), i) || this.isSolidBlock(diagonalBlockPos2) || this.isSolidBlock(diagonalBlockPos2))) {
                        this.breakingPos = this.isBreakable(diagonalBlockPos1) ? diagonalBlockPos1 : diagonalBlockPos1.method_10084();
                        this.savedPath = new ArrayList<BetterBlockPos>(this.currentPath);
                        MobPathTracker.updatePath(this.mob.method_5845(), this.savedPath);
                        this.navigateMobToTargetPos((class_2338)this.currentPath.get(lastWalkableIndex));
                        return;
                    }
                    if ((this.isBreakable(diagonalBlockPos2) || this.isBreakable(diagonalBlockPos2.method_10084()) && !this.isPlacementNeeded(diagonalBlockPos2.method_10074(), i)) && (this.isPlacementNeeded(diagonalBlockPos1.method_10074(), i) && this.isPlacementNeeded(diagonalBlockPos2.method_10087(2), i) || this.isSolidBlock(diagonalBlockPos1) || this.isSolidBlock(diagonalBlockPos1))) {
                        this.breakingPos = this.isBreakable(diagonalBlockPos2) ? diagonalBlockPos2 : diagonalBlockPos2.method_10084();
                        this.savedPath = new ArrayList<BetterBlockPos>(this.currentPath);
                        MobPathTracker.updatePath(this.mob.method_5845(), this.savedPath);
                        this.navigateMobToTargetPos((class_2338)this.currentPath.get(lastWalkableIndex));
                        return;
                    }
                }
                if (nextPos.y != pos.y) {
                    class_2338 twoBlocksUp = null;
                    if (nextPos.y < pos.y) {
                        for (int j = pos.y + 1; j >= nextPos.y + 1; --j) {
                            twoBlocksUp = new class_2338(nextPos.x, j, nextPos.z);
                            if (!this.isBreakable(twoBlocksUp)) continue;
                            this.breakingPos = twoBlocksUp;
                            this.navigateMobToTargetPos((class_2338)pos);
                            this.savedPath = new ArrayList<BetterBlockPos>(this.currentPath);
                            MobPathTracker.updatePath(this.mob.method_5845(), this.savedPath);
                            this.navigateMobToTargetPos((class_2338)this.currentPath.get(lastWalkableIndex));
                            return;
                        }
                    } else {
                        twoBlocksUp = new class_2338(pos.x, pos.y + 2, pos.z);
                    }
                    if (this.isBreakable(twoBlocksUp)) {
                        this.breakingPos = twoBlocksUp;
                        this.navigateMobToTargetPos((class_2338)pos);
                        this.savedPath = new ArrayList<BetterBlockPos>(this.currentPath);
                        MobPathTracker.updatePath(this.mob.method_5845(), this.savedPath);
                        this.navigateMobToTargetPos((class_2338)this.currentPath.get(lastWalkableIndex));
                        return;
                    }
                }
                BetterBlockPos floorUnderBlockPos = new BetterBlockPos(pos.x, pos.y - 1, pos.z);
                if (this.mob.method_6047().method_7909() instanceof class_1747) {
                    if (this.isPlacementNeeded((class_2338)floorUnderBlockPos, i) && !this.isSolidBlock((class_2338)floorUnderBlockPos) && !nextPos.equals((Object)floorUnderBlockPos)) {
                        BetterBlockPos placingPosToCheck = null;
                        if (this.canPlaceBlockAt((class_2338)floorUnderBlockPos)) {
                            placingPosToCheck = floorUnderBlockPos;
                        } else {
                            class_2338 supportPos = this.findSupportBlockPosition((class_2338)floorUnderBlockPos);
                            if (supportPos == null) continue;
                            placingPosToCheck = supportPos;
                        }
                        if (!this.wouldBlockPath((class_2338)placingPosToCheck)) {
                            this.placingPos = placingPosToCheck;
                            class_2338 placingPosRender = new class_2338(this.placingPos.method_10263(), this.placingPos.method_10264(), this.placingPos.method_10260());
                            ClientRenderedBlockUpdateServiceImpl.renderPlacingBlock(this.mob.method_5628(), placingPosRender);
                            this.breakingPos = null;
                            this.savedPath = new ArrayList<BetterBlockPos>(this.currentPath);
                            MobPathTracker.updatePath(this.mob.method_5845(), this.savedPath);
                            this.navigateMobToTargetPos((class_2338)this.currentPath.get(lastWalkableIndex));
                            return;
                        }
                    } else if (nextPos.x != pos.x && nextPos.z != pos.z) {
                        class_2338 placingPosRender;
                        class_2338 potentialPlacingPos;
                        class_2338 diagonalBlockPos1 = new class_2338(pos.x, pos.y, nextPos.z);
                        class_2338 diagonalBlockPos2 = new class_2338(nextPos.x, pos.y, pos.z);
                        if (!this.isSolidBlock(diagonalBlockPos1) && !this.isSolidBlock(diagonalBlockPos1.method_10084()) && this.isPlacementNeeded(diagonalBlockPos1.method_10074(), i) && (this.isSolidBlock(diagonalBlockPos2) && this.isSolidBlock(diagonalBlockPos2.method_10084()) || !this.isSolidBlock(diagonalBlockPos2.method_10074())) && this.canPlaceBlockAt(potentialPlacingPos = diagonalBlockPos1.method_10074()) && !this.wouldBlockPath(potentialPlacingPos)) {
                            this.placingPos = potentialPlacingPos;
                            placingPosRender = new class_2338(this.placingPos.method_10263(), this.placingPos.method_10264(), this.placingPos.method_10260());
                            ClientRenderedBlockUpdateServiceImpl.renderPlacingBlock(this.mob.method_5628(), placingPosRender);
                            this.breakingPos = null;
                            this.placingTargetPos = this.findFurthestWalkablePositionThatCanReach(this.placingPos);
                            if (this.placingTargetPos == null) continue;
                            this.savedPath = new ArrayList<BetterBlockPos>(this.currentPath);
                            MobPathTracker.updatePath(this.mob.method_5845(), this.savedPath);
                            this.navigateMobToTargetPos((class_2338)this.currentPath.get(lastWalkableIndex));
                            return;
                        }
                        if ((!this.isSolidBlock(diagonalBlockPos2) || !this.isSolidBlock(diagonalBlockPos2.method_10084()) && this.isPlacementNeeded(diagonalBlockPos2.method_10074(), i)) && (this.isSolidBlock(diagonalBlockPos1) && this.isSolidBlock(diagonalBlockPos1.method_10074()) || !this.isSolidBlock(diagonalBlockPos1.method_10074())) && this.canPlaceBlockAt(potentialPlacingPos = diagonalBlockPos2.method_10074()) && !this.wouldBlockPath(potentialPlacingPos)) {
                            this.placingPos = potentialPlacingPos;
                            placingPosRender = new class_2338(this.placingPos.method_10263(), this.placingPos.method_10264(), this.placingPos.method_10260());
                            ClientRenderedBlockUpdateServiceImpl.renderPlacingBlock(this.mob.method_5628(), placingPosRender);
                            this.breakingPos = null;
                            this.savedPath = new ArrayList<BetterBlockPos>(this.currentPath);
                            MobPathTracker.updatePath(this.mob.method_5845(), this.savedPath);
                            this.navigateMobToTargetPos((class_2338)this.currentPath.get(lastWalkableIndex));
                            return;
                        }
                    }
                }
                lastWalkableIndex = i;
            }
            if (this.baritone != null) {
                this.pathingBehavior = this.baritone.getPathingBehavior();
                this.baritone.getCustomGoalProcess().setGoalAndPath((Goal)this.getTargetGoal());
            }
        }
    }

    private class_2338 findSuitableAdjacentBlock(class_2338 blockPos) {
        class_2338 closestReachablePos = this.findClosestReachablePositionOnPath(blockPos);
        if (closestReachablePos == null) {
            return null;
        }
        return closestReachablePos;
    }

    private class_2338 findClosestReachablePositionOnPath(class_2338 targetPlacePos) {
        if (this.currentPath == null || this.currentPath.isEmpty()) {
            return null;
        }
        class_2338 mobPos = this.mob.method_24515();
        if (this.canReachToPlace(mobPos, targetPlacePos)) {
            return mobPos;
        }
        int mobPathIndex = -1;
        for (int i = 0; i < this.currentPath.size(); ++i) {
            if (!mobPos.method_19771((class_2382)this.currentPath.get(i), 2.0)) continue;
            mobPathIndex = i;
            break;
        }
        if (mobPathIndex == -1) {
            mobPathIndex = 0;
        }
        int lastWalkableIndex = mobPathIndex;
        int i = mobPathIndex;
        while (i < this.currentPath.size()) {
            BetterBlockPos pathPos = this.currentPath.get(i);
            class_2338 checkPos = new class_2338(pathPos.x, pathPos.y, pathPos.z);
            if (!this.canStandAt(checkPos)) break;
            lastWalkableIndex = i++;
        }
        class_2338 bestPosition = null;
        for (int i2 = lastWalkableIndex; i2 >= mobPathIndex; --i2) {
            BetterBlockPos pathPos = this.currentPath.get(i2);
            class_2338 checkPos = new class_2338(pathPos.x, pathPos.y, pathPos.z);
            if (!this.canStandAt(checkPos) || !this.canReachToPlace(checkPos, targetPlacePos)) continue;
            bestPosition = checkPos;
            break;
        }
        if (bestPosition != null) {
            // empty if block
        }
        return bestPosition;
    }

    private class_2338 findFurthestWalkablePositionThatCanReach(class_2338 targetPlacePos) {
        class_2338 checkPos;
        BetterBlockPos pathPos;
        int i;
        if (this.currentPath == null || this.currentPath.isEmpty()) {
            return null;
        }
        class_2338 mobPos = this.mob.method_24515();
        int mobPathIndex = -1;
        for (int i2 = 0; i2 < this.currentPath.size(); ++i2) {
            if (!mobPos.method_19771((class_2382)this.currentPath.get(i2), 2.0)) continue;
            mobPathIndex = i2;
            break;
        }
        if (mobPathIndex == -1) {
            mobPathIndex = 0;
        }
        int lastWalkableIndex = mobPathIndex;
        int i3 = mobPathIndex;
        while (i3 < this.currentPath.size()) {
            BetterBlockPos pathPos2 = this.currentPath.get(i3);
            class_2338 checkPos2 = new class_2338(pathPos2.x, pathPos2.y, pathPos2.z);
            if (!this.canStandAt(checkPos2)) break;
            if (i3 > mobPathIndex) {
                BetterBlockPos prevPos = this.currentPath.get(i3 - 1);
                class_2338 prevCheckPos = new class_2338(prevPos.x, prevPos.y, prevPos.z);
                if (!this.canWalkBetween(prevCheckPos, checkPos2)) break;
            }
            lastWalkableIndex = i3++;
        }
        class_2338 furthestReachable = null;
        for (i = lastWalkableIndex; i >= mobPathIndex; --i) {
            pathPos = this.currentPath.get(i);
            checkPos = new class_2338(pathPos.x, pathPos.y, pathPos.z);
            if (!this.canReachToPlace(checkPos, targetPlacePos)) continue;
            furthestReachable = checkPos;
            break;
        }
        if (furthestReachable == null) {
            for (i = lastWalkableIndex; i >= mobPathIndex; --i) {
                pathPos = this.currentPath.get(i);
                checkPos = new class_2338(pathPos.x, pathPos.y, pathPos.z);
                for (class_2350 dir : class_2350.class_2353.field_11062) {
                    class_2338 adjacent = checkPos.method_10093(dir);
                    if (!this.canStandAt(adjacent) || !this.canWalkBetween(checkPos, adjacent) || !this.canReachToPlace(adjacent, targetPlacePos)) continue;
                    return adjacent;
                }
            }
        }
        return furthestReachable;
    }

    private boolean canWalkBetween(class_2338 from, class_2338 to) {
        int dx = to.method_10263() - from.method_10263();
        int dy = to.method_10264() - from.method_10264();
        int dz = to.method_10260() - from.method_10260();
        if (Math.abs(dx) > 1 || Math.abs(dz) > 1 || Math.abs(dy) > 1) {
            return false;
        }
        if (!this.canStandAt(to)) {
            return false;
        }
        if (dy > 0 && this.isSolidBlock(from.method_10086(2))) {
            return false;
        }
        if (dy < 0 && Math.abs(dy) > 1) {
            return false;
        }
        if (dx != 0 && dz != 0) {
            class_2338 corner1 = new class_2338(from.method_10263(), from.method_10264(), to.method_10260());
            class_2338 corner2 = new class_2338(to.method_10263(), from.method_10264(), from.method_10260());
            if (this.isSolidBlock(corner1) || this.isSolidBlock(corner1.method_10084()) || this.isSolidBlock(corner2) || this.isSolidBlock(corner2.method_10084())) {
                return false;
            }
        }
        return true;
    }

    private boolean canWalkTo(class_2338 from, class_2338 to) {
        int dx = Math.abs(to.method_10263() - from.method_10263());
        int dy = to.method_10264() - from.method_10264();
        int dz = Math.abs(to.method_10260() - from.method_10260());
        if (dx > 1 || dz > 1 || Math.abs(dy) > 1) {
            return false;
        }
        if (!this.canStandAt(to)) {
            return false;
        }
        if (dy > 0 && this.isSolidBlock(from.method_10086(2))) {
            return false;
        }
        if (dx > 0 && dz > 0) {
            class_2338 corner1 = new class_2338(from.method_10263(), from.method_10264(), to.method_10260());
            class_2338 corner2 = new class_2338(to.method_10263(), from.method_10264(), from.method_10260());
            if (this.isSolidBlock(corner1) || this.isSolidBlock(corner1.method_10084()) || this.isSolidBlock(corner2) || this.isSolidBlock(corner2.method_10084())) {
                return false;
            }
        }
        return true;
    }

    private boolean canStandAt(class_2338 pos) {
        return (this.isSolidBlock(pos.method_10074()) || this.getWorld(this.mob).method_8320(pos.method_10074()).method_27852(class_2246.field_10382)) && !this.isSolidBlock(pos) && !this.isSolidBlock(pos.method_10084());
    }

    private boolean canReachToPlace(class_2338 standingPos, class_2338 targetPlacePos) {
        boolean canReach;
        double distance = standingPos.method_10262((class_2382)targetPlacePos);
        boolean bl = canReach = distance <= 20.25;
        if (canReach) {
            // empty if block
        }
        return canReach;
    }

    private boolean canPlaceBlockAt(class_2338 pos) {
        if (this.isSolidBlock(pos)) {
            return false;
        }
        if (this.isSolidBlock(pos.method_10074())) {
            return true;
        }
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            if (!this.isSolidBlock(pos.method_10093(dir))) continue;
            return true;
        }
        return this.isSolidBlock(pos.method_10084());
    }

    private class_2338 findSupportBlockPosition(class_2338 targetPos) {
        class_2338 mobPos = this.mob.method_24515();
        class_2338 bestSupportPos = null;
        double closestDistance = Double.MAX_VALUE;
        class_2338 belowTarget = targetPos.method_10074();
        if (!this.isSolidBlock(belowTarget) && this.canPlaceBlockAt(belowTarget) && !this.wouldBlockPath(belowTarget)) {
            double distance = mobPos.method_10262((class_2382)belowTarget);
            if (this.isOnOrNearPath(belowTarget)) {
                bestSupportPos = belowTarget;
                closestDistance = distance;
            }
        }
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            double distance;
            class_2338 supportPosDown;
            double distance2;
            class_2338 supportPos = targetPos.method_10093(dir);
            if (!this.isSolidBlock(supportPos) && this.canPlaceBlockAt(supportPos) && supportPos.method_10264() <= targetPos.method_10264() && !this.wouldBlockPath(supportPos) && (distance2 = mobPos.method_10262((class_2382)supportPos)) < closestDistance && this.isOnOrNearPath(supportPos)) {
                closestDistance = distance2;
                bestSupportPos = supportPos;
            }
            if (this.isSolidBlock(supportPosDown = supportPos.method_10074()) || !this.canPlaceBlockAt(supportPosDown) || this.wouldBlockPath(supportPosDown) || !((distance = mobPos.method_10262((class_2382)supportPosDown)) < closestDistance) || !this.isOnOrNearPath(supportPosDown)) continue;
            closestDistance = distance;
            bestSupportPos = supportPosDown;
        }
        return bestSupportPos;
    }

    private boolean isOnOrNearPath(class_2338 pos) {
        if (this.currentPath == null) {
            return false;
        }
        for (BetterBlockPos pathPos : this.currentPath) {
            int dx = Math.abs(pos.method_10263() - pathPos.method_10263());
            int dy = Math.abs(pos.method_10264() - pathPos.method_10264());
            int dz = Math.abs(pos.method_10260() - pathPos.method_10260());
            if (dx > 2 || dy > 1 || dz > 2) continue;
            return true;
        }
        return false;
    }

    private class_2338 findSuitableAdjacentBlockNextToWater(class_2338 blockPos) {
        class_2338 adjacentWaterPos;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 adjacentPos = blockPos.method_10093(direction);
            if (!this.getWorld(this.mob).method_8320(adjacentPos.method_10074()).method_26212((class_1922)this.getWorld(this.mob), adjacentPos) || this.isSolidBlock(adjacentPos) || this.isSolidBlock(adjacentPos.method_10084())) continue;
            for (class_2350 direction2 : class_2350.class_2353.field_11062) {
                adjacentWaterPos = adjacentPos.method_10093(direction2).method_10074();
                if (!this.getWorld(this.mob).method_8320(adjacentWaterPos).method_27852(class_2246.field_10382)) continue;
                return adjacentPos;
            }
        }
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 downAdjacentPos = blockPos.method_10093(direction).method_10074();
            if (!this.getWorld(this.mob).method_8320(downAdjacentPos.method_10074()).method_26212((class_1922)this.getWorld(this.mob), downAdjacentPos) || this.isSolidBlock(downAdjacentPos) || this.isSolidBlock(downAdjacentPos.method_10084())) continue;
            for (class_2350 direction2 : class_2350.class_2353.field_11062) {
                adjacentWaterPos = downAdjacentPos.method_10093(direction2).method_10074();
                if (!this.getWorld(this.mob).method_8320(adjacentWaterPos).method_27852(class_2246.field_10382)) continue;
                return downAdjacentPos;
            }
        }
        return null;
    }

    private class_1937 getWorld(class_1314 mob) {
        return MinecraftServerUtil.getMinecraftServer().method_3847(mob.method_37908().method_27983());
    }

    private boolean isBreakable(class_2338 blockPos) {
        class_2680 blockState = this.getWorld(this.mob).method_8320(blockPos);
        if (blockState.method_27852(class_2246.field_9987) || blockState.method_27852(class_2246.field_10540) || blockState.method_27852(class_2246.field_10260)) {
            return false;
        }
        if (this.pathingBehavior != null && this.pathingBehavior.getCurrent() != null) {
            IPathExecutor current = this.pathingBehavior.getCurrent();
            Set blocksToBreak = current.toBreak();
            for (class_2338 pos : blocksToBreak) {
                if (!pos.equals((Object)blockPos)) continue;
                for (class_2338 pos2 : current.toPlace()) {
                    if (!pos2.equals((Object)blockPos)) continue;
                    return false;
                }
                return true;
            }
        }
        return blockState.method_26212((class_1922)this.getWorld(this.mob), blockPos) || this.willObstructPlayer((class_1922)this.getWorld(this.mob), blockPos) || this.isObstructiveNonQualifyingSolidBlock(blockPos);
    }

    private boolean isSolidBlock(class_2338 blockPos) {
        return this.getWorld(this.mob).method_8320(blockPos).method_26212((class_1922)this.getWorld(this.mob), blockPos) || this.isObstructiveNonQualifyingSolidBlock(blockPos) || this.willObstructPlayer((class_1922)this.getWorld(this.mob), blockPos);
    }

    private boolean isObstructiveNonQualifyingSolidBlock(class_2248 block) {
        return block instanceof class_2399 || block instanceof class_2541 || block instanceof class_2354 || block instanceof class_2544 || block instanceof class_2389 || block instanceof class_8923 || block instanceof class_2323 || block instanceof class_2533 || block instanceof class_2244 || block instanceof class_5172 || block == class_2246.field_10576 || block == class_2246.field_23985 || block == class_2246.field_28048 || block == class_2246.field_10455 || block instanceof class_5800 || block instanceof class_5801 || block instanceof class_5808;
    }

    private boolean isObstructiveNonQualifyingSolidBlock(class_2338 blockPos) {
        class_2680 blockState = this.getWorld(this.mob).method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        return this.isObstructiveNonQualifyingSolidBlock(block);
    }

    private boolean isAdjacentOrDiagonal(class_2338 pos1, class_2338 pos2) {
        int dx = Math.abs(pos1.method_10263() - pos2.method_10263());
        int dy = Math.abs(pos1.method_10264() - pos2.method_10264());
        int dz = Math.abs(pos1.method_10260() - pos2.method_10260());
        return dx <= 1 && dy <= 1 && dz <= 1;
    }

    public void method_6268() {
        if (BloodmoonHandler.INSTANCE.isBloodmoonActive()) {
            if (this.mob instanceof class_1642) {
                class_1799 mainHandItem = this.mob.method_6047();
                this.baritone.getPathingBehavior().getInProgress().ifPresent(pathFinder -> pathFinder.setSlowPathBypass(true));
            } else {
                this.baritone.getPathingBehavior().getInProgress().ifPresent(pathFinder -> pathFinder.setSlowPathBypass(false));
            }
        } else {
            this.baritone.getPathingBehavior().getInProgress().ifPresent(pathFinder -> pathFinder.setSlowPathBypass(false));
        }
        class_2338 mobPos = this.mob.method_24515();
        boolean canPathfind = false;
        if (this.targetEntity != null && !this.canReachTargetDirectly()) {
            canPathfind = PathfindingBlockRegistry.tryAcquireBlock(mobPos, (class_1308)this.mob);
            if (canPathfind && this.currentPathfindingFromPos != null && !this.currentPathfindingFromPos.equals((Object)mobPos)) {
                PathfindingBlockRegistry.releaseBlock(this.currentPathfindingFromPos, (class_1308)this.mob);
            }
            if (canPathfind) {
                this.currentPathfindingFromPos = mobPos;
            }
        } else if (this.currentPathfindingFromPos != null) {
            PathfindingBlockRegistry.releaseBlock(this.currentPathfindingFromPos, (class_1308)this.mob);
            this.currentPathfindingFromPos = null;
        }
        if (this.baritone != null && this.baritone.getPathingBehavior() != null) {
            boolean shouldPause;
            boolean bl = shouldPause = !canPathfind || this.hasBreakingPos() || this.hasPlacingPos() || !this.method_6264();
            if (shouldPause && !this.isPaused) {
                this.pauseProcess = new IBaritoneProcess(){

                    public boolean isActive() {
                        return BreakPlaceAndChaseGoal.this.isPaused;
                    }

                    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
                        return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
                    }

                    public boolean isTemporary() {
                        return true;
                    }

                    public void onLostControl() {
                        BreakPlaceAndChaseGoal.this.isPaused = false;
                    }

                    public double priority() {
                        return 0.0;
                    }

                    public String displayName0() {
                        return "MobPauseProcess-" + BreakPlaceAndChaseGoal.this.mob.method_5628();
                    }
                };
                this.baritone.getPathingControlManager().registerProcess(this.pauseProcess);
                this.isPaused = true;
            } else if (!shouldPause && this.isPaused && this.pauseProcess != null) {
                this.isPaused = false;
                this.baritone.getCustomGoalProcess().setGoalAndPath((Goal)this.getTargetGoal());
            }
        }
        if (this.savedPath != null && (this.mob.method_24515().equals((Object)this.savedPath.get(this.savedPath.size() - 1)) || this.mob.method_24515().method_10084().equals((Object)this.savedPath.get(this.savedPath.size() - 1)))) {
            this.resetGoal(true);
            return;
        }
        if (this.currentPath != null && (this.mob.method_24515().equals((Object)this.currentPath.get(this.currentPath.size() - 1)) || this.mob.method_24515().method_10084().equals((Object)this.currentPath.get(this.currentPath.size() - 1)))) {
            this.resetGoal(true);
            return;
        }
        this.targetEntity = this.mob.method_5968();
        if (this.targetEntity != null) {
            if (this.canReachTargetDirectly() && !this.isStuckBelowTarget()) {
                this.method_6270();
                return;
            }
            if (this.isEntityStuckInDesignatedGlitchBlock((class_1309)this.mob)) {
                float yaw = this.mob.method_36454();
                if ((yaw %= 360.0f) < 0.0f) {
                    yaw += 360.0f;
                }
                class_2350 facing = yaw >= 45.0f && yaw < 135.0f ? class_2350.field_11039 : (yaw >= 135.0f && yaw < 225.0f ? class_2350.field_11043 : (yaw >= 225.0f && yaw < 315.0f ? class_2350.field_11034 : class_2350.field_11035));
                class_2338 feetPos = this.mob.method_24515();
                class_2338 headPos = feetPos.method_10084();
                class_2338 facingFeetPos = feetPos.method_10093(facing);
                class_2338 facingHeadPos = facingFeetPos.method_10084();
                if (this.isADesignatedGlitchBlock(feetPos, this.mob.method_37908())) {
                    this.breakingPos = feetPos;
                } else if (this.isADesignatedGlitchBlock(headPos, this.mob.method_37908())) {
                    this.breakingPos = headPos;
                } else if (this.isADesignatedGlitchBlock(facingFeetPos, this.mob.method_37908())) {
                    this.breakingPos = facingFeetPos;
                } else if (this.isADesignatedGlitchBlock(facingHeadPos, this.mob.method_37908())) {
                    this.breakingPos = facingHeadPos;
                }
            }
            if (this.previousPos == null) {
                this.previousPos = this.mob.method_24515();
            }
            if (this.breakingPos != null) {
                this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
                if (!this.isSolidBlock(this.breakingPos)) {
                    this.resetGoal(true);
                    return;
                }
                if (this.mob.method_24515() != null) {
                    if (this.mob.method_24515().method_19455((class_2382)this.previousPos) > 2) {
                        this.previousPos = this.mob.method_24515();
                        this.standingStillTicks = 0;
                    } else {
                        ++this.standingStillTicks;
                    }
                    if (this.standingStillTicks > 200) {
                        System.out.println("Mob: " + this.mob.method_5628() + " Standing still for too long while trying to break block at " + String.valueOf(this.breakingPos));
                        this.resetGoal(true);
                        return;
                    }
                }
                if (this.mob.method_24515().method_19771((class_2382)this.breakingPos, 4.5)) {
                    this.continueBreakingBlock();
                } else {
                    if (this.previousPos == null) {
                        this.previousPos = this.mob.method_24515();
                    }
                    this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
                }
            } else if (this.placingPos != null) {
                this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
                if (this.isSolidBlock(this.placingPos)) {
                    this.resetGoal(true);
                    return;
                }
                if (this.mob.method_24515() != null) {
                    if (this.mob.method_24515().method_19455((class_2382)this.previousPos) > 2) {
                        this.previousPos = this.mob.method_24515();
                        this.standingStillTicks = 0;
                    } else {
                        ++this.standingStillTicks;
                    }
                    if (this.standingStillTicks > 160) {
                        System.out.println("Mob: " + this.mob.method_5628() + " Standing still for too long while trying to place at " + String.valueOf(this.placingPos));
                        this.resetGoal(true);
                        return;
                    }
                }
                if (this.mob.method_24515().method_19771((class_2382)this.placingPos, 5.5)) {
                    this.placeBlock();
                } else {
                    if (this.previousPos == null) {
                        this.previousPos = this.mob.method_24515();
                    }
                    this.navigateMobToTargetPos(this.placingPos);
                }
            } else {
                boolean canReachDirectly = this.canReachTargetDirectly();
                boolean navFarFromTarget = this.isNavigationTargetFarFromActualTarget();
                boolean stuckBelow = this.isStuckBelowTarget();
                if (this.mob instanceof class_1613) {
                    // empty if block
                }
                if (canReachDirectly && !stuckBelow) {
                    this.method_6265(EnumSet.noneOf(class_1352.class_4134.class));
                    return;
                }
                this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
                if (this.pathRecalculationCooldown <= 0) {
                    this.calculatePath();
                    this.pathRecalculationCooldown = 20;
                } else {
                    --this.pathRecalculationCooldown;
                    if (this.baritone != null) {
                        GoalBlock goal;
                        boolean isPathing = this.baritone.getPathingBehavior().isPathing();
                        IPathExecutor current = this.baritone.getPathingBehavior().getCurrent();
                        if (this.mob instanceof class_1613) {
                            // empty if block
                        }
                        if (!isPathing && (goal = this.getTargetGoal()) != null) {
                            this.baritone.getCustomGoalProcess().setGoalAndPath((Goal)goal);
                        }
                        if (this.currentPath != null && !this.currentPath.isEmpty()) {
                            class_2338 currentMobPos = this.mob.method_24515();
                            BetterBlockPos targetPos = null;
                            for (int i = 0; i < this.currentPath.size(); ++i) {
                                BetterBlockPos pathPos = this.currentPath.get(i);
                                if (currentMobPos.equals((Object)pathPos) || currentMobPos.method_19771((class_2382)pathPos, 1.5)) {
                                    if (i + 1 >= this.currentPath.size()) continue;
                                    targetPos = this.currentPath.get(i + 1);
                                    break;
                                }
                                if (i != 0) continue;
                                targetPos = pathPos;
                                break;
                            }
                            if (targetPos == null || this.mob instanceof class_1613) {
                                // empty if block
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean isEntityStuckInDesignatedGlitchBlock(class_1309 entity) {
        float yaw = entity.method_36454();
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        class_2350 facing = yaw >= 45.0f && yaw < 135.0f ? class_2350.field_11039 : (yaw >= 135.0f && yaw < 225.0f ? class_2350.field_11043 : (yaw >= 225.0f && yaw < 315.0f ? class_2350.field_11034 : class_2350.field_11035));
        class_2338 feetPos = entity.method_24515();
        class_2338 headPos = feetPos.method_10084();
        class_2338 facingPos = feetPos.method_10093(facing);
        class_2338 facingHeadPos = facingPos.method_10084();
        boolean isFeetStalagmite = this.isADesignatedGlitchBlock(feetPos, entity.method_37908());
        boolean isHeadStalagmite = this.isADesignatedGlitchBlock(headPos, entity.method_37908());
        boolean isFeetFacingStalagmite = this.isADesignatedGlitchBlock(facingPos, entity.method_37908());
        boolean isHeadFacingStalagmite = this.isADesignatedGlitchBlock(facingHeadPos, entity.method_37908());
        return (isFeetStalagmite || isHeadStalagmite || isFeetFacingStalagmite || isHeadFacingStalagmite) && this.isEntityNotMoving(entity);
    }

    private boolean isADesignatedGlitchBlock(class_2338 pos, class_1937 world) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_27852(class_2246.field_28048) || blockState.method_27852(class_2246.field_10455) || blockState.method_27852(class_2246.field_23985) || blockState.method_27852(class_2246.field_28678) || blockState.method_27852(class_2246.field_28679) || blockState.method_27852(class_2246.field_28682) || blockState.method_27852(class_2246.field_28684) || blockState.method_27852(class_2246.field_42752) || blockState.method_27852(class_2246.field_10429) || blockState.method_27852(class_2246.field_10030) || blockState.method_27852(class_2246.field_21211) || blockState.method_27852(class_2246.field_22422);
    }

    private boolean isEntityNotMoving(class_1309 entity) {
        return entity.method_18798().method_1027() < 0.01;
    }

    private boolean isAtEndOfWalkablePath() {
        if (this.currentPath == null || this.currentPath.isEmpty()) {
            return false;
        }
        class_2338 mobPos = this.mob.method_24515();
        int pathSize = this.currentPath.size();
        for (int i = Math.max(0, pathSize - 5); i < pathSize; ++i) {
            BetterBlockPos pathPos = this.currentPath.get(i);
            if (!mobPos.method_19771((class_2382)pathPos, 1.5)) continue;
            for (int j = i + 1; j < pathSize; ++j) {
                BetterBlockPos nextPos = this.currentPath.get(j);
                if (!this.canWalkBetween(mobPos, new class_2338(nextPos.x, nextPos.y, nextPos.z))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isPlaceableBlock(class_1799 itemStack) {
        if (!(itemStack.method_7909() instanceof class_1747)) {
            return false;
        }
        class_2680 blockState = ((class_1747)itemStack.method_7909()).method_7711().method_9564();
        if (blockState.method_27852(class_2246.field_28048)) {
            return false;
        }
        class_1747 blockItem = (class_1747)itemStack.method_7909();
        if (this.isObstructiveNonQualifyingSolidBlock(blockItem.method_7711())) {
            return false;
        }
        return !this.isSeed(itemStack.method_7909());
    }

    public boolean isSeed(class_1792 item) {
        return item == class_1802.field_8317 || item == class_1802.field_8309 || item == class_1802.field_46250 || item == class_1802.field_46249;
    }

    private void placeBlock() {
        if (this.placingPos != null && this.mob.method_6047().method_7909() instanceof class_1747) {
            boolean success;
            class_1937 world = this.getWorld(this.mob);
            class_1799 itemStack = this.mob.method_6047();
            class_1747 blockItem = (class_1747)itemStack.method_7909();
            if (this.isPlaceableBlock(itemStack) && (success = world.method_8652(this.placingPos, blockItem.method_7711().method_9564(), 3)) && (!ConfigManager.getConfig().isInfiniteZombieBlocks().booleanValue() || blockItem.method_7711() != class_2246.field_10445 && blockItem.method_7711() != class_2246.field_10566 && blockItem.method_7711() != class_2246.field_10340 && blockItem.method_7711() != class_2246.field_28888 && blockItem.method_7711() != class_2246.field_29031 && blockItem.method_7711() != class_2246.field_10515 && blockItem.method_7711() != class_2246.field_22090)) {
                itemStack.method_7934(1);
            }
            boolean resetSavedPath = true;
            if (this.savedPath != null) {
                for (BetterBlockPos betterBlockPos : this.savedPath) {
                    if (!betterBlockPos.equals((Object)this.placingPos)) continue;
                    int index = this.savedPath.indexOf(betterBlockPos);
                    if (index < 0) break;
                    this.savedPath.subList(0, index + 1).clear();
                    break;
                }
                resetSavedPath = this.savedPath.isEmpty();
            }
            if (MobPathTracker.placingPosLiesInPath(this.placingPos) && this.baritone != null) {
                this.pathingBehavior = this.baritone.getPathingBehavior();
                this.baritone.getCustomGoalProcess().setGoalAndPath((Goal)this.getTargetGoal());
            }
            this.resetGoal(resetSavedPath);
        }
    }

    private boolean hasAdjacentBlockIncludingBelow(class_2338 blockPos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 adjacentPos = blockPos.method_10093(direction);
            if (!this.isSolidBlock(adjacentPos)) continue;
            return true;
        }
        return this.isSolidBlock(blockPos.method_10074());
    }

    private boolean wouldBlockPath(class_2338 placementPos) {
        if (this.currentPath == null) {
            return false;
        }
        for (BetterBlockPos pathPos : this.currentPath) {
            if (pathPos.equals((Object)placementPos)) {
                return true;
            }
            if (pathPos.equals((Object)placementPos.method_10074())) {
                return true;
            }
            if (!pathPos.method_10084().equals((Object)placementPos)) continue;
            return true;
        }
        for (int i = 0; i < this.currentPath.size() - 1; ++i) {
            BetterBlockPos current = this.currentPath.get(i);
            BetterBlockPos next = this.currentPath.get(i + 1);
            if (placementPos.method_10264() != current.method_10264() + 1 && placementPos.method_10264() != next.method_10264() + 1 || !this.isBlockingDiagonalMovement(current, next, placementPos)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlockingDiagonalMovement(BetterBlockPos from, BetterBlockPos to, class_2338 placementPos) {
        int dx = to.method_10263() - from.method_10263();
        int dz = to.method_10260() - from.method_10260();
        if (Math.abs(dx) == 1 && Math.abs(dz) == 1) {
            class_2338 corner1 = new class_2338(from.method_10263() + dx, from.method_10264(), from.method_10260());
            class_2338 corner2 = new class_2338(from.method_10263(), from.method_10264(), from.method_10260() + dz);
            if (placementPos.equals((Object)corner1) || placementPos.equals((Object)corner1.method_10084()) || placementPos.equals((Object)corner2) || placementPos.equals((Object)corner2.method_10084())) {
                return true;
            }
        }
        return false;
    }

    private boolean hasPathConnection(class_2338 blockPos) {
        if (this.currentPath == null) {
            return false;
        }
        for (BetterBlockPos pathPos : this.currentPath) {
            int dx = Math.abs(blockPos.method_10263() - pathPos.method_10263());
            int dy = Math.abs(blockPos.method_10264() - pathPos.method_10264());
            int dz = Math.abs(blockPos.method_10260() - pathPos.method_10260());
            if (dx > 1 || dy > 1 || dz > 1) continue;
            return true;
        }
        return false;
    }

    private void continueBreakingBlock() {
        class_1799 stack;
        int i;
        class_2621 container;
        class_2586 blockEntity;
        class_2680 blockState = this.getWorld(this.mob).method_8320(this.breakingPos);
        if (blockState.method_27852(class_2246.field_10540) || blockState.method_27852(class_2246.field_9987) || blockState.method_27852(class_2246.field_10260)) {
            this.resetGoal(true);
            return;
        }
        class_1937 world = this.getWorld(this.mob);
        ++this.breakingTicks;
        int originalProgress = this.blockDamageProgress.getOrDefault(this.breakingPos, 0);
        float blockHardness = this.getWorld(this.mob).method_8320(this.breakingPos).method_26214((class_1922)this.getWorld(this.mob), this.breakingPos);
        int adjustedBreakingTime = (int)(50.0f * blockHardness);
        double progress = originalProgress + (int)((float)this.breakingTicks / (float)adjustedBreakingTime * 10.0f);
        world.method_8517(this.mob.method_5628(), this.breakingPos, (int)progress);
        this.blockDamageProgress.put(this.breakingPos, (int)progress);
        if (blockState.method_26204() instanceof class_2343 && (blockEntity = world.method_8321(this.breakingPos)) instanceof class_2621) {
            container = (class_2621)blockEntity;
            for (i = 0; i < container.method_5439(); ++i) {
                stack = container.method_5438(i);
                if (stack.method_7960()) continue;
            }
        }
        if (progress >= 10.0 / ConfigManager.getConfig().getMobBlockBreakSpeed()) {
            boolean success;
            if (blockState.method_26204() instanceof class_2343 && (blockEntity = world.method_8321(this.breakingPos)) instanceof class_2621) {
                container = (class_2621)blockEntity;
                container.method_54873(null);
                for (i = 0; i < container.method_5439(); ++i) {
                    stack = container.method_5438(i);
                    if (stack.method_7960()) continue;
                    class_2248.method_9577((class_1937)world, (class_2338)this.breakingPos, (class_1799)stack);
                }
                container.method_5448();
            }
            if (!(success = world.method_8651(this.breakingPos, true, (class_1297)this.mob))) {
                world.method_8652(this.breakingPos, class_2246.field_10124.method_9564(), 3);
            }
            this.blockDamageProgress.remove(this.breakingPos);
            this.breakingTicks = 0;
            if (MobPathTracker.breakingPosLiesInPath(this.breakingPos) && this.baritone != null) {
                this.pathingBehavior = this.baritone.getPathingBehavior();
                this.baritone.getCustomGoalProcess().setGoalAndPath((Goal)this.getTargetGoal());
            }
            if (this.savedPath != null) {
                for (BetterBlockPos betterBlockPos : this.savedPath) {
                    if (!betterBlockPos.equals((Object)this.placingPos)) continue;
                    int index = this.savedPath.indexOf(betterBlockPos);
                    if (index < 0) break;
                    this.savedPath.subList(0, index + 1).clear();
                    break;
                }
                if (this.savedPath.isEmpty()) {
                    this.savedPath = null;
                    MobPathTracker.updatePath(this.mob.method_5845(), this.savedPath);
                }
            }
            this.resetGoal(false);
        }
    }

    public boolean method_6266() {
        if (this.targetEntity == null) {
            return false;
        }
        if (this.isNavigationTargetFarFromActualTarget()) {
            return true;
        }
        if (this.breakingPos != null || this.placingPos != null) {
            return true;
        }
        if (!this.canReachTargetDirectly()) {
            return true;
        }
        if (this.currentPath != null || this.savedPath != null) {
            if (this.currentPath == null) {
                this.currentPath = new ArrayList<BetterBlockPos>(this.savedPath);
            }
            return this.areSolidBlocksSeparatingPlayerFromMob();
        }
        return false;
    }

    public boolean areSolidBlocksSeparatingPlayerFromMob() {
        for (int i = 0; i < this.currentPath.size(); ++i) {
            class_2338 twoBlocksUp;
            BetterBlockPos pos = this.currentPath.get(i);
            class_2338 blockPos = new class_2338(pos.x, pos.y, pos.z);
            if (this.isBreakable(blockPos) || this.isBreakable(blockPos.method_10084()) || this.isPlacementNeeded(blockPos.method_10074(), i)) {
                return true;
            }
            if (i == this.currentPath.size() - 1) continue;
            BetterBlockPos nextPos = this.currentPath.get(i + 1);
            if (nextPos.x != pos.x && nextPos.z != pos.z) {
                class_2338 diagonalBlockPos1 = new class_2338(pos.x, pos.y, nextPos.z);
                class_2338 diagonalBlockPos2 = new class_2338(nextPos.x, pos.y, pos.z);
                if ((this.isBreakable(diagonalBlockPos1) || this.isBreakable(diagonalBlockPos1.method_10084())) && this.isSolidBlock(diagonalBlockPos1.method_10074())) {
                    if (!this.isPlacementNeeded(diagonalBlockPos2.method_10074(), i) && !this.isSolidBlock(diagonalBlockPos2) && !this.isSolidBlock(diagonalBlockPos2)) continue;
                    return true;
                }
                if ((this.isBreakable(diagonalBlockPos2) || this.isBreakable(diagonalBlockPos2.method_10084())) && this.isSolidBlock(diagonalBlockPos2.method_10074())) {
                    if (!this.isPlacementNeeded(diagonalBlockPos1.method_10074(), i) && !this.isSolidBlock(diagonalBlockPos1) && !this.isSolidBlock(diagonalBlockPos1)) continue;
                    return true;
                }
            }
            if (nextPos.y == pos.y) continue;
            if (nextPos.y < pos.y) {
                for (int j = pos.y + 1; j >= nextPos.y + 1; --j) {
                    twoBlocksUp = new class_2338(nextPos.x, j, nextPos.z);
                    if (!this.isBreakable(twoBlocksUp)) continue;
                    return true;
                }
                continue;
            }
            twoBlocksUp = new class_2338(pos.x, pos.y + 2, pos.z);
            if (!this.isBreakable(twoBlocksUp)) continue;
            return true;
        }
        return false;
    }

    public boolean willObstructPlayer(class_1922 world, class_2338 pos) {
        if (world == null || pos == null) {
            return false;
        }
        try {
            class_2680 state = world.method_8320(pos);
            class_265 shape = state.method_26220(world, pos);
            return !shape.method_1110() && !state.method_27852(class_2246.field_10343);
        }
        catch (NullPointerException e) {
            return this.isSolidBlock(pos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void resetGoal(boolean removePath) {
        this.method_6265(EnumSet.noneOf(class_1352.class_4134.class));
        this.currentPath = null;
        this.breakingTicks = 0;
        this.standingStillTicks = 0;
        this.generalStandingStillTicks = 0;
        this.placingPos = null;
        this.placingTargetPos = null;
        this.breakingPos = null;
        this.previousPos = null;
        this.pathRecalculationCooldown = 0;
        this.blockDamageProgress.clear();
        if (removePath) {
            this.savedPath = null;
            MobPathTracker.updatePath(this.mob.method_5845(), this.savedPath);
        }
    }

    public boolean hasBreakingPos() {
        return this.breakingPos != null;
    }

    public boolean hasPlacingPos() {
        return this.placingPos != null;
    }

    public double getDistanceToPlacingPos() {
        if (this.placingPos != null) {
            return this.mob.method_24515().method_19455((class_2382)new class_2338(this.placingPos.method_10263(), this.placingPos.method_10264(), this.placingPos.method_10260()));
        }
        return -1.0;
    }

    public GoalBlock getTargetGoal() {
        if (this.targetEntity != null) {
            class_2338 targetPos = this.targetEntity.method_24515();
            GoalBlock goal = new GoalBlock(targetPos.method_10263(), targetPos.method_10264(), targetPos.method_10260());
            if (this.mob.method_37908().method_8320(targetPos.method_10074()).method_26215()) {
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    class_2338 adjacentPos = targetPos.method_10093(direction);
                    if (!this.isSolidBlock(adjacentPos.method_10074())) continue;
                    goal = new GoalBlock(adjacentPos.method_10263(), adjacentPos.method_10264(), adjacentPos.method_10260());
                    break;
                }
            }
            return goal;
        }
        return null;
    }

    public void navigateMobToTargetPos(class_2338 targetPos) {
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        ClientRenderedBlockUpdateServiceImpl.clearTargetBlock(this.mob.method_5628());
        if (this.getWorld(this.mob).method_8320(targetPos).method_27852(class_2246.field_10382)) {
            this.mob.method_5942().method_6337((double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260(), 1.0);
            ClientRenderedBlockUpdateServiceImpl.renderTargetBlock(this.mob.method_5628(), targetPos);
        }
        if (!(this.isSolidBlock(targetPos) || this.isSolidBlock(targetPos.method_10084()) || this.isPlacementNeeded(targetPos.method_10074(), -1))) {
            this.mob.method_5942().method_6337((double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260(), 1.0);
            ClientRenderedBlockUpdateServiceImpl.renderTargetBlock(this.mob.method_5628(), targetPos);
            return;
        }
        if (this.isSolidBlock(targetPos) && !this.isSolidBlock(targetPos.method_10084())) {
            class_2338 adjacentPos = targetPos.method_10084();
            this.mob.method_5942().method_6337((double)targetPos.method_10263(), (double)(targetPos.method_10264() + 1), (double)targetPos.method_10260(), 1.0);
            ClientRenderedBlockUpdateServiceImpl.renderTargetBlock(this.mob.method_5628(), adjacentPos);
            return;
        }
        if (this.isPlacementNeeded(targetPos.method_10074(), -1)) {
            class_2338 adjacentPos;
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                adjacentPos = targetPos.method_10084().method_10093(direction);
                if (!this.isSolidBlock(adjacentPos.method_10074()) || this.isSolidBlock(adjacentPos) || this.isSolidBlock(adjacentPos.method_10084())) continue;
                this.mob.method_5942().method_6337((double)adjacentPos.method_10263(), (double)adjacentPos.method_10264(), (double)adjacentPos.method_10260(), 1.0);
                ClientRenderedBlockUpdateServiceImpl.renderTargetBlock(this.mob.method_5628(), adjacentPos);
                return;
            }
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                adjacentPos = targetPos.method_10093(direction);
                if (!this.isSolidBlock(adjacentPos.method_10074()) || this.isSolidBlock(adjacentPos) || this.isSolidBlock(adjacentPos.method_10084())) continue;
                this.mob.method_5942().method_6337((double)adjacentPos.method_10263(), (double)adjacentPos.method_10264(), (double)adjacentPos.method_10260(), 1.0);
                ClientRenderedBlockUpdateServiceImpl.renderTargetBlock(this.mob.method_5628(), adjacentPos);
                return;
            }
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 downAdjacentPos = targetPos.method_10093(direction).method_10074();
                if (!this.isSolidBlock(downAdjacentPos.method_10074()) || this.isSolidBlock(downAdjacentPos) || this.isSolidBlock(downAdjacentPos.method_10084())) continue;
                this.mob.method_5942().method_6337((double)downAdjacentPos.method_10263(), (double)downAdjacentPos.method_10264(), (double)downAdjacentPos.method_10260(), 1.0);
                ClientRenderedBlockUpdateServiceImpl.renderTargetBlock(this.mob.method_5628(), downAdjacentPos);
                return;
            }
        }
        this.mob.method_5942().method_6337((double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260(), 1.0);
        ClientRenderedBlockUpdateServiceImpl.renderTargetBlock(this.mob.method_5628(), targetPos);
    }

    private void disableOtherGoals() {
        MobEntityAccessor accessor = (MobEntityAccessor)this.mob;
        class_1355 goalSelector = accessor.getGoalSelector();
        for (class_4135 prioritizedGoal : goalSelector.method_35115()) {
            class_1352 goal = prioritizedGoal.method_19058();
            if (goal == this || prioritizedGoal.method_6271().isEmpty()) continue;
            for (class_1352.class_4134 control : prioritizedGoal.method_6271()) {
                goalSelector.method_6274(control);
            }
            this.temporarilyDisabledGoals.add(prioritizedGoal);
        }
    }

    private void enableOtherGoals() {
        MobEntityAccessor accessor = (MobEntityAccessor)this.mob;
        class_1355 goalSelector = accessor.getGoalSelector();
        for (class_4135 prioritizedGoal : this.temporarilyDisabledGoals) {
            for (class_1352.class_4134 control : prioritizedGoal.method_6271()) {
                goalSelector.method_6273(control);
            }
        }
        this.temporarilyDisabledGoals.clear();
    }
}

