/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.mobai;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.behavior.IPathingBehavior;
import baritone.api.pathing.calc.IPath;
import baritone.api.pathing.calc.IPathFinder;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalBlock;
import baritone.api.pathing.path.IPathExecutor;
import baritone.api.utils.BetterBlockPos;
import baritone.api.utils.MinecraftServerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.example.service.MobitoneServiceImpl;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2382;
import net.minecraft.class_2389;
import net.minecraft.class_2399;
import net.minecraft.class_2533;
import net.minecraft.class_2541;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_5172;
import net.minecraft.class_5800;
import net.minecraft.class_5801;
import net.minecraft.class_5808;
import net.minecraft.class_8923;

public class ExplodeBlockAndChaseGoal
extends class_1352 {
    private final class_1548 mob;
    private class_1657 targetPlayer;
    private IPath currentPath;
    private IPathingBehavior pathingBehavior;
    private class_2338 breakingPos;
    private class_2338 targetPos;
    private final Map<class_2338, Integer> blockDamageProgress = new HashMap<class_2338, Integer>();
    private IBaritone baritone;

    public ExplodeBlockAndChaseGoal(class_1548 mob) {
        this.mob = mob;
        MobitoneServiceImpl.addMobitone((class_1309)mob);
        this.baritone = BaritoneAPI.getProvider().getBaritoneForEntity((class_1309)mob);
        BaritoneAPI.getSettings().allowParkour.value = false;
        BaritoneAPI.getSettings().allowJumpAt256.value = false;
        BaritoneAPI.getSettings().allowParkourAscend.value = false;
        BaritoneAPI.getSettings().allowParkourPlace.value = false;
        BaritoneAPI.getSettings().avoidance.value = false;
        BaritoneAPI.getSettings().assumeExternalAutoTool.value = true;
        BaritoneAPI.getSettings().assumeWalkOnWater.value = false;
        BaritoneAPI.getSettings().walkOnWaterOnePenalty.value = 5.0;
    }

    public boolean method_6264() {
        if (this.mob.method_5968() != null && this.mob.method_5968() instanceof class_1657) {
            this.targetPlayer = (class_1657)this.mob.method_5968();
            boolean withinRange = this.mob.method_24515().method_19771((class_2382)this.targetPlayer.method_24515(), 100.0) && Math.abs(this.mob.method_24515().method_10264() - this.targetPlayer.method_24515().method_10264()) < 50;
            return !this.mob.method_6510() && !this.mob.method_6150() && withinRange;
        }
        return false;
    }

    public void method_6269() {
    }

    private void calculatePath() {
        if (this.targetPlayer != null) {
            this.targetPos = this.targetPlayer.method_24515();
            GoalBlock goal = new GoalBlock(this.targetPos.method_10263(), this.targetPos.method_10264(), this.targetPos.method_10260());
            if (this.mob.method_37908().method_8320(this.targetPos.method_10074()).method_26215()) {
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    class_2338 adjacentPos = this.targetPos.method_10093(direction);
                    if (!this.mob.method_37908().method_8320(adjacentPos.method_10074()).method_26212((class_1922)this.mob.method_37908(), adjacentPos.method_10074())) continue;
                    goal = new GoalBlock(adjacentPos.method_10263(), adjacentPos.method_10264(), adjacentPos.method_10260());
                    break;
                }
            }
            if (this.mob.method_37908().method_8320(this.targetPos.method_10074()).method_26215()) {
                return;
            }
            if (this.baritone != null) {
                this.pathingBehavior = this.baritone.getPathingBehavior();
                this.baritone.getCustomGoalProcess().setGoalAndPath((Goal)goal);
                if (this.baritone.getPathingBehavior().getCurrent() != null) {
                    this.currentPath = this.baritone.getPathingBehavior().getCurrent().getPath();
                    this.breakingPos = null;
                    this.findBreakingBlock();
                } else if (this.baritone.getPathingBehavior().getInProgress().isPresent() && ((Boolean)BaritoneAPI.getSettings().slowPath.value).booleanValue()) {
                    IPathFinder pathFinder = (IPathFinder)this.baritone.getPathingBehavior().getInProgress().get();
                    Optional bestSoFar = pathFinder.bestPathSoFar();
                    if (bestSoFar.isPresent() && ((IPath)bestSoFar.get()).positions() != null) {
                        this.currentPath = (IPath)bestSoFar.get();
                        this.breakingPos = null;
                        this.findBreakingBlock();
                    } else {
                        this.currentPath = null;
                    }
                } else {
                    this.currentPath = null;
                }
            }
        }
    }

    private void findBreakingBlock() {
        if (this.currentPath != null) {
            List positions = this.currentPath.positions();
            for (int i = 0; i < positions.size(); ++i) {
                class_2338 twoBlocksUp;
                BetterBlockPos pos = (BetterBlockPos)positions.get(i);
                class_2338 blockPos = new class_2338(pos.x, pos.y, pos.z);
                if (this.isBreakable(blockPos) || this.isBreakable(blockPos.method_10084())) {
                    this.breakingPos = this.isBreakable(blockPos) ? blockPos : blockPos.method_10084();
                    class_2338 adjacentPos = i == 0 ? this.mob.method_24515() : (class_2338)positions.get(i - 1);
                    if (adjacentPos == null) continue;
                    this.mob.method_5942().method_6337((double)adjacentPos.method_10263(), (double)adjacentPos.method_10264(), (double)adjacentPos.method_10260(), 1.0);
                    return;
                }
                if (i == positions.size() - 1) continue;
                BetterBlockPos nextPos = (BetterBlockPos)positions.get(i + 1);
                if (nextPos.x != pos.x && nextPos.z != pos.z) {
                    class_2338 diagonalBlockPos1 = new class_2338(pos.x, pos.y, nextPos.z);
                    class_2338 diagonalBlockPos2 = new class_2338(nextPos.x, pos.y, pos.z);
                    if (this.isBreakable(diagonalBlockPos1) || this.isBreakable(diagonalBlockPos1.method_10084()) && this.isSolidBlock(diagonalBlockPos1.method_10074())) {
                        if (this.isSolidBlock(diagonalBlockPos2.method_10074()) && !this.isSolidBlock(diagonalBlockPos2) && !this.isSolidBlock(diagonalBlockPos2)) continue;
                        this.breakingPos = this.isBreakable(diagonalBlockPos1) ? diagonalBlockPos1 : diagonalBlockPos1.method_10084();
                        this.mob.method_5942().method_6337((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1.0);
                        return;
                    }
                    if (this.isBreakable(diagonalBlockPos2) || this.isBreakable(diagonalBlockPos2.method_10084()) && this.isSolidBlock(diagonalBlockPos2.method_10074())) {
                        if (this.isSolidBlock(diagonalBlockPos1.method_10074()) && !this.isSolidBlock(diagonalBlockPos1) && !this.isSolidBlock(diagonalBlockPos1)) continue;
                        this.breakingPos = this.isBreakable(diagonalBlockPos2) ? diagonalBlockPos2 : diagonalBlockPos2.method_10084();
                        this.mob.method_5942().method_6337((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1.0);
                        return;
                    }
                }
                if (nextPos.y == pos.y || !this.isBreakable(twoBlocksUp = nextPos.y < pos.y ? new class_2338(nextPos.x, nextPos.y + 2, nextPos.z) : new class_2338(pos.x, pos.y + 2, pos.z))) continue;
                this.breakingPos = twoBlocksUp;
                this.mob.method_5942().method_6337((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1.0);
                return;
            }
        }
    }

    private boolean isBreakable(class_2338 blockPos) {
        if (this.pathingBehavior != null && this.pathingBehavior.getCurrent() != null) {
            IPathExecutor current = this.pathingBehavior.getCurrent();
            Set blocksToBreak = current.toBreak();
            for (class_2338 pos : blocksToBreak) {
                if (!pos.equals((Object)blockPos)) continue;
                return true;
            }
        }
        return this.isSolidBlock(blockPos);
    }

    private class_1937 getWorld(class_1314 mob) {
        return MinecraftServerUtil.getMinecraftServer().method_3847(mob.method_37908().method_27983());
    }

    private boolean isSolidBlock(class_2338 blockPos) {
        if (this.pathingBehavior != null && this.pathingBehavior.getCurrent() != null) {
            IPathExecutor current = this.pathingBehavior.getCurrent();
            Set blocksToBreak = current.toBreak();
            Set blocksToWalkInto = current.toWalkInto();
            for (class_2338 pos : blocksToBreak) {
                if (!pos.equals((Object)blockPos)) continue;
                return true;
            }
        }
        return this.getWorld((class_1314)this.mob).method_8320(blockPos).method_26212((class_1922)this.getWorld((class_1314)this.mob), blockPos) || this.isObstructiveNonQualifyingSolidBlock(blockPos);
    }

    private boolean isObstructiveNonQualifyingSolidBlock(class_2248 block) {
        return block instanceof class_2399 || block instanceof class_2541 || block instanceof class_2354 || block instanceof class_2544 || block instanceof class_2389 || block instanceof class_8923 || block instanceof class_2323 || block instanceof class_2533 || block instanceof class_2244 || block instanceof class_5172 || block == class_2246.field_10576 || block == class_2246.field_23985 || block == class_2246.field_28048 || block == class_2246.field_10455 || block instanceof class_5800 || block instanceof class_5801 || block instanceof class_5808;
    }

    private boolean isObstructiveNonQualifyingSolidBlock(class_2338 blockPos) {
        class_2680 blockState = this.getWorld((class_1314)this.mob).method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        return this.isObstructiveNonQualifyingSolidBlock(block);
    }

    public void method_6268() {
        if (this.targetPlayer != null) {
            if (this.isEntityStuckInDesignatedGlitchBlock((class_1309)this.mob)) {
                float yaw = this.mob.method_36454();
                if ((yaw %= 360.0f) < 0.0f) {
                    yaw += 360.0f;
                }
                class_2350 facing = yaw >= 45.0f && yaw < 135.0f ? class_2350.field_11039 : (yaw >= 135.0f && yaw < 225.0f ? class_2350.field_11043 : (yaw >= 225.0f && yaw < 315.0f ? class_2350.field_11034 : class_2350.field_11035));
                class_2338 feetPos = this.mob.method_24515();
                class_2338 headPos = feetPos.method_10084();
                class_2338 facingFeetPos = feetPos.method_10093(facing);
                class_2338 facingHeadPos = facingFeetPos.method_10084();
                if (this.isStalagmiteBigPotEndRodChainsDripLeafOrAzaleaBlock(feetPos, this.mob.method_37908())) {
                    this.breakingPos = feetPos;
                } else if (this.isStalagmiteBigPotEndRodChainsDripLeafOrAzaleaBlock(headPos, this.mob.method_37908())) {
                    this.breakingPos = headPos;
                } else if (this.isStalagmiteBigPotEndRodChainsDripLeafOrAzaleaBlock(facingFeetPos, this.mob.method_37908())) {
                    this.breakingPos = facingFeetPos;
                } else if (this.isStalagmiteBigPotEndRodChainsDripLeafOrAzaleaBlock(facingHeadPos, this.mob.method_37908())) {
                    this.breakingPos = facingHeadPos;
                }
            } else {
                this.calculatePath();
            }
            if (this.breakingPos != null) {
                if (this.mob.method_24515().method_19771((class_2382)this.breakingPos, 3.0)) {
                    this.explodeBlock();
                } else {
                    this.mob.method_5942().method_6337((double)this.breakingPos.method_10263(), (double)this.breakingPos.method_10264(), (double)this.breakingPos.method_10260(), 1.0);
                }
            }
        }
    }

    private boolean isEntityStuckInDesignatedGlitchBlock(class_1309 entity) {
        class_1937 world = this.getWorld((class_1314)this.mob);
        float yaw = entity.method_36454();
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        class_2350 facing = yaw >= 45.0f && yaw < 135.0f ? class_2350.field_11039 : (yaw >= 135.0f && yaw < 225.0f ? class_2350.field_11043 : (yaw >= 225.0f && yaw < 315.0f ? class_2350.field_11034 : class_2350.field_11035));
        class_2338 feetPos = entity.method_24515();
        class_2338 headPos = feetPos.method_10084();
        class_2338 facingPos = feetPos.method_10093(facing);
        class_2338 facingHeadPos = facingPos.method_10084();
        boolean isFeetStalagmite = this.isStalagmiteBigPotEndRodChainsDripLeafOrAzaleaBlock(feetPos, entity.method_37908());
        boolean isHeadStalagmite = this.isStalagmiteBigPotEndRodChainsDripLeafOrAzaleaBlock(headPos, entity.method_37908());
        boolean isFeetFacingStalagmite = this.isStalagmiteBigPotEndRodChainsDripLeafOrAzaleaBlock(facingPos, entity.method_37908());
        boolean isHeadFacingStalagmite = this.isStalagmiteBigPotEndRodChainsDripLeafOrAzaleaBlock(facingHeadPos, entity.method_37908());
        return (isFeetStalagmite || isHeadStalagmite || isFeetFacingStalagmite || isHeadFacingStalagmite) && this.isEntityNotMoving(entity);
    }

    private boolean isStalagmiteBigPotEndRodChainsDripLeafOrAzaleaBlock(class_2338 pos, class_1937 world) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_27852(class_2246.field_28048) || blockState.method_27852(class_2246.field_10455) || blockState.method_27852(class_2246.field_23985) || blockState.method_27852(class_2246.field_28678) || blockState.method_27852(class_2246.field_28679) || blockState.method_27852(class_2246.field_28682) || blockState.method_27852(class_2246.field_28684) || blockState.method_27852(class_2246.field_42752) || blockState.method_27852(class_2246.field_10429) || blockState.method_27852(class_2246.field_10030) || blockState.method_27852(class_2246.field_21211) || blockState.method_27852(class_2246.field_22422);
    }

    private boolean isEntityNotMoving(class_1309 entity) {
        return entity.method_18798().method_1027() < 0.01;
    }

    private void explodeBlock() {
        this.mob.method_7004();
        this.breakingPos = null;
    }

    public boolean method_6266() {
        if (this.currentPath != null) {
            return this.areSolidBlocksSeparatingPlayerFromMob() && !this.isEntityStuckInDesignatedGlitchBlock((class_1309)this.mob);
        }
        return true;
    }

    public boolean areSolidBlocksSeparatingPlayerFromMob() {
        List positions = this.currentPath.positions();
        for (int i = 0; i < positions.size(); ++i) {
            class_2338 twoBlocksUp;
            BetterBlockPos pos = (BetterBlockPos)positions.get(i);
            class_2338 blockPos = new class_2338(pos.x, pos.y, pos.z);
            if (this.isBreakable(blockPos) || this.isBreakable(blockPos.method_10084())) {
                return true;
            }
            if (i == positions.size() - 1) continue;
            BetterBlockPos nextPos = (BetterBlockPos)positions.get(i + 1);
            if (nextPos.x != pos.x && nextPos.z != pos.z) {
                class_2338 diagonalBlockPos1 = new class_2338(pos.x, pos.y, nextPos.z);
                class_2338 diagonalBlockPos2 = new class_2338(nextPos.x, pos.y, pos.z);
                if ((this.isBreakable(diagonalBlockPos1) || this.isBreakable(diagonalBlockPos1.method_10084())) && this.isSolidBlock(diagonalBlockPos1.method_10074())) {
                    if (this.isSolidBlock(diagonalBlockPos2.method_10074()) && !this.isSolidBlock(diagonalBlockPos2) && !this.isSolidBlock(diagonalBlockPos2)) continue;
                    return true;
                }
                if ((this.isBreakable(diagonalBlockPos2) || this.isBreakable(diagonalBlockPos2.method_10084())) && this.isSolidBlock(diagonalBlockPos2.method_10074())) {
                    if (this.isSolidBlock(diagonalBlockPos1.method_10074()) && !this.isSolidBlock(diagonalBlockPos1) && !this.isSolidBlock(diagonalBlockPos1)) continue;
                    return true;
                }
            }
            if (nextPos.y == pos.y || !this.isBreakable(twoBlocksUp = nextPos.y < pos.y ? new class_2338(nextPos.x, nextPos.y + 2, nextPos.z) : new class_2338(pos.x, pos.y + 2, pos.z))) continue;
            return true;
        }
        return false;
    }

    public void method_6270() {
        this.resetGoal();
    }

    private void resetGoal() {
        this.currentPath = null;
        this.breakingPos = null;
        this.mob.method_5942().method_6340();
    }
}

