/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.mobai;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1308;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2338;

public class PathfindingBlockRegistry {
    private static final ConcurrentMap<class_2338, class_1308> activePathfindingFromBlocks = new ConcurrentHashMap<class_2338, class_1308>();

    public static boolean tryAcquireBlock(class_2338 fromPos, class_1308 mob) {
        if (fromPos == null || mob == null) {
            return false;
        }
        class_1308 currentOwner = (class_1308)activePathfindingFromBlocks.get(fromPos);
        if (currentOwner == mob) {
            return true;
        }
        if (currentOwner != null && !currentOwner.method_31481() && currentOwner.method_5805()) {
            if (PathfindingBlockRegistry.hasBlockInHand(mob) && !PathfindingBlockRegistry.hasBlockInHand(currentOwner)) {
                activePathfindingFromBlocks.put(fromPos, mob);
                return true;
            }
            return false;
        }
        class_1308 previous = activePathfindingFromBlocks.putIfAbsent(fromPos, mob);
        return previous == null || previous == mob || previous.method_31481() || !previous.method_5805();
    }

    private static boolean hasBlockInHand(class_1308 mob) {
        if (mob == null) {
            return false;
        }
        class_1799 mainHand = mob.method_6047();
        return !mainHand.method_7960() && mainHand.method_7909() instanceof class_1747;
    }

    public static void releaseBlock(class_2338 fromPos, class_1308 mob) {
        if (fromPos == null || mob == null) {
            return;
        }
        activePathfindingFromBlocks.remove(fromPos, mob);
    }

    public static void releaseAllBlocksForMob(class_1308 mob) {
        if (mob == null) {
            return;
        }
        activePathfindingFromBlocks.entrySet().removeIf(entry -> entry.getValue() == mob);
    }

    public static boolean isBlockOccupied(class_2338 fromPos) {
        if (fromPos == null) {
            return false;
        }
        class_1308 owner = (class_1308)activePathfindingFromBlocks.get(fromPos);
        return owner != null && !owner.method_31481() && owner.method_5805();
    }

    public static class_1308 getBlockOwner(class_2338 fromPos) {
        if (fromPos == null) {
            return null;
        }
        class_1308 owner = (class_1308)activePathfindingFromBlocks.get(fromPos);
        if (owner != null && (owner.method_31481() || !owner.method_5805())) {
            activePathfindingFromBlocks.remove(fromPos);
            return null;
        }
        return owner;
    }

    public static void cleanup() {
        activePathfindingFromBlocks.entrySet().removeIf(entry -> {
            class_1308 mob = (class_1308)entry.getValue();
            return mob == null || mob.method_31481() || !mob.method_5805();
        });
    }

    public static int getActiveCount() {
        return activePathfindingFromBlocks.size();
    }
}

