/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.persistent;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.example.persistent.FakePlayerEntity;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2703;
import net.minecraft.class_2739;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class FakePlayerManager {
    private static final Map<UUID, FakePlayerEntity> fakePlayers = new HashMap<UUID, FakePlayerEntity>();

    public static void registerEvents() {
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.field_14140;
            class_3218 world = player.method_51469();
            UUID playerUUID = player.method_5667();
            if (fakePlayers.containsKey(playerUUID)) {
                System.out.println("Fake player already exists for " + player.method_5477().getString());
                return;
            }
            class_2338 pos = player.method_24515();
            GameProfile gameProfile = new GameProfile(UUID.randomUUID(), "FakePlayerName");
            FakePlayerEntity fakePlayer = new FakePlayerEntity(world, pos, gameProfile);
            fakePlayer.method_23327((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
            fakePlayer.method_5808((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
            if (world.method_8649((class_1297)fakePlayer)) {
                fakePlayers.put(playerUUID, fakePlayer);
                FakePlayerManager.addFakePlayer(fakePlayer);
                System.out.println("Fake player spawned for " + player.method_5477().getString());
            } else {
                System.err.println("Failed to spawn fake player for " + player.method_5477().getString());
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            UUID playerUUID = player.method_5667();
            FakePlayerEntity fakePlayer = fakePlayers.remove(playerUUID);
            if (fakePlayer != null) {
                fakePlayer.method_31472();
                System.out.println("Removed fake player for " + player.method_5477().getString());
            }
        });
    }

    public static void addFakePlayer(FakePlayerEntity fakePlayer) {
        class_2703 addToTabListPacket = new class_2703(class_2703.class_5893.field_29136, (class_3222)fakePlayer);
        class_2604 spawnPacket = new class_2604(fakePlayer.method_5628(), fakePlayer.method_5667(), fakePlayer.method_23317(), fakePlayer.method_23318(), fakePlayer.method_23321(), fakePlayer.method_36455(), fakePlayer.method_36454(), fakePlayer.method_5864(), 0, class_243.field_1353, 0.0);
        List trackedValues = fakePlayer.method_5841().method_46357();
        class_2739 metadataPacket = new class_2739(fakePlayer.method_5628(), trackedValues);
        for (class_3222 player : fakePlayer.method_5682().method_3760().method_14571()) {
            player.field_13987.method_14364((class_2596)addToTabListPacket);
            player.field_13987.method_14364((class_2596)spawnPacket);
            player.field_13987.method_14364((class_2596)metadataPacket);
        }
    }
}

