/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.example.service;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.event.listener.IGameEventListener;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.example.bloodmoon.server.BloodmoonHandler;
import net.fabricmc.example.client.path.PathUpdateListener;
import net.fabricmc.example.model.MobitoneProvision;
import net.fabricmc.example.service.MobitoneService;
import net.fabricmc.example.util.MinecraftServerUtil;
import net.minecraft.class_1309;

public class MobitoneServiceImpl
implements MobitoneService {
    private static int maxProvisionDeadlineSeconds = 120;
    private static int maxMobitoneProvisions = 25;
    private static List<MobitoneProvision> mobitoneProvisions = new ArrayList<MobitoneProvision>();
    private static List<class_1309> queue = new ArrayList<class_1309>();

    public static void addMobitone(class_1309 livingEntity) {
        if (MinecraftServerUtil.getMinecraftServer() == null) {
            return;
        }
        MobitoneProvision existingMobitoneProvision = mobitoneProvisions.stream().filter(mobitoneProvisionQuery -> mobitoneProvisionQuery.getLivingEntity().equals((Object)livingEntity)).findFirst().orElse(null);
        if (existingMobitoneProvision != null) {
            existingMobitoneProvision.updateProvisionTime();
            return;
        }
        mobitoneProvisions.add(new MobitoneProvision(livingEntity));
        BaritoneAPI.getProvider().createBaritone(MinecraftServerUtil.getMinecraftServer(), livingEntity);
        IBaritone baritone = BaritoneAPI.getProvider().getBaritoneForEntity(livingEntity);
        if (baritone != null && baritone.getPathingBehavior() != null) {
            PathUpdateListener pathUpdateListener = new PathUpdateListener(livingEntity.method_5628(), baritone.getPathingBehavior());
            baritone.getGameEventHandler().registerEventListener((IGameEventListener)pathUpdateListener);
        }
    }

    public static void removeMobitone(class_1309 livingEntity) {
        if (MinecraftServerUtil.getMinecraftServer() == null) {
            return;
        }
        IBaritone goalBaritone = BaritoneAPI.getProvider().getBaritoneForEntity(livingEntity);
        if (goalBaritone != null) {
            BaritoneAPI.getProvider().destroyBaritone(goalBaritone);
        }
        if (queue.contains(livingEntity)) {
            queue.remove(livingEntity);
        } else {
            MobitoneProvision existingMobitoneProvision = mobitoneProvisions.stream().filter(mobitoneProvisionQuery -> mobitoneProvisionQuery.getLivingEntity().equals((Object)livingEntity)).findFirst().orElse(null);
            if (existingMobitoneProvision != null) {
                mobitoneProvisions.remove(existingMobitoneProvision);
            }
        }
        MobitoneServiceImpl.fillInQueue();
    }

    public static void removeOutdatedMobitones() {
        if (!BloodmoonHandler.INSTANCE.isBloodmoonActive()) {
            return;
        }
        mobitoneProvisions.stream().filter(mobitoneProvisionQuery -> {
            LocalDateTime now = LocalDateTime.now(ZoneOffset.UTC);
            Duration duration = Duration.between(mobitoneProvisionQuery.getProvisionTime(), now);
            return duration.getSeconds() > (long)maxProvisionDeadlineSeconds;
        }).findFirst().ifPresent(mobitoneProvision -> {
            IBaritone goalBaritone = BaritoneAPI.getProvider().getBaritoneForEntity(mobitoneProvision.getLivingEntity());
            if (goalBaritone != null) {
                BaritoneAPI.getProvider().destroyBaritone(goalBaritone);
            }
            mobitoneProvisions.remove(mobitoneProvision);
        });
    }

    public static void fillInQueue() {
    }

    public static void updateMobitoneProvision(class_1309 livingEntity) {
        mobitoneProvisions.stream().filter(mobitoneProvisionQuery -> mobitoneProvisionQuery.getLivingEntity().equals((Object)livingEntity)).findFirst().ifPresent(MobitoneProvision::updateProvisionTime);
    }
}

