/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.ner.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class NamespacedFilterManager {
    private static final Map<String, List<ItemStack>> NAMESPACED_ITEMS = new HashMap<String, List<ItemStack>>();
    private static final Map<ItemStack, String> NAMESPACE_CACHE = new HashMap<ItemStack, String>();

    public static void addItem(String namespace, ItemStack item) {
        namespace = namespace.toLowerCase(Locale.ROOT);
        NAMESPACED_ITEMS.computeIfAbsent(namespace, k -> new ArrayList()).add(item);
    }

    public static List<String> getMatchingNamespaces(String partialNamespace) {
        partialNamespace = partialNamespace.toLowerCase(Locale.ROOT);
        ArrayList<String> matching = new ArrayList<String>();
        for (String key : NAMESPACED_ITEMS.keySet()) {
            if (!key.contains(partialNamespace)) continue;
            matching.add(key);
        }
        return matching;
    }

    public static List<ItemStack> getItems(List<String> namespaces) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (String ns : namespaces) {
            List<ItemStack> items = NAMESPACED_ITEMS.get(ns.toLowerCase(Locale.ROOT));
            if (items == null) continue;
            result.addAll(items);
        }
        return result;
    }

    public static String getNamespace(ItemStack item) {
        if (NAMESPACE_CACHE.containsKey(item)) {
            return NAMESPACE_CACHE.get(item);
        }
        for (Map.Entry<String, List<ItemStack>> entry : NAMESPACED_ITEMS.entrySet()) {
            if (!entry.getValue().contains(item)) continue;
            NAMESPACE_CACHE.put(item, entry.getKey());
            return entry.getKey();
        }
        return "zzzzz";
    }
}

