/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.ner.gui;

import com.github.darksoulq.abyssallib.server.resource.util.TextOffset;
import com.github.darksoulq.abyssallib.world.gui.Gui;
import com.github.darksoulq.abyssallib.world.gui.GuiElement;
import com.github.darksoulq.abyssallib.world.gui.GuiFlag;
import com.github.darksoulq.abyssallib.world.gui.GuiLayer;
import com.github.darksoulq.abyssallib.world.gui.GuiManager;
import com.github.darksoulq.abyssallib.world.gui.GuiView;
import com.github.darksoulq.abyssallib.world.gui.SlotPosition;
import com.github.darksoulq.abyssallib.world.gui.impl.GuiButton;
import com.github.darksoulq.abyssallib.world.gui.impl.GuiItem;
import com.github.darksoulq.abyssallib.world.gui.impl.PaginatedElements;
import com.github.darksoulq.abyssallib.world.item.Item;
import com.github.darksoulq.ner.NeverEnoughRecipes;
import com.github.darksoulq.ner.data.Input;
import com.github.darksoulq.ner.data.NamespacedFilterManager;
import com.github.darksoulq.ner.data.RecipeManager;
import com.github.darksoulq.ner.gui.GuiHistory;
import com.github.darksoulq.ner.gui.GuiInfo;
import com.github.darksoulq.ner.gui.RecipeViewer;
import com.github.darksoulq.ner.gui.SearchMenu;
import com.github.darksoulq.ner.resources.Pack;
import com.github.darksoulq.ner.resources.UiItems;
import com.github.darksoulq.ner.util.TextUtil;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;

public class MainMenu {
    static final Map<UUID, ItemStack[]> INVENTORY_BACKUPS = new HashMap<UUID, ItemStack[]>();
    public static List<ItemStack> ITEMS = MainMenu.sortDisplay(new ArrayList<ItemStack>(RecipeManager.getAllItems()));
    private static Map<FilterType, ItemStack> FILTER_ITEMS;
    private static final int[] DISPLAY_SLOTS;
    private static final int[] BOTTOM_SLOTS;

    public static void init() {
        FILTER_ITEMS = Map.of(FilterType.RECENT, MainMenu.createFilterItem(FilterType.RECENT), FilterType.INVENTORY, MainMenu.createFilterItem(FilterType.INVENTORY), FilterType.FAVOURITE, MainMenu.createFilterItem(FilterType.FAVOURITE));
    }

    public static Gui create() {
        return MainMenu.create(new GuiInfo.Main(0, 0, FilterType.RECENT));
    }

    public static Gui create(GuiInfo.Main info) {
        ArrayList<GuiElement> displayElements = new ArrayList<GuiElement>();
        MainMenu.populateElements(displayElements, info);
        PaginatedElements displayPage = new PaginatedElements(displayElements, DISPLAY_SLOTS, GuiView.Segment.TOP);
        Function<GuiView, List> getFilterElements = view -> {
            UUID uuid = view.getInventoryView().getPlayer().getUniqueId();
            ArrayList<Object> elements = new ArrayList<Object>();
            if (info.filter == FilterType.INVENTORY) {
                ItemStack[] items = INVENTORY_BACKUPS.get(uuid);
                if (items == null) {
                    return elements;
                }
                for (ItemStack item : items = (ItemStack[])items.clone()) {
                    if (item == null) {
                        elements.add(GuiItem.of((ItemStack)ItemStack.empty()));
                        continue;
                    }
                    elements.add(GuiButton.of((ItemStack)item, (gv, click) -> {
                        if (!click.isShiftClick() && click.isLeftClick()) {
                            MainMenu.openRecipe(view, item, info, RecipeViewer.RecipeType.RECIPE);
                        } else if (click.isRightClick()) {
                            MainMenu.openRecipe(view, item, info, RecipeViewer.RecipeType.USE);
                        } else if (Input.isShiftLeftClick(click)) {
                            MainMenu.addFavourite(view.getInventoryView().getPlayer().getUniqueId(), item);
                        }
                    }));
                }
                return elements;
            }
            if (info.filter == FilterType.FAVOURITE) {
                List favourites = (List)((Map)NeverEnoughRecipes.getPrefs().favourites.get()).get(uuid.toString());
                if (favourites == null) {
                    return elements;
                }
                for (ItemStack item : favourites) {
                    elements.add(GuiButton.of((ItemStack)item, (gv, click) -> {
                        if (Input.isShiftRightClick(click)) {
                            MainMenu.removeFavourite(uuid, item);
                        } else if (click.isLeftClick()) {
                            MainMenu.openRecipe(view, item, info, RecipeViewer.RecipeType.RECIPE);
                        } else if (!click.isShiftClick() && click.isRightClick()) {
                            MainMenu.openRecipe(view, item, info, RecipeViewer.RecipeType.USE);
                        }
                    }));
                }
                return elements;
            }
            if (info.filter == FilterType.RECENT) {
                List recents = (List)((Map)NeverEnoughRecipes.getPrefs().recents.get()).get(uuid.toString());
                if (recents == null) {
                    return elements;
                }
                for (ItemStack item : recents) {
                    elements.add(GuiButton.of((ItemStack)item, (gv, click) -> {
                        if (!click.isShiftClick() && click.isLeftClick()) {
                            MainMenu.openRecipe(gv, item, info, RecipeViewer.RecipeType.RECIPE);
                        } else if (click.isRightClick()) {
                            MainMenu.openRecipe(gv, item, info, RecipeViewer.RecipeType.USE);
                        } else if (Input.isShiftLeftClick(click)) {
                            MainMenu.addFavourite(uuid, item);
                        }
                    }));
                }
            }
            return elements;
        };
        AtomicReference filterPage = new AtomicReference();
        ItemStack displayPageIndicator = MainMenu.createPageIndicator();
        MainMenu.updatePageIndicator(displayPage, displayPageIndicator, info);
        Gui.Builder gui = new Gui.Builder((MenuType)MenuType.GENERIC_9X6, MainMenu.getTitle(info.filter)).addFlags(new GuiFlag[]{GuiFlag.DISABLE_ADVANCEMENTS, GuiFlag.DISABLE_ITEM_PICKUP}).addLayer((GuiLayer)displayPage).set(SlotPosition.top((int)45), (GuiElement)GuiButton.of((ItemStack)FILTER_ITEMS.get((Object)info.filter), (view, clickType) -> {
            switch (info.filter.ordinal()) {
                case 0: {
                    GuiManager.close((HumanEntity)view.getInventoryView().getPlayer());
                    GuiManager.open((HumanEntity)view.getInventoryView().getPlayer(), (Gui)MainMenu.create(new GuiInfo.Main(info.page, info.favouritesPage, FilterType.INVENTORY)));
                    break;
                }
                case 1: {
                    GuiManager.close((HumanEntity)view.getInventoryView().getPlayer());
                    GuiManager.open((HumanEntity)view.getInventoryView().getPlayer(), (Gui)MainMenu.create(new GuiInfo.Main(info.page, info.favouritesPage, FilterType.FAVOURITE)));
                    break;
                }
                case 2: {
                    GuiManager.close((HumanEntity)view.getInventoryView().getPlayer());
                    GuiManager.open((HumanEntity)view.getInventoryView().getPlayer(), (Gui)MainMenu.create(new GuiInfo.Main(info.page, info.favouritesPage, FilterType.RECENT)));
                }
            }
        })).set(SlotPosition.top((int)50), (GuiElement)GuiButton.of((ItemStack)((Item)UiItems.NEXT.get()).getStack(), (view, click) -> {
            displayPage.next(view);
            MainMenu.updatePageIndicator(displayPage, displayPageIndicator, info);
        })).set(SlotPosition.top((int)49), (GuiElement)GuiButton.of((ItemStack)((Item)UiItems.SEARCH.get()).getStack(), (view, clickType) -> {
            GuiManager.close((HumanEntity)view.getInventoryView().getPlayer());
            GuiManager.open((HumanEntity)view.getInventoryView().getPlayer(), (Gui)SearchMenu.create());
        })).set(SlotPosition.top((int)48), (GuiElement)GuiButton.of((ItemStack)((Item)UiItems.PREV.get()).getStack(), (view, click) -> {
            displayPage.prev(view);
            MainMenu.updatePageIndicator(displayPage, displayPageIndicator, info);
        })).set(SlotPosition.top((int)53), (GuiElement)GuiButton.of((ItemStack)((Item)UiItems.CLOSE.get()).getStack(), (view, click) -> GuiManager.close((HumanEntity)view.getInventoryView().getPlayer()))).onClose(MainMenu::loadBackup).onOpen(view -> {
            MainMenu.setupBackup(view);
            filterPage.set(new PaginatedElements((List)getFilterElements.apply((GuiView)view), BOTTOM_SLOTS, GuiView.Segment.BOTTOM));
            view.getGui().getLayers().add((GuiLayer)filterPage.get());
        });
        if (info.filter == FilterType.FAVOURITE) {
            gui.set(SlotPosition.bottom((int)5), (GuiElement)GuiButton.of((ItemStack)((Item)UiItems.NEXT.get()).getStack(), (view, click) -> {
                ((PaginatedElements)filterPage.get()).next(view);
                info.favouritesPage = ((PaginatedElements)filterPage.get()).getPage();
            })).set(SlotPosition.bottom((int)3), (GuiElement)GuiButton.of((ItemStack)((Item)UiItems.PREV.get()).getStack(), (view, click) -> {
                ((PaginatedElements)filterPage.get()).next(view);
                info.favouritesPage = ((PaginatedElements)filterPage.get()).getPage();
            }));
        }
        return gui.build();
    }

    private static Component getTitle(FilterType type) {
        return TextUtil.parse("<white><offset><texture></white><width>Main Menu", new TagResolver[]{Placeholder.parsed((String)"offset", (String)TextOffset.getOffsetMinimessage((int)-8)), Placeholder.parsed((String)"texture", (String)(type.equals((Object)FilterType.INVENTORY) ? Pack.MAIN_MENU_INV.toMiniMessageString() : Pack.MAIN_MENU.toMiniMessageString())), Placeholder.parsed((String)"width", (String)TextOffset.getOffsetMinimessage((int)-170))});
    }

    private static ItemStack createFilterItem(FilterType type) {
        String[] holder = new String[]{type == FilterType.RECENT ? "<!italic><white><bold>Recent</bold><white>" : "<!italic><gray>Recent</gray>", type == FilterType.INVENTORY ? "<!italic><white><bold>Inventory</bold><white>" : "<!italic><gray>Inventory</gray>", type == FilterType.FAVOURITE ? "<!italic><white><bold>Favourites</bold><white>" : "<!italic><gray>Favourites</gray>"};
        Item filterItem = ((Item)UiItems.FILTER.get()).clone();
        Item.Tooltip tl = filterItem.tooltip;
        tl.lines.clear();
        tl.addLine(TextUtil.parse(holder[0]));
        tl.addLine(TextUtil.parse(holder[1]));
        tl.addLine(TextUtil.parse(holder[2]));
        filterItem.updateTooltip();
        return filterItem.getStack();
    }

    static ItemStack createPageIndicator() {
        ItemStack pageIndicator = new ItemStack(Material.BOOK);
        pageIndicator.setData(DataComponentTypes.ITEM_NAME, (Object)TextUtil.parse("<green>Page</green>"));
        return pageIndicator;
    }

    static void setupBackup(GuiView view) {
        Player player = (Player)view.getInventoryView().getPlayer();
        INVENTORY_BACKUPS.put(player.getUniqueId(), player.getInventory().getContents());
        Object[] bottomContents = view.getBottom().getContents();
        Arrays.fill(bottomContents, ItemStack.empty());
        view.getBottom().setContents((ItemStack[])bottomContents);
    }

    static void loadBackup(GuiView view) {
        view.getTop().setItem(0, ItemStack.of((Material)Material.AIR));
        Object[] bottomContents = view.getBottom().getContents();
        Arrays.fill(bottomContents, ItemStack.empty());
        view.getBottom().setContents((ItemStack[])bottomContents);
        Player player = (Player)view.getInventoryView().getPlayer();
        ItemStack[] backup = INVENTORY_BACKUPS.remove(player.getUniqueId());
        if (backup != null) {
            player.getInventory().setContents(backup);
        }
    }

    static void populateElements(List<GuiElement> elements, GuiInfo info) {
        for (int i = 0; i < ITEMS.size(); ++i) {
            ItemStack item = ITEMS.get(i);
            elements.add((GuiElement)new GuiButton(item, (view, clickType) -> {
                if (!clickType.isShiftClick() && clickType.isLeftClick()) {
                    MainMenu.openRecipe(view, item, info, RecipeViewer.RecipeType.RECIPE);
                } else if (clickType.isRightClick()) {
                    MainMenu.openRecipe(view, item, info, RecipeViewer.RecipeType.USE);
                } else if (Input.isShiftLeftClick(clickType)) {
                    MainMenu.addFavourite(view.getInventoryView().getPlayer().getUniqueId(), item);
                }
            }));
        }
    }

    public static void updatePageIndicator(PaginatedElements elements, ItemStack pageItem, GuiInfo info) {
        String loreText = String.format("<green>%d <gray>of</gray> %d <gray>pages</gray></green>", elements.getPage() + 1, elements.pageCount());
        pageItem.setData(DataComponentTypes.LORE, (Object)((ItemLore)ItemLore.lore().lines(Collections.singletonList(TextUtil.parse(loreText))).build()));
        if (info instanceof GuiInfo.Main) {
            GuiInfo.Main m = (GuiInfo.Main)info;
            m.page = elements.getPage();
        }
        if (info instanceof GuiInfo.Search) {
            GuiInfo.Search s = (GuiInfo.Search)info;
            s.page = elements.getPage();
        }
    }

    public static void addToRecents(UUID uuid, ItemStack viewed) {
        NeverEnoughRecipes.updatePrefs(p -> {
            HashMap<String, List> map = new HashMap<String, List>((Map)p.recents.get());
            List recents = map.computeIfAbsent(uuid.toString(), k -> new LinkedList());
            recents.removeIf(s -> s.isSimilar(viewed));
            recents.addFirst(viewed.clone());
            while (recents.size() > 15) {
                recents.removeLast();
            }
            p.recents.set(map);
        });
    }

    public static void addFavourite(UUID uuid, ItemStack item) {
        NeverEnoughRecipes.updatePrefs(p -> {
            HashMap<String, List> map = new HashMap<String, List>((Map)p.favourites.get());
            List favourites = map.computeIfAbsent(uuid.toString(), k -> new LinkedList());
            if (favourites.contains(item)) {
                return;
            }
            favourites.add(item);
            p.favourites.set(map);
        });
    }

    public static void removeFavourite(UUID uuid, ItemStack item) {
        NeverEnoughRecipes.updatePrefs(p -> {
            HashMap<String, List> map = new HashMap<String, List>((Map)p.favourites.get());
            List favourites = map.computeIfAbsent(uuid.toString(), k -> new LinkedList());
            favourites.remove(item);
            p.favourites.set(map);
        });
    }

    public static void openRecipe(GuiView view, ItemStack item, GuiInfo info, RecipeViewer.RecipeType type) {
        if (type.equals((Object)RecipeViewer.RecipeType.USE) && RecipeManager.getUsesForItem(item).isEmpty()) {
            return;
        }
        if (type.equals((Object)RecipeViewer.RecipeType.RECIPE) && RecipeManager.getRecipesForResult(item).isEmpty()) {
            return;
        }
        HumanEntity player = view.getInventoryView().getPlayer();
        GuiManager.close((HumanEntity)player);
        if (!(info instanceof GuiInfo.Search)) {
            GuiHistory.push(player.getUniqueId(), info);
        }
        MainMenu.addToRecents(player.getUniqueId(), item);
        GuiManager.open((HumanEntity)player, (Gui)RecipeViewer.create(item, 0, type));
    }

    public static List<ItemStack> sortDisplay(List<ItemStack> items) {
        PlainTextComponentSerializer plain = PlainTextComponentSerializer.plainText();
        HashMap<String, List> byNs = new HashMap<String, List>();
        for (ItemStack stack : items) {
            byNs.computeIfAbsent(NamespacedFilterManager.getNamespace(stack), k -> new ArrayList()).add(stack);
        }
        Comparator<ItemStack> alpha = Comparator.comparing(s -> {
            Component name = Optional.ofNullable((Component)s.getData(DataComponentTypes.CUSTOM_NAME)).orElse((Component)s.getData(DataComponentTypes.ITEM_NAME));
            return plain.serialize((Component)(name == null ? Component.text((String)"") : name));
        }, String.CASE_INSENSITIVE_ORDER);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (byNs.containsKey("minecraft")) {
            ((List)byNs.get("minecraft")).sort(alpha);
            result.addAll((Collection)byNs.remove("minecraft"));
        }
        byNs.keySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).forEach(ns -> {
            ((List)byNs.get(ns)).sort(alpha);
            result.addAll((Collection)byNs.get(ns));
        });
        return result;
    }

    static {
        DISPLAY_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
        BOTTOM_SLOTS = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    }

    public static enum FilterType {
        RECENT("lore.ner.recent"),
        INVENTORY("lore.ner.inventory"),
        FAVOURITE("lore.ner.favourite");

        public final String name;

        private FilterType(String name) {
            this.name = name;
        }
    }
}

