/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.ner.layout.impl;

import com.github.darksoulq.ner.layout.RecipeLayout;
import com.github.darksoulq.ner.model.ParsedRecipeView;
import com.github.darksoulq.ner.resources.Pack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class ShapedRecipeLayout
extends RecipeLayout<ShapedRecipe> {
    private static final int[] TARGET_SLOTS = new int[]{11, 12, 13, 20, 21, 22, 29, 30, 31};

    @Override
    public Class<ShapedRecipe> getRecipeClass() {
        return ShapedRecipe.class;
    }

    @Override
    public ParsedRecipeView parseRecipe(ShapedRecipe recipe) {
        String[] shape = recipe.getShape();
        Map ing = recipe.getChoiceMap();
        HashMap<Integer, List<ItemStack>> slotMap = new HashMap<Integer, List<ItemStack>>();
        Object[] normalizedShape = new String[3];
        Arrays.fill(normalizedShape, "   ");
        for (int row = 0; row < shape.length; ++row) {
            String line = shape[row];
            normalizedShape[row] = String.format("%-3s", line);
        }
        int index = 0;
        for (int row = 0; row < 3; ++row) {
            int col = 0;
            while (col < 3) {
                char key = ((String)normalizedShape[row]).charAt(col);
                RecipeChoice choice = (RecipeChoice)ing.get(Character.valueOf(key));
                if (choice != null && !choice.equals((Object)RecipeChoice.empty())) {
                    ShapedRecipeLayout.setItems(slotMap, TARGET_SLOTS[index], choice);
                }
                ++col;
                ++index;
            }
        }
        slotMap.put(24, List.of(recipe.getResult()));
        return new ParsedRecipeView(slotMap, Pack.CRAFTING_TABLE, -8, new ItemStack(Material.CRAFTING_TABLE));
    }

    @Override
    public Set<Integer> getOutputSlots() {
        return Set.of(Integer.valueOf(24));
    }
}

