/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.nem.data;

import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MinetorioTables;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import com.github.darksoulq.nem.data.recipe.AdvancedAssemblerRecipe;
import com.github.darksoulq.nem.data.recipe.BasicAssemblerRecipe;
import com.github.darksoulq.nem.data.recipe.CrudeAssemblerRecipe;
import com.github.darksoulq.nem.data.recipe.CrusherRecipe;
import com.github.darksoulq.nem.data.recipe.MTWrappedRecipe;
import com.github.darksoulq.nem.data.recipe.MultiOutputRecipe;
import com.github.darksoulq.nem.data.recipe.SifterRecipe;
import com.github.darksoulq.nem.layout.AdvancedAssemblerLayout;
import com.github.darksoulq.nem.layout.BasicAssemblerLayout;
import com.github.darksoulq.nem.layout.CrudeAssemblerLayout;
import com.github.darksoulq.nem.layout.CrusherLayout;
import com.github.darksoulq.nem.layout.SifterLayout;
import com.github.darksoulq.ner.NerApi;
import com.github.darksoulq.ner.layout.RecipeLayout;
import com.github.darksoulq.ner.layout.RecipeLayoutRegistry;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class RecipeLoader {
    public static void init() {
        RecipeLayoutRegistry.register((RecipeLayout)new AdvancedAssemblerLayout());
        RecipeLayoutRegistry.register((RecipeLayout)new CrudeAssemblerLayout());
        RecipeLayoutRegistry.register((RecipeLayout)new BasicAssemblerLayout());
        RecipeLayoutRegistry.register((RecipeLayout)new CrusherLayout());
        RecipeLayoutRegistry.register((RecipeLayout)new SifterLayout());
        for (ItemStack s : ItemMenu.getAllItems()) {
            NerApi.addItemToNamespace((String)"minetorio", (ItemStack)s);
        }
        ArrayList recipes = RecipeUtils.getAllRecipeData();
        recipes.forEach(r -> {
            switch (r.getType()) {
                case BASIC: {
                    RecipeLoader.addRecipe(new BasicAssemblerRecipe((MTRecipe)r), r.getResult());
                    break;
                }
                case CRUDE: {
                    RecipeLoader.addRecipe(new CrudeAssemblerRecipe((MTRecipe)r), r.getResult());
                    break;
                }
                case ADVANCED: {
                    RecipeLoader.addRecipe(new AdvancedAssemblerRecipe((MTRecipe)r), r.getResult());
                }
            }
        });
        ArrayList siftables = MinetorioTables.getSiftable();
        siftables.forEach(m -> {
            SifterRecipe r = new SifterRecipe(ItemStack.of((Material)m));
            for (ItemStack res : r.getOutput()) {
                RecipeLoader.addRecipe(r, res);
            }
        });
        ArrayList crushables = MinetorioTables.getCrushables();
        crushables.forEach(m -> {
            CrusherRecipe r = new CrusherRecipe(ItemStack.of((Material)m));
            RecipeLoader.addRecipe(r, r.getOutput());
        });
    }

    private static void addRecipe(MTWrappedRecipe recipe, ItemStack result) {
        NerApi.registerRecipe((ItemStack)result, (Object)recipe);
    }

    private static void addRecipe(MultiOutputRecipe recipe, ItemStack result) {
        NerApi.registerRecipe((ItemStack)result, (Object)recipe);
    }

    private static void addRecipe(CrusherRecipe recipe, ItemStack result) {
        NerApi.registerRecipe((ItemStack)result, (Object)recipe);
    }
}

