/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.nem.layout;

import com.MT.xxxtrigger50xxx.Devices.Device;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.world.item.Item;
import com.github.darksoulq.nem.data.recipe.MTWrappedRecipe;
import com.github.darksoulq.ner.layout.RecipeLayout;
import com.github.darksoulq.ner.model.ParsedRecipeView;
import com.github.darksoulq.ner.resources.Pack;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;

public abstract class MTRecipeLayout<T extends MTWrappedRecipe>
extends RecipeLayout<T> {
    private static final int[] TARGET_SLOTS = new int[]{11, 12, 13, 20, 21, 22, 29, 30, 31};
    private final ItemStack device;

    public MTRecipeLayout(ItemStack device) {
        this.device = device;
    }

    public ParsedRecipeView parseRecipe(T recipe) {
        return new ParsedRecipeView(this.handleParse(recipe), Pack.CRAFTING_TABLE, -8, this.device);
    }

    public Map<Integer, List<ItemStack>> handleParse(T recipe) {
        HashMap<Integer, List<ItemStack>> slotMap = new HashMap<Integer, List<ItemStack>>();
        List<ItemStack> ingredients = ((MTWrappedRecipe)recipe).getIngredients();
        for (int i = 0; i < ingredients.size(); ++i) {
            slotMap.put(TARGET_SLOTS[i], List.of(ingredients.get(i)));
        }
        if (((MTWrappedRecipe)recipe).hasLiquid() && ((MTWrappedRecipe)recipe).getLiquidAmount() > 0) {
            Device.LiquidType type = ((MTWrappedRecipe)recipe).getLiquid();
            int amount = ((MTWrappedRecipe)recipe).getLiquidAmount();
            ItemStack liquidIcon = new ItemStack(Material.PAPER);
            switch (type) {
                case SULFURIC_ACID: {
                    this.setLiquidIcon(liquidIcon, "sulfuric_acid", amount, (TextColor)NamedTextColor.YELLOW);
                    break;
                }
                case LIGHTOIL: {
                    this.setLiquidIcon(liquidIcon, "light_oil", amount, (TextColor)NamedTextColor.GRAY);
                    break;
                }
                case HEAVYOIL: {
                    this.setLiquidIcon(liquidIcon, "heavy_oil", amount, (TextColor)NamedTextColor.DARK_GRAY);
                    break;
                }
                case LUBRICANT: {
                    this.setLiquidIcon(liquidIcon, "lubricant", amount, (TextColor)NamedTextColor.BLACK);
                    break;
                }
                case PETROL: {
                    this.setLiquidIcon(liquidIcon, "petrol", amount, (TextColor)NamedTextColor.GOLD);
                    break;
                }
                case OIL: {
                    this.setLiquidIcon(liquidIcon, "oil", amount, (TextColor)NamedTextColor.DARK_GRAY);
                    break;
                }
                case STEAM: {
                    this.setLiquidIcon(liquidIcon, "steam", amount, (TextColor)NamedTextColor.WHITE);
                    break;
                }
                case WATER: {
                    this.setLiquidIcon(liquidIcon, "water", amount, (TextColor)NamedTextColor.BLUE);
                }
            }
            slotMap.put(18, List.of(liquidIcon));
        }
        if (((MTWrappedRecipe)recipe).hasTech()) {
            String tech = ((MTWrappedRecipe)recipe).getTech();
            Item techItem = new Item(Identifier.of((String)"nem", (String)"research"), Material.PAPER);
            Item.Tooltip tl = techItem.tooltip;
            tl.lines.clear();
            tl.addLine(((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)Component.translatable((String)"lore.nem.research_required").color((TextColor)NamedTextColor.DARK_GREEN)).decoration(TextDecoration.ITALIC, false)).decoration(TextDecoration.BOLD, true)).append((Component)Component.text((String)(": " + tech)))).decoration(TextDecoration.ITALIC, false)).decoration(TextDecoration.BOLD, true));
            techItem.updateTooltip();
            slotMap.put(26, List.of(techItem.getStack()));
        }
        slotMap.put(24, List.of(((MTWrappedRecipe)recipe).getResult()));
        return slotMap;
    }

    public Set<Integer> getOutputSlots() {
        return Set.of(Integer.valueOf(24));
    }

    private void setLiquidIcon(ItemStack stack, String name, int amount, TextColor color) {
        stack.setData(DataComponentTypes.ITEM_MODEL, (Object)new NamespacedKey("nem", name));
        stack.setData(DataComponentTypes.ITEM_NAME, (Object)Component.translatable((String)("item.nem." + name)));
        stack.setData(DataComponentTypes.LORE, (Object)((ItemLore)ItemLore.lore().lines(List.of((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)Component.translatable((String)"lore.nem.liquid_amount").color(color)).decoration(TextDecoration.ITALIC, false)).decoration(TextDecoration.BOLD, true)).append((Component)Component.text((String)(": " + amount)))).decoration(TextDecoration.ITALIC, false)).decoration(TextDecoration.BOLD, true))).build()));
    }
}

