/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.nem.layout;

import com.github.darksoulq.abyssallib.world.item.Item;
import com.github.darksoulq.nem.data.Pack;
import com.github.darksoulq.nem.data.recipe.MultiOutputRecipe;
import com.github.darksoulq.ner.layout.PaginatedSection;
import com.github.darksoulq.ner.layout.RecipeLayout;
import com.github.darksoulq.ner.model.ParsedRecipeView;
import com.github.darksoulq.ner.resources.UiItems;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.inventory.ItemStack;

public abstract class MultiOutputLayout<T extends MultiOutputRecipe>
extends RecipeLayout<T> {
    private static final int[] SLOTS = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
    private final ItemStack device;

    public MultiOutputLayout(ItemStack device) {
        this.device = device;
    }

    public ParsedRecipeView parseRecipe(MultiOutputRecipe recipe) {
        HashMap<Integer, List<ItemStack>> slotMap = new HashMap<Integer, List<ItemStack>>();
        slotMap.put(4, List.of(recipe.getInput()));
        PaginatedSection section = new PaginatedSection(SLOTS, recipe.getOutput(), new PaginatedSection.Button(((Item)UiItems.NEXT.get()).getStack(), 44), new PaginatedSection.Button(((Item)UiItems.PREV.get()).getStack(), 36));
        return new ParsedRecipeView(slotMap, Pack.MULTI_OUTPUT, -8, this.device, List.of(section));
    }

    public Set<Integer> getOutputSlots() {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (int slot : SLOTS) {
            ret.add(slot);
        }
        return ret;
    }
}

