/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.ner.gui;

import com.github.darksoulq.abyssallib.server.resource.util.TextOffset;
import com.github.darksoulq.abyssallib.world.gui.Gui;
import com.github.darksoulq.abyssallib.world.gui.GuiElement;
import com.github.darksoulq.abyssallib.world.gui.GuiFlag;
import com.github.darksoulq.abyssallib.world.gui.GuiLayer;
import com.github.darksoulq.abyssallib.world.gui.GuiManager;
import com.github.darksoulq.abyssallib.world.gui.GuiView;
import com.github.darksoulq.abyssallib.world.gui.SlotPosition;
import com.github.darksoulq.abyssallib.world.gui.impl.GuiButton;
import com.github.darksoulq.abyssallib.world.gui.impl.GuiItem;
import com.github.darksoulq.abyssallib.world.gui.impl.ListedLayers;
import com.github.darksoulq.abyssallib.world.gui.impl.PaginatedElements;
import com.github.darksoulq.abyssallib.world.item.Item;
import com.github.darksoulq.ner.data.RecipeManager;
import com.github.darksoulq.ner.gui.GuiHistory;
import com.github.darksoulq.ner.gui.GuiInfo;
import com.github.darksoulq.ner.gui.MainMenu;
import com.github.darksoulq.ner.model.ParsedRecipeView;
import com.github.darksoulq.ner.model.RecipeViewLayer;
import com.github.darksoulq.ner.resources.UiItems;
import com.github.darksoulq.ner.util.TaskUtil;
import com.github.darksoulq.ner.util.TextUtil;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;

public class RecipeViewer {
    public static Gui create(ItemStack stack, int page, RecipeType type) {
        return RecipeViewer.create(stack, page, type, null);
    }

    public static Gui create(ItemStack stack, int page, RecipeType type, ItemStack provided) {
        ItemStack provider;
        List<Object> recipes;
        switch (type.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                List<Object> list = RecipeManager.getRecipesForResult(stack);
                break;
            }
            case 1: {
                List<Object> list = recipes = RecipeManager.getUsesForItem(stack);
            }
        }
        if (recipes.isEmpty()) {
            throw new IllegalStateException("No recipes found for " + String.valueOf(stack));
        }
        LinkedHashMap<ItemStack, List<RecipeViewLayer>> layers = new LinkedHashMap<ItemStack, List<RecipeViewLayer>>();
        GuiInfo.Recipe info = new GuiInfo.Recipe(page, type, null, stack);
        for (Object recipe : recipes) {
            ParsedRecipeView view = RecipeManager.parse(recipe);
            ItemStack provider2 = view.getProvider();
            layers.computeIfAbsent(provider2, k -> new ArrayList()).add(new RecipeViewLayer(view, info));
        }
        if (layers.isEmpty()) {
            throw new IllegalStateException("No layers parsed from recipes for " + String.valueOf(stack));
        }
        info.provider = provider = provided == null ? (ItemStack)layers.keySet().iterator().next() : provided;
        Supplier<@NotNull Component> itemName = () -> {
            if (stack.hasData((DataComponentType)DataComponentTypes.CUSTOM_NAME)) {
                return (Component)stack.getData(DataComponentTypes.CUSTOM_NAME);
            }
            if (stack.hasData((DataComponentType)DataComponentTypes.ITEM_NAME)) {
                return (Component)stack.getData(DataComponentTypes.ITEM_NAME);
            }
            if (stack.getItemMeta().hasDisplayName()) {
                return stack.displayName();
            }
            return Component.text((String)"");
        };
        ParsedRecipeView currentView = ((RecipeViewLayer)((List)layers.get((Object)provider)).getFirst()).view;
        Component title = TextUtil.parse("<white><offset><title></white><width><type> of <itemname>", new TagResolver[]{Placeholder.parsed((String)"title", (String)currentView.getTexture().toMiniMessageString()), Placeholder.parsed((String)"offset", (String)TextOffset.getOffsetMinimessage((int)currentView.getOffset())), Placeholder.parsed((String)"width", (String)TextOffset.getOffsetMinimessage((int)-168)), Placeholder.parsed((String)"type", (String)(type.equals((Object)RecipeType.USE) ? "Uses" : "Recipes")), Placeholder.component((String)"itemname", (ComponentLike)((ComponentLike)itemName.get()))});
        return RecipeViewer.create(title, layers, info);
    }

    public static Gui create(Component title, Map<ItemStack, List<RecipeViewLayer>> layers, GuiInfo.Recipe info) {
        ListedLayers listedLayers = new ListedLayers(new ArrayList(layers.get(info.provider)));
        ArrayList<GuiButton> providerButtons = new ArrayList<GuiButton>(layers.keySet().stream().map(k -> {
            ItemStack display = k.clone();
            if (k.equals((Object)info.provider)) {
                display.setData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            }
            return new GuiButton(display, (view, type) -> {
                ParsedRecipeView rview = ((RecipeViewLayer)((List)layers.get((Object)k)).getFirst()).view;
                Supplier<@NotNull Component> itemName = () -> {
                    if (info.viewed.hasData((DataComponentType)DataComponentTypes.CUSTOM_NAME)) {
                        return (Component)info.viewed.getData(DataComponentTypes.CUSTOM_NAME);
                    }
                    if (info.viewed.hasData((DataComponentType)DataComponentTypes.ITEM_NAME)) {
                        return (Component)info.viewed.getData(DataComponentTypes.ITEM_NAME);
                    }
                    if (info.viewed.getItemMeta().hasDisplayName()) {
                        return info.viewed.displayName();
                    }
                    return Component.text((String)"");
                };
                Component newTitle = TextUtil.parse("<white><offset><title></white><width><type> of <itemname>", new TagResolver[]{Placeholder.parsed((String)"title", (String)rview.getTexture().toMiniMessageString()), Placeholder.parsed((String)"offset", (String)TextOffset.getOffsetMinimessage((int)rview.getOffset())), Placeholder.parsed((String)"width", (String)TextOffset.getOffsetMinimessage((int)-168)), Placeholder.parsed((String)"type", (String)(info.type.equals((Object)RecipeType.USE) ? "Uses" : "Recipes")), Placeholder.component((String)"itemname", (ComponentLike)((ComponentLike)itemName.get()))});
                GuiManager.openViews.remove(view.getInventoryView());
                MainMenu.loadBackup(view);
                Gui gui = RecipeViewer.create(newTitle, layers, new GuiInfo.Recipe(info.page, info.type, (ItemStack)k, info.viewed));
                GuiManager.open((HumanEntity)view.getInventoryView().getPlayer(), (Gui)gui);
            });
        }).toList());
        PaginatedElements paginatedProviders = new PaginatedElements(providerButtons, new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35}, GuiView.Segment.BOTTOM);
        ItemStack pageDisplay = MainMenu.createPageIndicator();
        RecipeViewer.updatePageItem(listedLayers, pageDisplay, info);
        return new Gui.Builder((MenuType)MenuType.GENERIC_9X6, title).addFlags(new GuiFlag[]{GuiFlag.DISABLE_ADVANCEMENTS, GuiFlag.DISABLE_ITEM_PICKUP}).addLayer((GuiLayer)listedLayers).addLayer((GuiLayer)paginatedProviders).set(SlotPosition.bottom((int)0), (GuiElement)GuiButton.of((ItemStack)((Item)UiItems.PREV.get()).getStack(), (view, type) -> paginatedProviders.prev(view))).set(SlotPosition.bottom((int)8), (GuiElement)GuiButton.of((ItemStack)((Item)UiItems.NEXT.get()).getStack(), (view, type) -> paginatedProviders.next(view))).set(SlotPosition.top((int)48), (GuiElement)GuiButton.of((ItemStack)((Item)UiItems.PREV.get()).getStack(), (view, type) -> {
            if (listedLayers.getSize() != 1) {
                listedLayers.prev(view);
            }
            RecipeViewer.updatePageItem(listedLayers, pageDisplay, info);
        })).set(SlotPosition.top((int)49), (GuiElement)GuiItem.of((ItemStack)pageDisplay)).set(SlotPosition.top((int)53), (GuiElement)GuiButton.of((ItemStack)((Item)UiItems.CLOSE.get()).getStack(), (view, type) -> {
            GuiInfo prev;
            Player player = (Player)view.getInventoryView().getPlayer();
            GuiInfo selector0$temp = prev = GuiHistory.pop(player.getUniqueId());
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GuiInfo.Main.class, GuiInfo.Search.class, GuiInfo.Recipe.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    GuiInfo.Main m = (GuiInfo.Main)selector0$temp;
                    GuiManager.openViews.remove(view.getInventoryView());
                    MainMenu.loadBackup(view);
                    GuiManager.open((HumanEntity)player, (Gui)MainMenu.create(m));
                    break;
                }
                case 1: {
                    GuiInfo.Search s = (GuiInfo.Search)selector0$temp;
                    GuiManager.close((HumanEntity)player);
                    break;
                }
                case 2: {
                    GuiInfo.Recipe r = (GuiInfo.Recipe)selector0$temp;
                    GuiManager.openViews.remove(view.getInventoryView());
                    MainMenu.loadBackup(view);
                    GuiManager.open((HumanEntity)player, (Gui)RecipeViewer.create(r.viewed, r.page, r.type, r.provider));
                    break;
                }
            }
        })).set(SlotPosition.top((int)50), (GuiElement)GuiButton.of((ItemStack)((Item)UiItems.NEXT.get()).getStack(), (view, type) -> {
            if (listedLayers.getSize() != 1) {
                listedLayers.next(view);
            }
            RecipeViewer.updatePageItem(listedLayers, pageDisplay, info);
        })).onOpen(view -> {
            MainMenu.setupBackup(view);
            TaskUtil.delayedTask(1, () -> {
                while (listedLayers.getSize() < info.page) {
                    listedLayers.next(view);
                }
                RecipeViewer.updatePageItem(listedLayers, pageDisplay, info);
            });
        }).onClose(MainMenu::loadBackup).build();
    }

    private static void updatePageItem(ListedLayers layer, ItemStack stack, GuiInfo.Recipe info) {
        String pageLore = String.format("<green>%d <gray>of</gray> %d</green>", layer.getIndex() + 1, layer.getSize());
        stack.setData(DataComponentTypes.LORE, (Object)((ItemLore)ItemLore.lore().lines(List.of(TextUtil.parse(pageLore))).build()));
        info.page = layer.getIndex();
    }

    public static enum RecipeType {
        RECIPE,
        USE;

    }
}

