/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.ner.gui;

import com.github.darksoulq.abyssallib.server.resource.util.TextOffset;
import com.github.darksoulq.abyssallib.world.gui.Gui;
import com.github.darksoulq.abyssallib.world.gui.GuiElement;
import com.github.darksoulq.abyssallib.world.gui.GuiFlag;
import com.github.darksoulq.abyssallib.world.gui.GuiLayer;
import com.github.darksoulq.abyssallib.world.gui.GuiView;
import com.github.darksoulq.abyssallib.world.gui.SlotPosition;
import com.github.darksoulq.abyssallib.world.gui.impl.GuiButton;
import com.github.darksoulq.abyssallib.world.gui.impl.GuiItem;
import com.github.darksoulq.abyssallib.world.gui.impl.PaginatedElements;
import com.github.darksoulq.abyssallib.world.item.Item;
import com.github.darksoulq.abyssallib.world.item.Items;
import com.github.darksoulq.ner.data.NamespacedFilterManager;
import com.github.darksoulq.ner.gui.GuiInfo;
import com.github.darksoulq.ner.gui.MainMenu;
import com.github.darksoulq.ner.resources.Pack;
import com.github.darksoulq.ner.resources.UiItems;
import com.github.darksoulq.ner.util.TextUtil;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.view.AnvilView;

public class SearchMenu {
    private static final Map<String, BiFunction<String, ItemStack, Boolean>> FILTERS = new HashMap<String, BiFunction<String, ItemStack, Boolean>>();
    private static final Component MENU_TITLE = TextUtil.parse("<white><offset><title></white><width>Search", new TagResolver[]{Placeholder.parsed((String)"title", (String)Pack.SEARCH_MENU.toMiniMessageString()), Placeholder.parsed((String)"offset", (String)TextOffset.getOffsetMinimessage((int)-60)), Placeholder.parsed((String)"width", (String)TextOffset.getOffsetMinimessage((int)-170))});
    private static final int[] DISPLAY_SLOTS = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};

    public static void addFilter(String key, BiFunction<String, ItemStack, Boolean> filter) {
        FILTERS.put(key.toLowerCase(Locale.ROOT), filter);
    }

    public static Gui create() {
        return SearchMenu.create(new GuiInfo.Search("", 0));
    }

    public static Gui create(GuiInfo.Search info) {
        ArrayList<GuiElement> guiElements = new ArrayList<GuiElement>(MainMenu.ITEMS.size());
        MainMenu.populateElements(guiElements, info);
        PaginatedElements paginatedElements = new PaginatedElements(guiElements, DISPLAY_SLOTS, GuiView.Segment.BOTTOM);
        Predicate<GuiElement> initialFilter = SearchMenu.buildFilterPredicate(info.text, null);
        paginatedElements.setFilter(initialFilter);
        ItemStack invisibleFiller = ((Item)Items.INVISIBLE_ITEM.get()).getStack();
        invisibleFiller.setData(DataComponentTypes.ITEM_NAME, (Object)Component.text((String)""));
        invisibleFiller.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)TooltipDisplay.tooltipDisplay().hideTooltip(true).build()));
        ItemStack pageIndicator = MainMenu.createPageIndicator();
        MainMenu.updatePageIndicator(paginatedElements, pageIndicator, info);
        return new Gui.Builder((MenuType)MenuType.ANVIL, MENU_TITLE).addFlags(new GuiFlag[]{GuiFlag.DISABLE_ADVANCEMENTS, GuiFlag.DISABLE_ITEM_PICKUP}).addLayer((GuiLayer)paginatedElements).set(SlotPosition.bottom((int)0), (GuiElement)new GuiButton(((Item)UiItems.PREV.get()).getStack(), (view, click) -> {
            paginatedElements.prev(view);
            MainMenu.updatePageIndicator(paginatedElements, pageIndicator, info);
        })).set(SlotPosition.bottom((int)4), (GuiElement)new GuiItem(pageIndicator)).set(SlotPosition.bottom((int)8), (GuiElement)new GuiButton(((Item)UiItems.NEXT.get()).getStack(), (view, click) -> {
            paginatedElements.next(view);
            MainMenu.updatePageIndicator(paginatedElements, pageIndicator, info);
        })).set(SlotPosition.top((int)0), (GuiElement)new GuiItem(invisibleFiller)).onOpen(MainMenu::setupBackup).onTick(view -> {
            InventoryView patt0$temp = view.getInventoryView();
            if (!(patt0$temp instanceof AnvilView)) {
                return;
            }
            AnvilView anvilView = (AnvilView)patt0$temp;
            String currentInput = Optional.ofNullable(anvilView.getRenameText()).orElse("");
            boolean isOld = info.text.equals(currentInput);
            if (isOld) {
                return;
            }
            info.text = currentInput;
            Predicate<GuiElement> filterPredicate = SearchMenu.buildFilterPredicate(info.text, view);
            paginatedElements.setFilter(filterPredicate);
        }).onClose(MainMenu::loadBackup).build();
    }

    private static Predicate<GuiElement> buildFilterPredicate(String input, GuiView view) {
        int colonIndex = input.indexOf(58);
        if (colonIndex > 0) {
            String prefix = input.substring(0, colonIndex).toLowerCase(Locale.ROOT);
            String searchTerm = input.substring(colonIndex + 1);
            BiFunction<String, ItemStack, Boolean> filterFunc = FILTERS.get(prefix);
            if (filterFunc != null) {
                return element -> {
                    ItemStack item = element.render(view, 0);
                    boolean result = (Boolean)filterFunc.apply(searchTerm, item);
                    return result;
                };
            }
            return SearchMenu.fallbackFilter(input);
        }
        return SearchMenu.fallbackFilter(input.toLowerCase(Locale.ROOT));
    }

    private static Predicate<GuiElement> fallbackFilter(String query) {
        String loweredQuery = query.toLowerCase(Locale.ROOT);
        PlainTextComponentSerializer plainSerializer = PlainTextComponentSerializer.plainText();
        return element -> {
            ItemStack item = element.render(null, 0);
            if (item == null) {
                return false;
            }
            Component name = (Component)item.getData(DataComponentTypes.CUSTOM_NAME);
            if (name == null) {
                name = (Component)item.getData(DataComponentTypes.ITEM_NAME);
            }
            if (name == null) {
                return false;
            }
            String plainName = plainSerializer.serialize(name).toLowerCase(Locale.ROOT);
            boolean matches = plainName.contains(loweredQuery);
            return matches;
        };
    }

    static {
        SearchMenu.addFilter("@", (query, stack) -> {
            List<String> namespaces = NamespacedFilterManager.getMatchingNamespaces(query);
            return NamespacedFilterManager.getItems(namespaces).contains(stack);
        });
    }
}

