/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.ner.model;

import com.github.darksoulq.abyssallib.world.gui.Gui;
import com.github.darksoulq.abyssallib.world.gui.GuiElement;
import com.github.darksoulq.abyssallib.world.gui.GuiLayer;
import com.github.darksoulq.abyssallib.world.gui.GuiView;
import com.github.darksoulq.abyssallib.world.gui.SlotPosition;
import com.github.darksoulq.abyssallib.world.gui.impl.GuiButton;
import com.github.darksoulq.abyssallib.world.gui.impl.PaginatedElements;
import com.github.darksoulq.ner.data.Input;
import com.github.darksoulq.ner.gui.GuiInfo;
import com.github.darksoulq.ner.gui.MainMenu;
import com.github.darksoulq.ner.gui.RecipeViewer;
import com.github.darksoulq.ner.layout.PaginatedSection;
import com.github.darksoulq.ner.model.GuiAnimatedButton;
import com.github.darksoulq.ner.model.ParsedRecipeView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class RecipeViewLayer
implements GuiLayer {
    public final ParsedRecipeView view;
    private final Map<SlotPosition, GuiElement> items = new HashMap<SlotPosition, GuiElement>();
    private final List<PaginatedElements> pages = new ArrayList<PaginatedElements>();
    private int lastTime = 0;

    public RecipeViewLayer(ParsedRecipeView view, GuiInfo info) {
        this.view = view;
        for (Map.Entry<Integer, List<ItemStack>> entry : view.getSlotMap().entrySet()) {
            int slot = entry.getKey();
            List<ItemStack> stackList = entry.getValue();
            SlotPosition position = SlotPosition.top((int)slot);
            GuiElement animated = this.createButton(stackList, info, true);
            this.items.put(position, animated);
        }
        if (view.getSections() == null) {
            return;
        }
        for (PaginatedSection section : view.getSections()) {
            ArrayList elements = new ArrayList();
            section.getStacks().forEach(v -> elements.add(this.createButton(List.of(v), info, false)));
            PaginatedElements page = new PaginatedElements(elements, section.getSlots(), GuiView.Segment.TOP);
            this.pages.add(page);
            this.items.put(SlotPosition.top((int)section.getNextButton().slot()), (GuiElement)GuiButton.of((ItemStack)section.getNextButton().display(), (gView, click) -> page.next(gView)));
            this.items.put(SlotPosition.top((int)section.getPrevButton().slot()), (GuiElement)GuiButton.of((ItemStack)section.getPrevButton().display(), (gView, click) -> page.prev(gView)));
        }
    }

    public void cleanup(GuiView view) {
        this.items.keySet().forEach(sp -> {
            view.getGui().getElements().remove(sp);
            if (sp.segment() == GuiView.Segment.TOP) {
                view.getTop().setItem(sp.index(), null);
            } else {
                view.getBottom().setItem(sp.index(), null);
            }
        });
        for (PaginatedElements elements : this.pages) {
            elements.cleanup(view);
            elements.resetPage();
        }
    }

    public void renderTo(GuiView view) {
        Gui gui = view.getGui();
        this.cleanup(view);
        for (PaginatedElements paginatedElements : this.pages) {
            paginatedElements.renderTo(view);
        }
        for (Map.Entry entry : this.items.entrySet()) {
            gui.getElements().put((SlotPosition)entry.getKey(), (GuiElement)entry.getValue());
        }
    }

    private GuiElement createButton(List<ItemStack> stacks, GuiInfo info, boolean animated) {
        if (animated) {
            return new GuiAnimatedButton((gView, currentTick) -> {
                if (this.lastTime == 0) {
                    this.lastTime = currentTick;
                }
                int elapsed = currentTick - this.lastTime;
                if (stacks.isEmpty()) {
                    return null;
                }
                int index = elapsed / 20 % stacks.size();
                return (ItemStack)stacks.get(index);
            }, (gv, type, cursor, current) -> {
                if (!type.isShiftClick() && type.isLeftClick()) {
                    MainMenu.openRecipe(gv, current, info, RecipeViewer.RecipeType.RECIPE);
                } else if (type.isRightClick()) {
                    MainMenu.openRecipe(gv, current, info, RecipeViewer.RecipeType.USE);
                } else if (Input.isShiftLeftClick(type)) {
                    MainMenu.addFavourite(gv.getInventoryView().getPlayer().getUniqueId(), current);
                }
            });
        }
        return new GuiButton(stacks.getFirst(), (gv, type) -> {
            if (!type.isShiftClick() && type.isLeftClick()) {
                MainMenu.openRecipe(gv, (ItemStack)stacks.getFirst(), info, RecipeViewer.RecipeType.RECIPE);
            } else if (type.isRightClick()) {
                MainMenu.openRecipe(gv, (ItemStack)stacks.getFirst(), info, RecipeViewer.RecipeType.USE);
            } else if (Input.isShiftLeftClick(type)) {
                MainMenu.addFavourite(gv.getInventoryView().getPlayer().getUniqueId(), (ItemStack)stacks.getFirst());
            }
        });
    }
}

