/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.legacyauth.skin;

import com.moyettes.legacyauth.skin.BetaFixPlayer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class BetaFix {
    private static final HashMap<String, BetaFixPlayer> players = new HashMap();
    private static boolean sslInitialized = false;

    private static void initializeSSL() {
        if (sslInitialized) {
            return;
        }
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
            sslInitialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getSkinURL(String username) {
        if (username == null || username.trim().isEmpty()) {
            return "https://assets.mojang.com/SkinTemplates/steve.png";
        }
        BetaFix.initializeSSL();
        BetaFixPlayer player = BetaFix.getPlayer(username);
        if (player == null) {
            return "https://assets.mojang.com/SkinTemplates/steve.png";
        }
        return player.skinURL;
    }

    public static String getCapeURL(String username) {
        if (username == null || username.trim().isEmpty()) {
            return null;
        }
        BetaFix.initializeSSL();
        BetaFixPlayer player = BetaFix.getPlayer(username);
        if (player == null) {
            return null;
        }
        return player.capeURL;
    }

    private static BetaFixPlayer getPlayer(String username) {
        String valueDecoded;
        if (username == null || username.trim().isEmpty()) {
            return null;
        }
        if (players.containsKey(username)) {
            return players.get(username);
        }
        String uuidUrl = "https://api.mojang.com/users/profiles/minecraft/" + username;
        String json = BetaFix.httpGetClean(uuidUrl);
        if (json.isEmpty()) {
            return null;
        }
        String uuid = BetaFix.getJsonField(json, "id");
        if (uuid == null || uuid.isEmpty()) {
            return null;
        }
        String profileUrl = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid;
        json = BetaFix.httpGetClean(profileUrl);
        if (json.isEmpty()) {
            return null;
        }
        String valueEncoded = BetaFix.getJsonField(json, "value");
        if (valueEncoded == null || valueEncoded.isEmpty()) {
            return null;
        }
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(valueEncoded);
            valueDecoded = BetaFix.clean(new String(decodedBytes, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String skinURL = BetaFix.getJsonField(valueDecoded, "SKIN\":{\"url");
        if (skinURL == null || skinURL.isEmpty()) {
            return null;
        }
        String capeURL = BetaFix.getJsonField(valueDecoded, "CAPE\":{\"url");
        skinURL = skinURL.replace("http://", "https://");
        if (capeURL != null) {
            capeURL = capeURL.replace("http://", "https://");
        }
        BetaFixPlayer player = new BetaFixPlayer(username, uuid, skinURL, capeURL);
        players.put(username, player);
        return player;
    }

    private static String getJsonField(String json, String field) {
        int len = field.length() + 4;
        int i = json.indexOf("\"" + field + "\":\"");
        if (i == -1) {
            return null;
        }
        int j = json.indexOf("\"", i + len);
        if (j == -1) {
            return null;
        }
        String result = json.substring(i + len, j);
        return result;
    }

    private static String clean(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\n", "").replaceAll(" ", "");
    }

    private static String httpGet(String url) throws IOException {
        int data;
        URLConnection connection = new URL(url).openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36");
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        InputStream stream = connection.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder stringBuilder = new StringBuilder();
        while ((data = reader.read()) != -1) {
            stringBuilder.append((char)data);
        }
        return stringBuilder.toString();
    }

    private static String httpGetClean(String url) {
        try {
            String response = BetaFix.httpGet(url);
            return BetaFix.clean(response);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

