/*
 * Decompiled with CFR 0.152.
 */
package com.moyettes.legacyauth;

import com.moyettes.legacyauth.mixin.accessors.ServerLoginAccessors;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.unmapped.C_8983523;
import net.minecraft.unmapped.C_9232485;

public class ModernAuth
extends Thread {
    private final C_8983523 handler;
    private final C_9232485 loginPacket;

    public ModernAuth(C_8983523 handler, C_9232485 loginPacket) {
        this.handler = handler;
        this.loginPacket = loginPacket;
    }

    @Override
    public void run() {
        block9: {
            try {
                String username = this.loginPacket.f_3753797;
                String clientIP = ModernAuth.getClientIP(this.handler);
                String urlString = "https://sessionserver.mojang.com/session/minecraft/hasJoined?username=" + URLEncoder.encode(username, "UTF-8") + "&serverId=" + URLEncoder.encode(((ServerLoginAccessors)this.handler).getKey(), "UTF-8") + "&ip=" + URLEncoder.encode(clientIP, "UTF-8");
                HttpURLConnection connection = (HttpURLConnection)new URL(urlString).openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.setRequestProperty("User-Agent", "Minecraft Server");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    String jsonResponse = response.toString();
                    if (jsonResponse.contains("\"name\"") && jsonResponse.toLowerCase().contains("\"" + username.toLowerCase() + "\"")) {
                        MinecraftServer.f_6379402.info("Authentication successful for: " + username);
                        ((ServerLoginAccessors)this.handler).setPacket(this.loginPacket);
                    } else {
                        MinecraftServer.f_6379402.info("Authentication failed - invalid JSON response");
                        this.handler.m_4650213("Failed to verify username!");
                    }
                    break block9;
                }
                try {
                    String line;
                    BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                    StringBuilder errorResponse = new StringBuilder();
                    while ((line = errorReader.readLine()) != null) {
                        errorResponse.append(line);
                    }
                    errorReader.close();
                    MinecraftServer.f_6379402.info("Error response: " + errorResponse.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.handler.m_4650213("Failed to verify username!");
            }
            catch (Exception e) {
                MinecraftServer.f_6379402.info("Authentication error: " + e.getMessage());
                e.printStackTrace();
                this.handler.m_4650213("Authentication error: " + e.getMessage());
            }
        }
    }

    private static String getClientIP(C_8983523 netLoginHandler) {
        try {
            String remoteAddress = netLoginHandler.f_6623633.m_3053098().toString();
            if (remoteAddress.startsWith("/")) {
                remoteAddress = remoteAddress.substring(1);
            }
            if (remoteAddress.contains(":")) {
                remoteAddress = remoteAddress.substring(0, remoteAddress.indexOf(":"));
            }
            return remoteAddress;
        }
        catch (Exception e) {
            MinecraftServer.f_6379402.info("Failed to get client IP: " + e.getMessage());
            return "127.0.0.1";
        }
    }
}

