/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra;

import com.hidoni.customizableelytra.platform.Services;
import com.hidoni.customizableelytra.registry.ModDataComponents;
import com.hidoni.customizableelytra.registry.ModItems;
import com.hidoni.customizableelytra.registry.ModRegistries;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;

public class CustomizableElytra {
    public static void init() {
        ModRegistries.register();
        Services.EVENT.registerCauldronBehaviorEventHandler(() -> {
            CauldronInteraction clearElytraCustomization = (state, world, pos, player, hand, stack) -> {
                if (!stack.has((DataComponentType)ModDataComponents.ELYTRA_CUSTOMIZATION.get())) {
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                if (!world.isClientSide()) {
                    stack.remove((DataComponentType)ModDataComponents.ELYTRA_CUSTOMIZATION.get());
                    player.awardStat(Stats.CLEAN_ARMOR);
                    LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)world, (BlockPos)pos);
                }
                return InteractionResult.SUCCESS;
            };
            CauldronInteraction.WATER.map().put(Items.ELYTRA, clearElytraCustomization);
            CauldronInteraction clearElytraWingCustomization = (state, world, pos, player, hand, stack) -> {
                DataComponentType[] elytraWingComponentTypes = new DataComponentType[]{DataComponents.DYED_COLOR, DataComponents.BASE_COLOR, DataComponents.BANNER_PATTERNS, DataComponents.TRIM, (DataComponentType)ModDataComponents.GLOWING.get(), (DataComponentType)ModDataComponents.CAPE_HIDDEN.get()};
                if (Arrays.stream(elytraWingComponentTypes).noneMatch(arg_0 -> ((ItemStack)stack).has(arg_0))) {
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                if (!world.isClientSide()) {
                    Arrays.stream(elytraWingComponentTypes).forEach(arg_0 -> ((ItemStack)stack).remove(arg_0));
                    player.awardStat(Stats.CLEAN_ARMOR);
                    LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)world, (BlockPos)pos);
                }
                return InteractionResult.SUCCESS;
            };
            CauldronInteraction.WATER.map().put((Item)ModItems.ELYTRA_WING.get(), clearElytraWingCustomization);
        });
    }
}

