/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.client;

import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.item.components.ElytraCustomization;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CustomizableElytraTrimMaterialProperty(boolean rightWing) implements SelectItemModelProperty<ResourceKey<TrimMaterial>>
{
    public static final Codec<ResourceKey<TrimMaterial>> VALUE_CODEC = ResourceKey.codec((ResourceKey)Registries.TRIM_MATERIAL);
    public static final SelectItemModelProperty.Type<CustomizableElytraTrimMaterialProperty, ResourceKey<TrimMaterial>> TYPE = SelectItemModelProperty.Type.create((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("right_wing").forGetter(CustomizableElytraTrimMaterialProperty::rightWing)).apply((Applicative)instance, CustomizableElytraTrimMaterialProperty::new)), VALUE_CODEC);

    @Nullable
    public ResourceKey<TrimMaterial> get(@NotNull ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i, @NotNull ItemDisplayContext itemDisplayContext) {
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(itemStack);
        ItemStack wingItemStack = this.rightWing ? customization.rightWing() : customization.leftWing();
        Optional<ArmorTrim> armorTrim = ((CustomizableElytraItem)wingItemStack.getItem()).getArmorTrim(wingItemStack);
        return armorTrim.flatMap(trim -> trim.material().unwrapKey()).orElse(null);
    }

    @NotNull
    public Codec<ResourceKey<TrimMaterial>> valueCodec() {
        return VALUE_CODEC;
    }

    @NotNull
    public SelectItemModelProperty.Type<? extends SelectItemModelProperty<ResourceKey<TrimMaterial>>, ResourceKey<TrimMaterial>> type() {
        return TYPE;
    }
}

