/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.recipe;

import com.hidoni.customizableelytra.item.ElytraWingItem;
import com.hidoni.customizableelytra.item.components.ElytraCustomization;
import com.hidoni.customizableelytra.registry.ModDataComponents;
import com.hidoni.customizableelytra.registry.ModRecipes;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CombineWingsRecipe
extends CustomRecipe {
    public CombineWingsRecipe(CraftingBookCategory category) {
        super(category);
    }

    private static void copyWingAttributesToElytra(ItemStack leftWing, ItemStack rightWing, ItemStack elytra) {
        elytra.setDamageValue((leftWing.getDamageValue() + rightWing.getDamageValue()) / 2);
        int repairCost = ((Integer)leftWing.getOrDefault(DataComponents.REPAIR_COST, (Object)0) + (Integer)rightWing.getOrDefault(DataComponents.REPAIR_COST, (Object)0)) / 2;
        if (repairCost != 0) {
            elytra.set(DataComponents.REPAIR_COST, (Object)repairCost);
        }
        if (leftWing.has(DataComponents.CUSTOM_NAME)) {
            elytra.set(DataComponents.CUSTOM_NAME, (Object)((Component)leftWing.get(DataComponents.CUSTOM_NAME)));
        } else if (rightWing.has(DataComponents.CUSTOM_NAME)) {
            elytra.set(DataComponents.CUSTOM_NAME, (Object)((Component)rightWing.get(DataComponents.CUSTOM_NAME)));
        }
        if (!EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)leftWing).isEmpty()) {
            EnchantmentHelper.setEnchantments((ItemStack)elytra, (ItemEnchantments)EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)leftWing));
        } else if (!EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)rightWing).isEmpty()) {
            EnchantmentHelper.setEnchantments((ItemStack)elytra, (ItemEnchantments)EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)rightWing));
        }
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level level) {
        ItemStack leftWing = ItemStack.EMPTY;
        ItemStack rightWing = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (!(stack.getItem() instanceof ElytraWingItem)) {
                return false;
            }
            if (!leftWing.isEmpty()) {
                if (!rightWing.isEmpty()) {
                    return false;
                }
                rightWing = stack;
                continue;
            }
            leftWing = stack;
        }
        return !leftWing.isEmpty() && !rightWing.isEmpty();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ItemStack leftWing = ItemStack.EMPTY;
        ItemStack rightWing = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (!(stack.getItem() instanceof ElytraWingItem)) {
                return ItemStack.EMPTY;
            }
            if (!leftWing.isEmpty()) {
                if (!rightWing.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                rightWing = stack;
                continue;
            }
            leftWing = stack;
        }
        ElytraCustomization customization = new ElytraCustomization(leftWing.copyWithCount(1), rightWing.copyWithCount(1));
        ItemStack elytra = new ItemStack((ItemLike)Items.ELYTRA);
        CombineWingsRecipe.copyWingAttributesToElytra(leftWing, rightWing, elytra);
        elytra.set((DataComponentType)ModDataComponents.ELYTRA_CUSTOMIZATION.get(), (Object)customization);
        return elytra;
    }

    @NotNull
    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipes.COMBINE_WINGS_RECIPE.get();
    }
}

