/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.recipe;

import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.item.components.ElytraCustomization;
import com.hidoni.customizableelytra.registry.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SplitToWingsRecipe
extends CustomRecipe {
    public SplitToWingsRecipe(CraftingBookCategory category) {
        super(category);
    }

    private ItemStack getElytraItem(@NotNull CraftingInput inv) {
        ItemStack elytraItem = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item.isEmpty()) continue;
            if (!ElytraUtils.isElytra(item)) {
                return ItemStack.EMPTY;
            }
            if (!elytraItem.isEmpty()) {
                return ItemStack.EMPTY;
            }
            elytraItem = item;
        }
        return elytraItem;
    }

    private static void copyElytraAttributesToWing(ItemStack wing, ItemStack elytra) {
        wing.setDamageValue(elytra.getDamageValue());
        wing.set(DataComponents.REPAIR_COST, (Object)((Integer)elytra.get(DataComponents.REPAIR_COST)));
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level level) {
        return !this.getElytraItem(inv).isEmpty();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider provider) {
        ItemStack elytraItem = this.getElytraItem(inv);
        if (elytraItem.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(elytraItem).copy();
        ItemStack leftWing = customization.leftWing();
        SplitToWingsRecipe.copyElytraAttributesToWing(leftWing, elytraItem);
        EnchantmentHelper.setEnchantments((ItemStack)leftWing, (ItemEnchantments)EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)elytraItem));
        if (elytraItem.has(DataComponents.CUSTOM_NAME)) {
            leftWing.set(DataComponents.CUSTOM_NAME, (Object)((Component)elytraItem.get(DataComponents.CUSTOM_NAME)));
        }
        return leftWing;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInput inv) {
        NonNullList remainingItems = super.getRemainingItems(inv);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack elytraItem = inv.getItem(i);
            if (!ElytraUtils.isElytra(elytraItem) || remainingItems.get(i) != ItemStack.EMPTY) continue;
            ElytraCustomization customization = CustomizationUtils.getElytraCustomization(elytraItem).copy();
            ItemStack rightWing = customization.rightWing();
            SplitToWingsRecipe.copyElytraAttributesToWing(rightWing, elytraItem);
            remainingItems.set(i, (Object)rightWing);
        }
        return remainingItems;
    }

    @NotNull
    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipes.SPLIT_TO_WINGS_RECIPE.get();
    }
}

