/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.client;

import com.hidoni.customizableelytra.Constants;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.item.components.ElytraCustomization;
import com.hidoni.customizableelytra.mixin.ElytraModelAccessor;
import com.hidoni.customizableelytra.mixin.TextureAtlasAccessor;
import com.hidoni.customizableelytra.render.TextureUtils;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_10034;
import net.minecraft.class_10186;
import net.minecraft.class_10191;
import net.minecraft.class_10394;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10725;
import net.minecraft.class_11659;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_630;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import net.minecraft.class_9307;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizableElytraLayerHelper {
    private static final class_1059 bannerPatternAtlas = CustomizableElytraLayerHelper.getAtlas(Constants.ELYTRA_BANNER_ATLAS);
    private static final class_1059 armorTrimAtlas = CustomizableElytraLayerHelper.getAtlas(class_10725.field_56379);
    private static final class_2960 TEXTURE_GRAYSCALE_ELYTRA = class_2960.method_60655((String)"customizableelytra", (String)"textures/entity/elytra.png");
    private static final Function<class_8053, class_1058> elytraTrimLookup = class_156.method_34866(trim -> armorTrimAtlas.method_4608(trim.method_67225("trims/models/elytra", class_10191.field_54142)));
    private static final class_2960 VANILLA_WINGS_LOCATION = class_2960.method_60656((String)"textures/entity/equipment/wings/elytra.png");

    public static <S extends class_10034> void render(class_10186.class_10190 layerType, class_5321<class_10394> equipmentAsset, class_3879<? super S> elytraModel, S renderState, class_1799 elytraStack, class_4587 poseStack, class_11659 nodeCollector, int packedLight, class_2960 playerTexture, int outlineColor, int key) {
        elytraModel.method_2819(renderState);
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(elytraStack);
        CustomizableElytraLayerHelper.renderWing(layerType, equipmentAsset, ((ElytraModelAccessor)elytraModel).getLeftWing(), renderState, customization.leftWing(), poseStack, nodeCollector, packedLight, elytraStack.method_7958(), ((CustomizableElytraItem)customization.leftWing().method_7909()).isCapeHidden(customization.leftWing()) ? null : playerTexture, outlineColor, key);
        CustomizableElytraLayerHelper.renderWing(layerType, equipmentAsset, ((ElytraModelAccessor)elytraModel).getRightWing(), renderState, customization.rightWing(), poseStack, nodeCollector, packedLight, elytraStack.method_7958(), ((CustomizableElytraItem)customization.rightWing().method_7909()).isCapeHidden(customization.rightWing()) ? null : playerTexture, outlineColor, key);
    }

    private static <S extends class_10034> void renderWing(class_10186.class_10190 layerType, class_5321<class_10394> equipmentAsset, class_630 wingModel, S renderState, class_1799 wingStack, class_4587 poseStack, class_11659 nodeCollector, int packedLight, boolean hasFoil, @Nullable class_2960 playerTexture, int outlineColor, int key) {
        CustomizableElytraItem wingItem = (CustomizableElytraItem)wingStack.method_7909();
        if (wingItem.isGlowing(wingStack)) {
            packedLight |= 0xFF;
        }
        key = wingItem.isDyed(wingStack) ? CustomizableElytraLayerHelper.renderDyedWing(wingModel, wingStack, poseStack, nodeCollector, packedLight, wingItem, CustomizableElytraLayerHelper.getGrayscaleTexture(playerTexture), hasFoil, outlineColor, key) : (wingItem.hasBanner(wingStack) ? CustomizableElytraLayerHelper.renderWingBannerPatterns(wingModel, wingStack, poseStack, nodeCollector, packedLight, wingItem, CustomizableElytraLayerHelper.getGrayscaleTexture(playerTexture), hasFoil, outlineColor, key) : CustomizableElytraLayerHelper.renderBasicWing(wingModel, poseStack, nodeCollector, packedLight, playerTexture, hasFoil, outlineColor, key));
        if (wingItem.hasArmorTrim(wingStack)) {
            CustomizableElytraLayerHelper.renderWingTrim(wingModel, wingStack, poseStack, nodeCollector, packedLight, wingItem, hasFoil, outlineColor, key);
        }
    }

    private static int renderDyedWing(class_630 wingModel, class_1799 wingStack, class_4587 poseStack, class_11659 nodeCollector, int packedLight, CustomizableElytraItem wingItem, class_2960 elytraTexture, boolean hasFoil, int outlineColor, int key) {
        nodeCollector.method_73529(key++).method_73494(wingModel, poseStack, class_1921.method_25448((class_2960)elytraTexture), packedLight, class_4608.field_21444, null, false, hasFoil, wingItem.getColor(wingStack), null, outlineColor);
        if (hasFoil) {
            nodeCollector.method_73529(key++).method_73494(wingModel, poseStack, class_1921.method_27949(), packedLight, class_4608.field_21444, null, false, true, wingItem.getColor(wingStack), null, outlineColor);
        }
        return key;
    }

    private static int renderWingBannerPatterns(class_630 wingModel, class_1799 wingStack, class_4587 poseStack, class_11659 nodeCollector, int packedLight, CustomizableElytraItem wingItem, class_2960 elytraTexture, boolean hasFoil, int outlineColor, int key) {
        class_9307 bannerPatterns = wingItem.getBannerPatterns(wingStack);
        if (hasFoil) {
            nodeCollector.method_73529(key++).method_73494(wingModel, poseStack, class_1921.method_27949(), packedLight, class_4608.field_21444, null, false, true, -1, null, outlineColor);
        }
        nodeCollector.method_73529(key++).method_73494(wingModel, poseStack, class_1921.method_65052((class_2960)elytraTexture), packedLight, class_4608.field_21444, null, false, hasFoil, wingItem.getBaseColor(wingStack).method_7787(), null, outlineColor);
        for (int i = 0; i < bannerPatterns.comp_2428().size(); ++i) {
            class_9307.class_9308 bannerAndColor = (class_9307.class_9308)bannerPatterns.comp_2428().get(i);
            Optional resourceKey = bannerAndColor.comp_2429().method_40230();
            if (!resourceKey.isPresent()) continue;
            class_4730 bannerMaterial = new class_4730(Constants.ELYTRA_BANNER_SHEET, CustomizableElytraLayerHelper.getTextureLocation((class_5321<class_2582>)((class_5321)resourceKey.get())));
            Map<class_2960, class_1058> texturesByName = ((TextureAtlasAccessor)bannerPatternAtlas).getTexturesByName();
            if (texturesByName.get(bannerMaterial.method_24147()) == null) continue;
            nodeCollector.method_73529(key++).method_73494(wingModel, poseStack, bannerMaterial.method_24146(class_1921::method_65052), packedLight, class_4608.field_21444, bannerPatternAtlas.method_4608(bannerMaterial.method_24147()), false, hasFoil, bannerAndColor.comp_2430().method_7787(), null, outlineColor);
        }
        return key;
    }

    private static int renderBasicWing(class_630 wingModel, class_4587 poseStack, class_11659 nodeCollector, int packedLight, @Nullable class_2960 playerTexture, boolean hasFoil, int outlineColor, int key) {
        class_2960 elytraTexture = playerTexture == null ? VANILLA_WINGS_LOCATION : playerTexture;
        nodeCollector.method_73529(key++).method_73494(wingModel, poseStack, class_1921.method_25448((class_2960)elytraTexture), packedLight, class_4608.field_21444, null, false, hasFoil, -1, null, outlineColor);
        if (hasFoil) {
            nodeCollector.method_73529(key++).method_73494(wingModel, poseStack, class_1921.method_27949(), packedLight, class_4608.field_21444, null, false, true, -1, null, outlineColor);
        }
        return key;
    }

    @NotNull
    private static class_1059 getAtlas(class_2960 location) {
        return class_310.method_1551().method_72703().method_73025(location);
    }

    private static <S extends class_10034> void renderWingTrim(class_630 wingModel, class_1799 wingStack, class_4587 poseStack, class_11659 nodeCollector, int packedLight, CustomizableElytraItem wingItem, boolean hasFoil, int outlineColor, int key) {
        Optional<class_8053> armorTrim = wingItem.getArmorTrim(wingStack);
        armorTrim.ifPresent(trim -> {
            class_1058 sprite = elytraTrimLookup.apply((class_8053)trim);
            class_1921 renderType = class_4722.method_48480((boolean)((class_8056)trim.comp_3180().comp_349()).comp_1905());
            nodeCollector.method_73529(key).method_73494(wingModel, poseStack, renderType, packedLight, class_4608.field_21444, sprite, false, hasFoil, -1, null, outlineColor);
        });
    }

    private static class_2960 getGrayscaleTexture(@Nullable class_2960 playerTexture) {
        if (playerTexture != null) {
            return TextureUtils.getGrayscale(playerTexture);
        }
        return TEXTURE_GRAYSCALE_ELYTRA;
    }

    private static class_2960 getTextureLocation(class_5321<class_2582> bannerIn) {
        return class_2960.method_60655((String)"customizableelytra", (String)("entity/elytra_banner/" + bannerIn.method_29177().method_12832()));
    }
}

