/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.item;

import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.item.components.GlowingWing;
import com.hidoni.customizableelytra.item.components.HiddenCape;
import com.hidoni.customizableelytra.registry.ModDataComponents;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_8053;
import net.minecraft.class_9282;
import net.minecraft.class_9307;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class ElytraWingItem
extends class_1792
implements CustomizableElytraItem {
    public ElytraWingItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public boolean isDyed(@NotNull class_1799 stack) {
        return stack.method_57826(class_9334.field_49644);
    }

    @Override
    public int getColor(@NotNull class_1799 stack) {
        if (this.isDyed(stack)) {
            return class_9282.method_57470((class_1799)stack, (int)-1);
        }
        if (this.hasBanner(stack)) {
            return Objects.requireNonNull((class_1767)stack.method_58694(class_9334.field_49620)).method_7787();
        }
        return -1;
    }

    @Override
    public boolean isCustomized(@NotNull class_1799 stack) {
        return this.isDyed(stack) || this.hasBanner(stack) || this.isCapeHidden(stack) || this.isGlowing(stack) || this.hasArmorTrim(stack);
    }

    @Override
    public boolean canDye(@NotNull class_1799 stack) {
        return !this.hasBanner(stack);
    }

    @Override
    public boolean canApplyBanner(@NotNull class_1799 stack) {
        return !this.hasBanner(stack);
    }

    @Override
    public boolean hasBanner(@NotNull class_1799 stack) {
        return stack.method_57826(class_9334.field_49620);
    }

    @Override
    public class_1767 getBaseColor(@NotNull class_1799 stack) {
        return (class_1767)stack.method_58694(class_9334.field_49620);
    }

    @Override
    public class_9307 getBannerPatterns(@NotNull class_1799 stack) {
        return (class_9307)stack.method_58695(class_9334.field_49619, (Object)class_9307.field_49404);
    }

    @Override
    public void setBanner(@NotNull class_1799 stack, @NotNull class_1799 banner) {
        class_1767 base = ((class_1746)banner.method_7909()).method_7706();
        stack.method_57381(class_9334.field_49644);
        stack.method_57379(class_9334.field_49620, (Object)base);
        stack.method_57379(class_9334.field_49619, (Object)((class_9307)banner.method_58694(class_9334.field_49619)));
    }

    @Override
    public boolean isGlowing(@NotNull class_1799 stack) {
        return stack.method_57826((class_9331)ModDataComponents.GLOWING.get());
    }

    @Override
    public void setGlowing(@NotNull class_1799 stack, boolean glowing) {
        stack.method_57379((class_9331)ModDataComponents.GLOWING.get(), (Object)new GlowingWing(glowing));
    }

    @Override
    public boolean isCapeHidden(@NotNull class_1799 stack) {
        return stack.method_57826((class_9331)ModDataComponents.CAPE_HIDDEN.get());
    }

    @Override
    public void setCapeHidden(@NotNull class_1799 stack, boolean capeHidden) {
        stack.method_57379((class_9331)ModDataComponents.CAPE_HIDDEN.get(), (Object)new HiddenCape(capeHidden));
    }

    @Override
    public boolean hasArmorTrim(@NotNull class_1799 stack) {
        return stack.method_57826(class_9334.field_49607);
    }

    @Override
    public Optional<class_8053> getArmorTrim(@NotNull class_1799 stack) {
        return Optional.ofNullable((class_8053)stack.method_58694(class_9334.field_49607));
    }

    @Override
    public void setArmorTrim(@NotNull class_1799 stack, @NotNull class_8053 trim) {
        stack.method_57379(class_9334.field_49607, (Object)trim);
    }
}

