/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.data.client;

import com.hidoni.customizableelytra.client.CustomizableElytraDyeItemTintSource;
import com.hidoni.customizableelytra.client.CustomizableElytraTrimMaterialProperty;
import com.hidoni.customizableelytra.registry.ModItems;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.client.color.item.Dye;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.conditional.Broken;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.TrimMaterialProperty;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.EquipmentAssets;

public class ModItemModelGenerators
extends ItemModelGenerators {
    public ModItemModelGenerators(ItemModelOutput itemModelOutput, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        super(itemModelOutput, modelOutput);
    }

    private void generateNonArmorTrimmableItem(Item item) {
        ResourceLocation modelLocation = ModelLocationUtils.getModelLocation((Item)item);
        ResourceLocation itemTexture = TextureMapping.getItemTexture((Item)item);
        String itemPath = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        ArrayList<SelectItemModel.SwitchCase> trims = new ArrayList<SelectItemModel.SwitchCase>(TRIM_MATERIAL_MODELS.size());
        for (ItemModelGenerators.TrimMaterialData trim : TRIM_MATERIAL_MODELS) {
            ResourceLocation trimModelLocation = modelLocation.withSuffix("_" + trim.assets().base().suffix() + "_trim");
            ResourceLocation trimItemTexture = ResourceLocation.withDefaultNamespace((String)("trims/items/" + itemPath + "_trim_" + trim.assets().assetId(EquipmentAssets.ELYTRA).suffix()));
            this.generateLayeredItem(trimModelLocation, itemTexture, trimItemTexture);
            ItemModel.Unbaked trimModel = ItemModelUtils.tintedModel((ResourceLocation)trimModelLocation, (ItemTintSource[])new ItemTintSource[]{new Dye(-1)});
            trims.add(ItemModelUtils.when((Object)trim.materialKey(), (ItemModel.Unbaked)trimModel));
        }
        ModelTemplates.FLAT_ITEM.create(modelLocation, TextureMapping.layer0((ResourceLocation)itemTexture), this.modelOutput);
        ItemModel.Unbaked defaultModel = ItemModelUtils.tintedModel((ResourceLocation)modelLocation, (ItemTintSource[])new ItemTintSource[]{new Dye(-1)});
        this.itemModelOutput.accept(item, ItemModelUtils.select((SelectItemModelProperty)new TrimMaterialProperty(), (ItemModel.Unbaked)defaultModel, trims));
    }

    private static ResourceLocation getModelLocationWithPrefix(Item elytraItem, String prefix) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)elytraItem);
        return key.withPrefix("item/" + prefix);
    }

    private static ResourceLocation getModelLocationWithPrefixAndSuffix(Item elytraItem, String prefix, String suffix) {
        return ModItemModelGenerators.getModelLocationWithPrefix(elytraItem, prefix).withSuffix(suffix);
    }

    private static ResourceLocation getItemTextureWithPrefix(Item elytraItem, String prefix) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)elytraItem);
        return key.withPrefix("item/" + prefix);
    }

    private static ResourceLocation getItemTextureWithPrefixAndSuffix(Item elytraItem, String prefix, String suffix) {
        return ModItemModelGenerators.getItemTextureWithPrefix(elytraItem, prefix).withSuffix(suffix);
    }

    private ItemModel.Unbaked generateElytraWingModel(Item elytraItem, boolean broken, boolean rightWing) {
        String prefix = broken ? "broken_" : "";
        String suffix = rightWing ? "_right" : "_left";
        ResourceLocation modelLocation = ModItemModelGenerators.getModelLocationWithPrefixAndSuffix(elytraItem, prefix, suffix);
        ResourceLocation itemTexture = ResourceLocation.fromNamespaceAndPath((String)"customizableelytra", (String)ModItemModelGenerators.getItemTextureWithPrefixAndSuffix(elytraItem, prefix, suffix).getPath());
        String itemPath = BuiltInRegistries.ITEM.getKey((Object)elytraItem).getPath();
        ArrayList<SelectItemModel.SwitchCase> trims = new ArrayList<SelectItemModel.SwitchCase>(TRIM_MATERIAL_MODELS.size());
        for (ItemModelGenerators.TrimMaterialData trim : TRIM_MATERIAL_MODELS) {
            ResourceLocation trimModelLocation = modelLocation.withSuffix("_" + trim.assets().base().suffix() + "_trim");
            ResourceLocation trimTextureLocation = ResourceLocation.withDefaultNamespace((String)("trims/items/" + itemPath + suffix + "_wing_trim_" + trim.assets().assetId(EquipmentAssets.ELYTRA).suffix()));
            this.generateLayeredItem(trimModelLocation, itemTexture, trimTextureLocation);
            ItemModel.Unbaked trimModel = ItemModelUtils.tintedModel((ResourceLocation)trimModelLocation, (ItemTintSource[])new ItemTintSource[]{new CustomizableElytraDyeItemTintSource(rightWing)});
            trims.add(ItemModelUtils.when((Object)trim.materialKey(), (ItemModel.Unbaked)trimModel));
        }
        ModelTemplates.FLAT_ITEM.create(modelLocation, TextureMapping.layer0((ResourceLocation)itemTexture), this.modelOutput);
        ItemModel.Unbaked defaultModel = ItemModelUtils.tintedModel((ResourceLocation)modelLocation, (ItemTintSource[])new ItemTintSource[]{new CustomizableElytraDyeItemTintSource(rightWing)});
        return ItemModelUtils.select((SelectItemModelProperty)new CustomizableElytraTrimMaterialProperty(rightWing), (ItemModel.Unbaked)defaultModel, trims);
    }

    private void generateElytraModel(Item elytraItem) {
        ItemModel.Unbaked unbroken = ItemModelUtils.composite((ItemModel.Unbaked[])new ItemModel.Unbaked[]{this.generateElytraWingModel(elytraItem, false, false), this.generateElytraWingModel(elytraItem, false, true)});
        ItemModel.Unbaked broken = ItemModelUtils.composite((ItemModel.Unbaked[])new ItemModel.Unbaked[]{this.generateElytraWingModel(elytraItem, true, false), this.generateElytraWingModel(elytraItem, true, true)});
        this.generateBooleanDispatch(elytraItem, (ConditionalItemModelProperty)new Broken(), broken, unbroken);
    }

    public void run() {
        this.generateElytraModel(Items.ELYTRA);
        this.generateNonArmorTrimmableItem(((Item)ModItems.ELYTRA_WING.get()).asItem());
    }
}

