/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.item;

import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.item.components.GlowingWing;
import com.hidoni.customizableelytra.item.components.HiddenCape;
import com.hidoni.customizableelytra.registry.ModDataComponents;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.jetbrains.annotations.NotNull;

public class ElytraWingItem
extends Item
implements CustomizableElytraItem {
    public ElytraWingItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean isDyed(@NotNull ItemStack stack) {
        return stack.has(DataComponents.DYED_COLOR);
    }

    @Override
    public int getColor(@NotNull ItemStack stack) {
        if (this.isDyed(stack)) {
            return DyedItemColor.getOrDefault((ItemStack)stack, (int)-1);
        }
        if (this.hasBanner(stack)) {
            return Objects.requireNonNull((DyeColor)stack.get(DataComponents.BASE_COLOR)).getTextureDiffuseColor();
        }
        return -1;
    }

    @Override
    public boolean isCustomized(@NotNull ItemStack stack) {
        return this.isDyed(stack) || this.hasBanner(stack) || this.isCapeHidden(stack) || this.isGlowing(stack) || this.hasArmorTrim(stack);
    }

    @Override
    public boolean canDye(@NotNull ItemStack stack) {
        return !this.hasBanner(stack);
    }

    @Override
    public boolean canApplyBanner(@NotNull ItemStack stack) {
        return !this.hasBanner(stack);
    }

    @Override
    public boolean hasBanner(@NotNull ItemStack stack) {
        return stack.has(DataComponents.BASE_COLOR);
    }

    @Override
    public DyeColor getBaseColor(@NotNull ItemStack stack) {
        return (DyeColor)stack.get(DataComponents.BASE_COLOR);
    }

    @Override
    public BannerPatternLayers getBannerPatterns(@NotNull ItemStack stack) {
        return (BannerPatternLayers)stack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
    }

    @Override
    public void setBanner(@NotNull ItemStack stack, @NotNull ItemStack banner) {
        DyeColor base = ((BannerItem)banner.getItem()).getColor();
        stack.remove(DataComponents.DYED_COLOR);
        stack.set(DataComponents.BASE_COLOR, (Object)base);
        stack.set(DataComponents.BANNER_PATTERNS, (Object)((BannerPatternLayers)banner.get(DataComponents.BANNER_PATTERNS)));
    }

    @Override
    public boolean isGlowing(@NotNull ItemStack stack) {
        return stack.has((DataComponentType)ModDataComponents.GLOWING.get());
    }

    @Override
    public void setGlowing(@NotNull ItemStack stack, boolean glowing) {
        stack.set((DataComponentType)ModDataComponents.GLOWING.get(), (Object)new GlowingWing(glowing));
    }

    @Override
    public boolean isCapeHidden(@NotNull ItemStack stack) {
        return stack.has((DataComponentType)ModDataComponents.CAPE_HIDDEN.get());
    }

    @Override
    public void setCapeHidden(@NotNull ItemStack stack, boolean capeHidden) {
        stack.set((DataComponentType)ModDataComponents.CAPE_HIDDEN.get(), (Object)new HiddenCape(capeHidden));
    }

    @Override
    public boolean hasArmorTrim(@NotNull ItemStack stack) {
        return stack.has(DataComponents.TRIM);
    }

    @Override
    public Optional<ArmorTrim> getArmorTrim(@NotNull ItemStack stack) {
        return Optional.ofNullable((ArmorTrim)stack.get(DataComponents.TRIM));
    }

    @Override
    public void setArmorTrim(@NotNull ItemStack stack, @NotNull ArmorTrim trim) {
        stack.set(DataComponents.TRIM, (Object)trim);
    }
}

