/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.mixin;

import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.item.components.ElytraCustomization;
import com.hidoni.customizableelytra.registry.ModDataComponents;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SmithingTrimRecipe.class})
public class SmithingTrimRecipeMixin {
    @Shadow
    @Final
    Holder<TrimPattern> pattern;

    @Inject(method={"assemble(Lnet/minecraft/world/item/crafting/SmithingRecipeInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")}, cancellable=true)
    private void replaceTrimComponentOnElytra(SmithingRecipeInput inv, HolderLookup.Provider lookupProvider, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack returnStack = (ItemStack)cir.getReturnValue();
        if (returnStack.isEmpty() || !ElytraUtils.isElytra(returnStack) || !returnStack.has(DataComponents.TRIM)) {
            return;
        }
        Optional trimMaterial = TrimMaterials.getFromIngredient((HolderLookup.Provider)lookupProvider, (ItemStack)inv.addition());
        if (trimMaterial.isEmpty()) {
            return;
        }
        ArmorTrim trim = (ArmorTrim)returnStack.remove(DataComponents.TRIM);
        ElytraCustomization elytraCustomization = CustomizationUtils.getElytraCustomization(returnStack);
        if (elytraCustomization.leftWing().has(DataComponents.TRIM) && elytraCustomization.rightWing().has(DataComponents.TRIM)) {
            ArmorTrim newTrim = new ArmorTrim((Holder)trimMaterial.get(), this.pattern);
            if (Objects.requireNonNull((ArmorTrim)elytraCustomization.leftWing().get(DataComponents.TRIM)).equals((Object)newTrim) && Objects.requireNonNull((ArmorTrim)elytraCustomization.rightWing().get(DataComponents.TRIM)).equals((Object)newTrim)) {
                cir.setReturnValue((Object)ItemStack.EMPTY);
                return;
            }
        }
        elytraCustomization = elytraCustomization.copy();
        elytraCustomization.leftWing().set(DataComponents.TRIM, (Object)trim);
        elytraCustomization.rightWing().set(DataComponents.TRIM, (Object)trim);
        returnStack.set((DataComponentType)ModDataComponents.ELYTRA_CUSTOMIZATION.get(), (Object)elytraCustomization);
    }
}

