/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.platform;

import com.hidoni.customizableelytra.platform.services.IRegistryHelper;
import com.hidoni.customizableelytra.registry.RegistryEntry;
import com.hidoni.customizableelytra.registry.RegistryProvider;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class ForgeRegistryHelper
implements IRegistryHelper {
    private static BusGroup busGroup;

    public static void setBusGroup(BusGroup busGroup) {
        ForgeRegistryHelper.busGroup = busGroup;
    }

    @Override
    public <T> RegistryProvider<T> getRegistry(ResourceKey<? extends Registry<T>> resourceKey) {
        final DeferredRegister deferredRegister = DeferredRegister.create(resourceKey, (String)"customizableelytra");
        deferredRegister.register(busGroup);
        return new RegistryProvider<T>(this){

            @Override
            public <I extends T> RegistryEntry<T, I> register(ResourceLocation location, Supplier<? extends I> entrySupplier) {
                final RegistryObject registered = deferredRegister.register(location.getPath(), entrySupplier);
                return new RegistryEntry<T, I>(this){

                    @Override
                    public ResourceLocation getResourceLocation() {
                        return registered.getId();
                    }

                    @Override
                    @Nullable
                    public ResourceKey<T> getResourceKey() {
                        return registered.getKey();
                    }

                    @Override
                    public Holder<T> getHolder() {
                        return (Holder)registered.getHolder().orElseThrow(() -> new RuntimeException("No holder present for " + String.valueOf(this.getResourceLocation())));
                    }

                    @Override
                    public I get() {
                        return registered.get();
                    }
                };
            }
        };
    }
}

