/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.recipe;

import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.item.components.ElytraCustomization;
import com.hidoni.customizableelytra.registry.ModDataComponents;
import com.hidoni.customizableelytra.registry.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.jetbrains.annotations.NotNull;

public class ElytraBannerRecipe
extends CustomRecipe {
    public ElytraBannerRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level level) {
        CustomizableElytraItem wingItem;
        ItemStack stack;
        ItemStack customizableStack = ItemStack.EMPTY;
        ItemStack bannerStack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (ElytraUtils.isElytra(stack) || stack.getItem() instanceof CustomizableElytraItem) {
                if (!customizableStack.isEmpty()) {
                    return false;
                }
                BannerPatternLayers bannerpatternlayers = (BannerPatternLayers)customizableStack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
                if (!bannerpatternlayers.layers().isEmpty()) {
                    return false;
                }
                customizableStack = stack;
                continue;
            }
            if (!(stack.getItem() instanceof BannerItem)) continue;
            if (!bannerStack.isEmpty()) {
                return false;
            }
            bannerStack = stack;
        }
        if (customizableStack.isEmpty() || bannerStack.isEmpty()) {
            return false;
        }
        stack = customizableStack.getItem();
        if (stack instanceof CustomizableElytraItem && ElytraBannerRecipe.isWingAlreadyCustomized(customizableStack, wingItem = (CustomizableElytraItem)stack)) {
            return false;
        }
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack);
        ItemStack leftWing = customization.leftWing();
        ItemStack rightWing = customization.rightWing();
        CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.getItem();
        CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.getItem();
        return ElytraBannerRecipe.canWingBeCustomized(leftWing, leftWingItem) && (ElytraBannerRecipe.canWingBeCustomized(rightWing, rightWingItem) || !ElytraBannerRecipe.isWingAlreadyCustomized(leftWing, leftWingItem) || !ElytraBannerRecipe.isWingAlreadyCustomized(rightWing, rightWingItem));
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider provider) {
        ItemStack stack;
        ItemStack customizableStack = ItemStack.EMPTY;
        ItemStack bannerStack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (ElytraUtils.isElytra(stack) || stack.getItem() instanceof CustomizableElytraItem) {
                if (!customizableStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                customizableStack = stack.copy();
                continue;
            }
            if (!(stack.getItem() instanceof BannerItem)) continue;
            if (!bannerStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            bannerStack = stack;
        }
        if (customizableStack.isEmpty() || bannerStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        stack = customizableStack.getItem();
        if (stack instanceof CustomizableElytraItem) {
            CustomizableElytraItem wingItem = (CustomizableElytraItem)stack;
            if (ElytraBannerRecipe.isWingAlreadyCustomized(customizableStack, wingItem)) {
                return ItemStack.EMPTY;
            }
            ElytraBannerRecipe.modifyWing(customizableStack, bannerStack, wingItem);
        } else {
            ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack).copy();
            ItemStack leftWing = customization.leftWing();
            ItemStack rightWing = customization.rightWing();
            CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.getItem();
            CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.getItem();
            if (!ElytraBannerRecipe.canWingBeCustomized(leftWing, leftWingItem) || !ElytraBannerRecipe.canWingBeCustomized(rightWing, rightWingItem) || ElytraBannerRecipe.isWingAlreadyCustomized(leftWing, leftWingItem) && ElytraBannerRecipe.isWingAlreadyCustomized(rightWing, rightWingItem)) {
                return ItemStack.EMPTY;
            }
            ElytraBannerRecipe.modifyWing(leftWing, bannerStack, leftWingItem);
            ElytraBannerRecipe.modifyWing(rightWing, bannerStack, rightWingItem);
            customizableStack.set((DataComponentType)ModDataComponents.ELYTRA_CUSTOMIZATION.get(), (Object)customization);
        }
        return customizableStack;
    }

    private static void modifyWing(ItemStack wingStack, ItemStack modifier, CustomizableElytraItem wingItem) {
        wingItem.setBanner(wingStack, modifier);
    }

    private static boolean isWingAlreadyCustomized(ItemStack wingStack, CustomizableElytraItem wingItem) {
        return wingItem.hasBanner(wingStack);
    }

    private static boolean canWingBeCustomized(ItemStack wingStack, CustomizableElytraItem wingItem) {
        return wingItem.canApplyBanner(wingStack);
    }

    @NotNull
    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipes.ELYTRA_BANNER_RECIPE.get();
    }
}

