/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.recipe;

import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.item.components.ElytraCustomization;
import com.hidoni.customizableelytra.registry.ModDataComponents;
import com.hidoni.customizableelytra.registry.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ElytraDyeRecipe
extends CustomRecipe {
    public ElytraDyeRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level level) {
        ItemStack customizableStack = ItemStack.EMPTY;
        ArrayList<DyeItem> dyes = new ArrayList<DyeItem>();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (ElytraUtils.isElytra(stack)) {
                if (!customizableStack.isEmpty()) {
                    return false;
                }
                customizableStack = stack;
                continue;
            }
            Item item = stack.getItem();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dyeItem = (DyeItem)item;
            dyes.add(dyeItem);
        }
        if (customizableStack.isEmpty() || dyes.isEmpty()) {
            return false;
        }
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack);
        ItemStack leftWing = customization.leftWing();
        ItemStack rightWing = customization.rightWing();
        CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.getItem();
        CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.getItem();
        return ElytraDyeRecipe.canWingBeCustomized(leftWing, leftWingItem) && ElytraDyeRecipe.canWingBeCustomized(rightWing, rightWingItem);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider provider) {
        ItemStack customizableStack = ItemStack.EMPTY;
        ArrayList<DyeItem> dyes = new ArrayList<DyeItem>();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (ElytraUtils.isElytra(stack)) {
                if (!customizableStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                customizableStack = stack.copy();
                continue;
            }
            Item item = stack.getItem();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dyeItem = (DyeItem)item;
            dyes.add(dyeItem);
        }
        if (customizableStack.isEmpty() || dyes.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack);
        ItemStack leftWing = customization.leftWing();
        ItemStack rightWing = customization.rightWing();
        CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.getItem();
        CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.getItem();
        if (!ElytraDyeRecipe.canWingBeCustomized(leftWing, leftWingItem) || !ElytraDyeRecipe.canWingBeCustomized(rightWing, rightWingItem)) {
            return ItemStack.EMPTY;
        }
        customizableStack.set((DataComponentType)ModDataComponents.ELYTRA_CUSTOMIZATION.get(), (Object)new ElytraCustomization(ElytraDyeRecipe.modifyWing(leftWing, dyes), ElytraDyeRecipe.modifyWing(rightWing, dyes)));
        return customizableStack;
    }

    private static ItemStack modifyWing(ItemStack wingStack, List<DyeItem> modifiers) {
        return DyedItemColor.applyDyes((ItemStack)wingStack, modifiers);
    }

    private static boolean canWingBeCustomized(ItemStack wingStack, CustomizableElytraItem wingItem) {
        return wingItem.canDye(wingStack);
    }

    @NotNull
    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipes.ELYTRA_DYE_RECIPE.get();
    }
}

