/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.recipe;

import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.item.components.ElytraCustomization;
import com.hidoni.customizableelytra.registry.ModDataComponents;
import com.hidoni.customizableelytra.registry.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ElytraMiscellaneousCustomizationRecipe
extends CustomRecipe {
    private static final Ingredient CUSTOMIZATION_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_INK_SAC, Items.PAPER});

    public ElytraMiscellaneousCustomizationRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level level) {
        CustomizableElytraItem wingItem;
        ItemStack stack;
        ItemStack customizableStack = ItemStack.EMPTY;
        ItemStack modifierStack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (ElytraUtils.isElytra(stack) || stack.getItem() instanceof CustomizableElytraItem) {
                if (!customizableStack.isEmpty()) {
                    return false;
                }
                customizableStack = stack;
                continue;
            }
            if (!CUSTOMIZATION_INGREDIENT.test(stack)) continue;
            if (!modifierStack.isEmpty()) {
                return false;
            }
            modifierStack = stack;
        }
        if (customizableStack.isEmpty() || modifierStack.isEmpty()) {
            return false;
        }
        stack = customizableStack.getItem();
        if (stack instanceof CustomizableElytraItem && ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(customizableStack, modifierStack, wingItem = (CustomizableElytraItem)stack)) {
            return false;
        }
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack);
        ItemStack leftWing = customization.leftWing();
        ItemStack rightWing = customization.rightWing();
        CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.getItem();
        CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.getItem();
        return !ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(leftWing, modifierStack, leftWingItem) || !ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(rightWing, modifierStack, rightWingItem);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider provider) {
        ItemStack stack;
        ItemStack customizableStack = ItemStack.EMPTY;
        ItemStack modifierStack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (ElytraUtils.isElytra(stack) || stack.getItem() instanceof CustomizableElytraItem) {
                if (!customizableStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                customizableStack = stack.copy();
                continue;
            }
            if (!CUSTOMIZATION_INGREDIENT.test(stack)) continue;
            if (!modifierStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            modifierStack = stack;
        }
        if (customizableStack.isEmpty() || modifierStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        stack = customizableStack.getItem();
        if (stack instanceof CustomizableElytraItem) {
            CustomizableElytraItem wingItem = (CustomizableElytraItem)stack;
            if (ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(customizableStack, modifierStack, wingItem)) {
                return ItemStack.EMPTY;
            }
            ElytraMiscellaneousCustomizationRecipe.modifyWing(customizableStack, modifierStack, wingItem);
        } else {
            ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack).copy();
            ItemStack leftWing = customization.leftWing();
            ItemStack rightWing = customization.rightWing();
            CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.getItem();
            CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.getItem();
            if (ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(leftWing, modifierStack, leftWingItem) && ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(rightWing, modifierStack, rightWingItem)) {
                return ItemStack.EMPTY;
            }
            ElytraMiscellaneousCustomizationRecipe.modifyWing(leftWing, modifierStack, (CustomizableElytraItem)leftWing.getItem());
            ElytraMiscellaneousCustomizationRecipe.modifyWing(rightWing, modifierStack, (CustomizableElytraItem)rightWing.getItem());
            customizableStack.set((DataComponentType)ModDataComponents.ELYTRA_CUSTOMIZATION.get(), (Object)customization);
        }
        return customizableStack;
    }

    private static void modifyWing(ItemStack wingStack, ItemStack modifier, CustomizableElytraItem wingItem) {
        if (modifier.is(Items.GLOW_INK_SAC)) {
            wingItem.setGlowing(wingStack, true);
        } else {
            wingItem.setCapeHidden(wingStack, true);
        }
    }

    private static boolean isWingAlreadyCustomized(ItemStack wingStack, ItemStack modifier, CustomizableElytraItem wingItem) {
        if (modifier.is(Items.GLOW_INK_SAC)) {
            return wingItem.isGlowing(wingStack);
        }
        return wingItem.isCapeHidden(wingStack);
    }

    @NotNull
    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipes.ELYTRA_MISCELLANEOUS_CUSTOMIZATION_RECIPE.get();
    }
}

