package com.hidoni.customizableelytra.recipe;

import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.item.components.ElytraCustomization;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.registry.ModDataComponents;
import com.hidoni.customizableelytra.registry.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.*;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ElytraMiscellaneousCustomizationRecipe extends CustomRecipe {
    private static final Ingredient CUSTOMIZATION_INGREDIENT = Ingredient.of(Items.GLOW_INK_SAC, Items.PAPER);

    public ElytraMiscellaneousCustomizationRecipe(CraftingBookCategory category) {
        super(category);
    }

    @Override
    public boolean matches(@NotNull CraftingInput inv, @NotNull Level level) {
        ItemStack customizableStack = ItemStack.EMPTY;
        ItemStack modifierStack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); i++) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) {
                continue;
            }
            if (ElytraUtils.isElytra(stack) || stack.getItem() instanceof CustomizableElytraItem) {
                if (!customizableStack.isEmpty()) {
                    return false;
                }
                customizableStack = stack;
            } else if (CUSTOMIZATION_INGREDIENT.test(stack)) {
                if (!modifierStack.isEmpty()) {
                    return false;
                }
                modifierStack = stack;
            }
        }
        if (customizableStack.isEmpty() || modifierStack.isEmpty()) {
            return false;
        }
        if (customizableStack.getItem() instanceof CustomizableElytraItem wingItem && isWingAlreadyCustomized(customizableStack, modifierStack, wingItem)) {
            return false;
        }
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack);
        ItemStack leftWing = customization.leftWing();
        ItemStack rightWing = customization.rightWing();
        CustomizableElytraItem leftWingItem = (CustomizableElytraItem) leftWing.getItem();
        CustomizableElytraItem rightWingItem = (CustomizableElytraItem) rightWing.getItem();
        return !isWingAlreadyCustomized(leftWing, modifierStack, leftWingItem) || !isWingAlreadyCustomized(rightWing, modifierStack, rightWingItem);
    }

    @Override
    public @NotNull ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider provider) {
        ItemStack customizableStack = ItemStack.EMPTY;
        ItemStack modifierStack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); i++) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) {
                continue;
            }
            if (ElytraUtils.isElytra(stack) || stack.getItem() instanceof CustomizableElytraItem) {
                if (!customizableStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                customizableStack = stack.copy();
            } else if (CUSTOMIZATION_INGREDIENT.test(stack)) {
                if (!modifierStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                modifierStack = stack;
            }
        }
        if (customizableStack.isEmpty() || modifierStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (customizableStack.getItem() instanceof CustomizableElytraItem wingItem) {
            if (isWingAlreadyCustomized(customizableStack, modifierStack, wingItem)) {
                return ItemStack.EMPTY;
            }
            modifyWing(customizableStack, modifierStack, wingItem);
        } else {
            ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack).copy();
            ItemStack leftWing = customization.leftWing();
            ItemStack rightWing = customization.rightWing();
            CustomizableElytraItem leftWingItem = (CustomizableElytraItem) leftWing.getItem();
            CustomizableElytraItem rightWingItem = (CustomizableElytraItem) rightWing.getItem();
            if (isWingAlreadyCustomized(leftWing, modifierStack, leftWingItem) && isWingAlreadyCustomized(rightWing, modifierStack, rightWingItem)) {
                return ItemStack.EMPTY;
            }
            modifyWing(leftWing, modifierStack, (CustomizableElytraItem) leftWing.getItem());
            modifyWing(rightWing, modifierStack, (CustomizableElytraItem) rightWing.getItem());
            customizableStack.set(ModDataComponents.ELYTRA_CUSTOMIZATION.get(), customization);
        }
        return customizableStack;
    }

    private static void modifyWing(ItemStack wingStack, ItemStack modifier, CustomizableElytraItem wingItem) {
        if (modifier.is(Items.GLOW_INK_SAC)) {
            wingItem.setGlowing(wingStack, true);
        } else {
            wingItem.setCapeHidden(wingStack, true);
        }
    }

    private static boolean isWingAlreadyCustomized(ItemStack wingStack, ItemStack modifier, CustomizableElytraItem wingItem) {
        if (modifier.is(Items.GLOW_INK_SAC)) {
            return wingItem.isGlowing(wingStack);
        } else {
            return wingItem.isCapeHidden(wingStack);
        }
    }

    @Override
    public @NotNull RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return ModRecipes.ELYTRA_MISCELLANEOUS_CUSTOMIZATION_RECIPE.get();
    }
}
