package net.spacerulerwill.skygrid_reloaded.mixin;

import net.minecraft.class_2960;
import net.minecraft.class_5293;
import net.minecraft.class_6880;
import net.minecraft.class_7145;
import net.minecraft.class_8100;
import net.spacerulerwill.skygrid_reloaded.Constants;
import net.spacerulerwill.skygrid_reloaded.ui.screen.CustomizeSkyGridScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_8100.class)
public class WorldCreationUiStateMixin {
    /*
    This mixin allows the customize button for our skygrid world preset in the world creation menu to open
    our CustomizeSkyGridScreen
     */
    @Inject(method = "getPresetEditor", at = @At("HEAD"), cancellable = true)
    private void injected(CallbackInfoReturnable<class_5293> cir) {
        class_6880<class_7145> registryEntry = ((class_8100) (Object) this).method_48730().comp_1238();
        if (registryEntry != null && registryEntry.method_40226(class_2960.method_60655(Constants.MOD_ID, "skygrid"))) {
            cir.setReturnValue((parent, generatorOptionsHolder) ->
                    new CustomizeSkyGridScreen(parent));
            cir.cancel();
        }
    }
}