package net.spacerulerwill.skygrid_reloaded.mixin;

import net.minecraft.class_5363;
import net.minecraft.class_7145;
import net.spacerulerwill.skygrid_reloaded.util.WorldPresetExtension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Map;
import java.util.Optional;

/*
This mixin provides two methods for getting the default nether and end generation options.
There was already one implemented for the overworld, but I needed these 2 also.
 */
@Mixin(class_7145.class)
public class WorldPresetMixin implements WorldPresetExtension {
    @Shadow
    private Map<class_5363, class_5363> dimensions;

    @Override
    public Optional<class_5363> skygrid_reloaded$GetNether() {
        return Optional.ofNullable(dimensions.get(class_5363.field_25413));
    }

    @Override
    public Optional<class_5363> skygrid_reloaded$GetEnd() {
        return Optional.ofNullable(dimensions.get(class_5363.field_25414));
    }
}
