package net.spacerulerwill.skygrid_reloaded.ui.screen;

import net.minecraft.class_151;
import net.minecraft.class_1959;
import net.minecraft.class_1973;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.spacerulerwill.skygrid_reloaded.util.CheckerboardColumnBiomeSourceSizeAccessor;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridChunkGeneratorConfig;
import net.spacerulerwill.skygrid_reloaded.worldgen.SkyGridConfig;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class SelectBiomesScreen extends DimensionSpecificCustomizableListWidgetScreen<SelectBiomesScreen.BiomeListWidgetEntry, class_6880<class_1959>> {
    private final class_2378<class_1959> biomeRegistry;

    public SelectBiomesScreen(CustomizeSkyGridScreen parent, class_2378<class_1959> biomeRegistry, class_5321<class_5363> initialDimension, SkyGridConfig currentConfig) {
        super(parent, initialDimension, currentConfig, class_2561.method_43471("createWorld.customize.skygrid.biomes"), class_2561.method_43471("createWorld.customize.skygrid.spawners.placeholder"), 15);
        this.biomeRegistry = biomeRegistry;
    }

    private SkyGridChunkGeneratorConfig getConfig() {
        SkyGridChunkGeneratorConfig config;
        if (this.currentDimension == class_5363.field_25412) {
            config = this.currentConfig.overworldConfig();
        } else if (this.currentDimension == class_5363.field_25413) {
            config = this.currentConfig.netherConfig();
        } else if (this.currentDimension == class_5363.field_25414) {
            config = this.currentConfig.endConfig();
        } else {
            throw new IllegalStateException("Current dimension is not one of overworld, nether or end: " + this.currentDimension.method_29177().method_42094());
        }
        return config;
    }

    @Override
    protected void onClear() {
        SkyGridChunkGeneratorConfig currentConfig = this.getConfig();
        class_1973 currentBiomeSouurce = currentConfig.checkerboardBiomeSource;
        this.getConfig().checkerboardBiomeSource = new class_1973(
                class_6885.method_40246(),
                ((CheckerboardColumnBiomeSourceSizeAccessor) currentBiomeSouurce).skygrid_reloaded$getSize()
        );
    }

    @Override
    protected Optional<class_6880<class_1959>> getThingFromString(String text) {
        try {
            return this.biomeRegistry
                    .method_17966(class_2960.method_60654(text))
                    .map(this.biomeRegistry::method_47983);
        } catch (class_151 e) {
            return Optional.empty();
        }
    }


    @Override
    protected List<AutocompleteListWidget.Entry> getAutocompleteSuggestions(String text) {
        List<AutocompleteListWidget.Entry> results = new ArrayList<>();
        if (text.isBlank()) {
            return results;
        }
        this.biomeRegistry.forEach(biome -> {
            String key = this.biomeRegistry.method_29113(biome).get().method_29177().method_42093("biome");
            String displayString = class_2561.method_43471(key).getString();
            String valueString = this.biomeRegistry.method_47983(biome).method_55840();

            if (displayString.trim().toLowerCase().startsWith(text) || valueString.startsWith(text)) {
                results.add(new AutocompleteListWidget.Entry(null, displayString, valueString, this.field_22793));
            }
        });
        return results;
    }

    @Override
    protected void onAdd(class_6880<class_1959> thing) {
        SkyGridChunkGeneratorConfig config = this.getConfig();
        if (config.checkerboardBiomeSource.method_28443().contains(thing)) {
            throw new IllegalStateException("Add button called while item to add is already present");
        }
        class_1973 currentBiomeSource = config.checkerboardBiomeSource;
        Set<class_6880<class_1959>> biomes = new LinkedHashSet<>(currentBiomeSource.method_28443());
        biomes.add(thing);
        config.checkerboardBiomeSource = new class_1973(
                class_6885.method_40242(biomes.stream().toList()),
                ((CheckerboardColumnBiomeSourceSizeAccessor) currentBiomeSource).skygrid_reloaded$getSize()
        );
        this.listWidget.addEntry(new BiomeListWidgetEntry(thing));
    }

    @Override
    protected boolean canAdd(class_6880<class_1959> thing) {
        return !this.getConfig().checkerboardBiomeSource.method_28443().contains(thing);
    }


    @Override
    protected void onDelete(BiomeListWidgetEntry entry) {
        SkyGridChunkGeneratorConfig currentConfig = this.getConfig();
        class_1973 currentBiomeSource = currentConfig.checkerboardBiomeSource;
        Set<class_6880<class_1959>> biomes = new LinkedHashSet<>(currentBiomeSource.method_28443());
        biomes.remove(entry.biome);
        this.getConfig().checkerboardBiomeSource = new class_1973(
                class_6885.method_40242(biomes.stream().toList()),
                ((CheckerboardColumnBiomeSourceSizeAccessor) currentBiomeSource).skygrid_reloaded$getSize()
        );
    }

    @Override
    protected List<BiomeListWidgetEntry> getEntriesFromConfig() {
        List<BiomeListWidgetEntry> entries = new ArrayList<>();
        Set<class_6880<class_1959>> biomes = this.getConfig().checkerboardBiomeSource.method_28443();
        for (class_6880<class_1959> biome : biomes) {
            entries.add(new BiomeListWidgetEntry(biome));
        }
        return entries;
    }


    protected class BiomeListWidgetEntry extends class_4280.class_4281<BiomeListWidgetEntry> {
        private final class_6880<class_1959> biome;

        public BiomeListWidgetEntry(class_6880<class_1959> biome) {
            this.biome = biome;
        }

        @Override
        public class_2561 method_37006() {
            return class_2561.method_43473();
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            String key = this.biome.method_40230().get().method_29177().method_42093("biome");
            context.method_51439(SelectBiomesScreen.this.field_22793, class_2561.method_43471(key), x + 3, y + 2, 16777215, false);
        }
    }
}
