package net.spacerulerwill.skygrid_reloaded.ui.widget;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_357;
import net.minecraft.class_5250;

public class IntSlider extends class_357 {
    private final int minValue;
    private final int maxValue;
    private final class_2561 text;
    private final Consumer<Integer> onValueChanged;

    public IntSlider(int x, int y, int width, int height, class_2561 text, int minValue, int maxValue, int initialValue, Consumer<Integer> onValueChanged) {
        super(x, y, width, height, class_2561.method_43473(), 0.0);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.text = text;
        this.onValueChanged = onValueChanged;

        // Clamp and set slider value
        this.field_22753 = (double) (initialValue - minValue) / (maxValue - minValue);
        this.method_25346();
    }

    public void setValue(int value) {
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException("Value " + value + " is out of range [" + minValue + ", " + maxValue + "]");
        }
        this.field_22753 = (double) (value - minValue) / (maxValue - minValue);
        this.onValueChanged.accept(value);
        this.method_25346();
    }

    @Override
    protected void method_25346() {
        this.method_25355(this.createMessage());
    }

    private class_5250 createMessage() {
        int currentValue = getIntValue();
        return this.text.method_27661()
                .method_10852(class_2561.method_43470(": "))
                .method_10852(class_2561.method_43470(String.valueOf(currentValue)));
    }

    private int getIntValue() {
        return (int) Math.round(this.field_22753 * (maxValue - minValue) + minValue);
    }

    @Override
    protected void method_25344() {
        int newValue = getIntValue();
        onValueChanged.accept(newValue);
        method_25346();
    }
}
